/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import journeymap.shadow.org.eclipse.jetty.websocket.api.Session;
import journeymap.shadow.org.eclipse.jetty.websocket.common.message.MessageAppender;
import journeymap.shadow.org.eclipse.jetty.websocket.common.message.MessageInputStream;

public class MessageReader
extends InputStreamReader
implements MessageAppender {
    private final MessageInputStream stream;

    public MessageReader(Session session) {
        this(new MessageInputStream(session));
    }

    public MessageReader(MessageInputStream stream) {
        super((InputStream)stream, StandardCharsets.UTF_8);
        this.stream = stream;
    }

    @Override
    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        this.stream.appendFrame(payload, isLast);
    }

    @Override
    public void messageComplete() {
        this.stream.messageComplete();
    }

    public void handlerComplete() {
        this.stream.handlerComplete();
    }
}

