/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import com.google.common.collect.ImmutableList;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBasaltColumns
extends WorldGenerator {
    private final int minHeight;
    private final int maxHeight;
    private final int minReach;
    private final int maxReach;
    private static final ImmutableList<Block> CAN_PLACE_ON = ImmutableList.of((Object)ModBlocks.BLACKSTONE.get(), (Object)ModBlocks.BASALT.get());

    public WorldGenBasaltColumns(int minHeight, int maxHeight, int minReach, int maxReach) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minReach = minReach;
        this.maxReach = maxReach;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int i = 32;
        if (!WorldGenBasaltColumns.canPlaceAt(world, i, x, y, z)) {
            return false;
        }
        int j = MathHelper.func_76136_a((Random)rand, (int)this.minHeight, (int)this.maxHeight);
        boolean flag = rand.nextFloat() < 0.9f;
        int size = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (int k = 0; k < l; ++k) {
            int randomZ;
            int randomX = x + MathHelper.func_76136_a((Random)rand, (int)(-size), (int)size);
            int i1 = j - Utils.distManhattan(randomX, y, randomZ = z + MathHelper.func_76136_a((Random)rand, (int)(-size), (int)size), x, y, z);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn(world, i, randomX, y, randomZ, i1, MathHelper.func_76136_a((Random)rand, (int)this.minReach, (int)this.maxReach));
        }
        return flag1;
    }

    private boolean placeColumn(World world, int seaLevel, int x, int y, int z, int p_65171_, int size) {
        boolean flag = false;
        for (int x1 = -size; x1 <= size; ++x1) {
            block1: for (int z1 = -size; z1 <= size; ++z1) {
                int offY;
                int offX = x1 + x;
                int offZ = z1 + z;
                int i = Utils.distManhattan(x, y, z, offX, y, offZ);
                int n = offY = WorldGenBasaltColumns.isAirOrLavaOcean(world, seaLevel, offX, y, offZ) ? WorldGenBasaltColumns.findSurfaceY(world, seaLevel, offX, y, offZ, i) : WorldGenBasaltColumns.findAirY(world, offX, y, offZ, i);
                if (offY < 0) continue;
                for (int j = p_65171_ - i / 2; j >= 0; --j) {
                    if (WorldGenBasaltColumns.isAirOrLavaOcean(world, seaLevel, offX, offY, offZ)) {
                        this.func_150516_a(world, offX, offY, offZ, ModBlocks.BASALT.get(), 0);
                        ++offY;
                        flag = true;
                        continue;
                    }
                    if (world.func_147439_a(offX, offY, offZ) != ModBlocks.BASALT.get()) continue block1;
                    ++offY;
                }
            }
        }
        return flag;
    }

    private static int findSurfaceY(World world, int seaLevel, int x, int y, int z, int p_65162_) {
        while (y > 1 && p_65162_ > 0) {
            --p_65162_;
            if (WorldGenBasaltColumns.canPlaceAt(world, seaLevel, x, y, z)) {
                return y;
            }
            --y;
        }
        return 0;
    }

    private static boolean canPlaceAt(World world, int seaLevel, int x, int y, int z) {
        if (!WorldGenBasaltColumns.isAirOrLavaOcean(world, seaLevel, x, y, z)) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        return !block.isAir((IBlockAccess)world, x, y, z) && CAN_PLACE_ON.contains((Object)block);
    }

    private static int findAirY(World world, int x, int y, int z, int p_65176_) {
        while (y < world.func_72940_L() && p_65176_ > 0) {
            --p_65176_;
            Block block = world.func_147439_a(x, y, z);
            if (!CAN_PLACE_ON.contains((Object)block)) {
                return 0;
            }
            if (block.isAir((IBlockAccess)world, x, y, z)) {
                return y;
            }
            ++y;
        }
        return 0;
    }

    private static boolean isAirOrLavaOcean(World world, int seaLevel, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || block.func_149688_o() == Material.field_151587_i && y <= seaLevel;
    }
}

