/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import ganymedes01.etfuturum.client.OpenGLHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public abstract class BlockModelBase
implements ISimpleBlockRenderingHandler {
    private final int modelID;
    private boolean inventory3D = true;

    protected BlockModelBase(int modelID) {
        this.modelID = modelID;
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (block.func_149701_w() == 1) {
            OpenGLHelper.blendFunc(770, 771);
            OpenGLHelper.enableBlend();
        }
        OpenGLHelper.translate(-0.5f, -0.5f, -0.5f);
        tessellator.func_78382_b();
        this.renderInventoryModel(block, meta, modelID, renderer, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
        tessellator.func_78381_a();
        OpenGLHelper.translate(0.5f, 0.5f, 0.5f);
        OpenGLHelper.disableBlend();
    }

    protected void renderInventoryModel(Block block, int meta, int modelId, RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.renderStandardInventoryCube(block, meta, this.modelID, renderer, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
    }

    protected void renderStandardInventoryCube(Block block, int meta, int modelId, RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, meta));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, meta));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, meta));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, meta));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, meta));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, meta));
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
    }

    protected boolean renderStandardWorldCube(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, double minX, double minY, double minZ, double maxF, double maxY, double maxZ) {
        renderer.func_147782_a(minX, minY, minZ, maxF, maxY, maxZ);
        return renderer.func_147784_q(block, x, y, z);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return this.inventory3D;
    }

    public int getRenderId() {
        return this.modelID;
    }

    public BlockModelBase set2DInventory() {
        this.inventory3D = false;
        return this;
    }

    public void drawStraightCrossedSquares(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.drawStraightCrossedSquares(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void drawStraightCrossedSquares(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        double minX = renderer.field_147859_h;
        double minY = renderer.field_147855_j;
        double minZ = renderer.field_147851_l;
        double maxX = renderer.field_147861_i;
        double maxY = renderer.field_147857_k;
        double maxZ = renderer.field_147853_m;
        renderer.func_147782_a(0.5, 0.0, 0.0, 0.5, 1.0, 1.0);
        this.renderFaceXNeg(renderer, block, dx + offx, dy + offy, dz + offz);
        this.renderFaceXPos(renderer, block, dx + offx, dy + offy, dz + offz);
        renderer.func_147782_a(0.0, 0.0, 0.5, 1.0, 1.0, 0.5);
        this.renderFaceZNeg(renderer, block, dx + offx, dy + offy, dz + offz);
        this.renderFaceZPos(renderer, block, dx + offx, dy + offy, dz + offz);
        renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void renderRawFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon, float r, float g, float b) {
        this.renderRawFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, 0, r, g, b);
    }

    public void renderRawFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon) {
        this.renderRawFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, 0);
    }

    public void renderRawFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon, int rotate) {
        this.renderRawFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, rotate, 1.0f, 1.0f, 1.0f);
    }

    public void renderRawFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon, int rotate, float r, float g, float b) {
        double endVInterpolated2;
        double endVInterpolated;
        double startUInterpolated2;
        double endUInterpolated;
        double startVInterpolated2;
        double startVInterpolated;
        double endUInterpolated2;
        double startUInterpolated;
        Tessellator tessellator = Tessellator.field_78398_a;
        double endX1 = endX;
        double startX2 = startX;
        double endX2 = endX;
        double endZ1 = endZ;
        double startZ2 = startZ;
        double endZ2 = endZ;
        switch (rotate) {
            case 1: {
                endUInterpolated2 = startUInterpolated = (double)iicon.func_94214_a(startU);
                startVInterpolated2 = startVInterpolated = (double)iicon.func_94207_b(startV);
                startUInterpolated2 = endUInterpolated = (double)iicon.func_94214_a(endU);
                endVInterpolated2 = endVInterpolated = (double)iicon.func_94207_b(endV);
                endZ2 = startZ;
                endZ1 = endZ;
                startZ2 = endZ;
                break;
            }
            case 2: {
                startUInterpolated2 = endUInterpolated = (double)iicon.func_94214_a(startU);
                endVInterpolated2 = endVInterpolated = (double)iicon.func_94207_b(startV);
                endUInterpolated2 = startUInterpolated = (double)iicon.func_94214_a(endU);
                startVInterpolated2 = startVInterpolated = (double)iicon.func_94207_b(endV);
                endX2 = startX;
                endX1 = endX;
                startX2 = endX;
                break;
            }
            case 3: {
                endUInterpolated2 = endUInterpolated = (double)iicon.func_94214_a(endU);
                startVInterpolated2 = endVInterpolated = (double)iicon.func_94207_b(endV);
                startUInterpolated2 = startUInterpolated = (double)iicon.func_94214_a(startU);
                endVInterpolated2 = startVInterpolated = (double)iicon.func_94207_b(startV);
                break;
            }
            default: {
                endUInterpolated2 = endUInterpolated = (double)iicon.func_94214_a(startU);
                startVInterpolated2 = endVInterpolated = (double)iicon.func_94207_b(startV);
                startUInterpolated2 = startUInterpolated = (double)iicon.func_94214_a(endU);
                endVInterpolated2 = startVInterpolated = (double)iicon.func_94207_b(endV);
            }
        }
        tessellator.func_78380_c(block.func_149677_c(renderer.field_147845_a, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z)));
        tessellator.func_78386_a(r, g, b);
        tessellator.func_78374_a(x + startX, y + startY, z + startZ, startUInterpolated, startVInterpolated);
        tessellator.func_78374_a(x + startX2, y + endY, z + startZ2, startUInterpolated2, startVInterpolated2);
        tessellator.func_78374_a(x + endX1, y + endY, z + endZ1, endUInterpolated, endVInterpolated);
        tessellator.func_78374_a(x + endX2, y + startY, z + endZ2, endUInterpolated2, endVInterpolated2);
    }

    public void renderRawDoubleSidedFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon, int rotate, float r, float g, float b) {
        if (rotate == 1) {
            this.renderRawFace(renderer, block, x, y, z, startX, endX, endY, startY, startZ, endZ, startU, startV, endU, endV, iicon, 1, r, g, b);
            this.renderRawFace(renderer, block, x, y, z, endX, startX, endY, startY, startZ, endZ, endU, endV, startU, startV, iicon, 1);
        } else if (rotate == 2) {
            this.renderRawFace(renderer, block, x, y, z, startX, endX, endY, startY, startZ, endZ, startU, startV, endU, endV, iicon, 2, r, g, b);
            this.renderRawFace(renderer, block, x, y, z, startX, endX, endY, startY, endZ, startZ, endU, endV, startU, startV, iicon, 2, r, g, b);
        } else {
            this.renderRawFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, rotate, r, g, b);
            this.renderRawFace(renderer, block, x, y, z, endX, startX, startY, endY, endZ, startZ, startU, startV, endU, endV, iicon, rotate, r, g, b);
        }
    }

    public void renderRawDoubleSidedFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon, int rotate) {
        this.renderRawDoubleSidedFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, rotate, 1.0f, 1.0f, 1.0f);
    }

    public void renderRawDoubleSidedFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon, float r, float g, float b) {
        this.renderRawDoubleSidedFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, 0, r, g, b);
    }

    public void renderRawDoubleSidedFace(RenderBlocks renderer, Block block, double x, double y, double z, double startX, double endX, double startY, double endY, double startZ, double endZ, double startU, double startV, double endU, double endV, IIcon iicon) {
        this.renderRawDoubleSidedFace(renderer, block, x, y, z, startX, endX, startY, endY, startZ, endZ, startU, startV, endU, endV, iicon, 0);
    }

    public void renderFaceYNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.renderFaceYNeg(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void renderFaceYNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        this.renderFaceYNeg(renderer, block, dx, dy, dz, offx, offy, offz, renderer.func_147793_a(block, renderer.field_147845_a, MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dy), MathHelper.func_76128_c((double)dz), 0));
    }

    public void renderFaceYNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        float f3 = 0.5f;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y - 1, z, 0)) {
            tessellator.func_78380_c(renderer.field_147855_j + Math.abs(offy) > 0.0 ? l : block.func_149677_c(renderer.field_147845_a, x, MathHelper.func_76128_c((double)(y - 1)), z));
            tessellator.func_78386_a(f3, f3, f3);
            renderer.func_147768_a(block, dx + offx, dy + offy, dz + offz, icon);
        }
    }

    public void renderFaceYPos(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.renderFaceYPos(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void renderFaceYPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        this.renderFaceYPos(renderer, block, dx, dy, dz, offx, offy, offz, renderer.func_147793_a(block, renderer.field_147845_a, MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dy), MathHelper.func_76128_c((double)dz), 1));
    }

    public void renderFaceYPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = block.func_149720_d(renderer.field_147845_a, x, y, z);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f4 = 1.0f;
        float f7 = f4 * f;
        float f8 = f4 * f1;
        float f9 = f4 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y + 1, z, 1)) {
            tessellator.func_78380_c(renderer.field_147857_k - Math.abs(offy) < 1.0 ? l : block.func_149677_c(renderer.field_147845_a, x, y + 1, z));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147806_b(block, dx + offx, dy + offy, dz + offz, icon);
        }
    }

    public void renderFaceZNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.renderFaceZNeg(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void renderFaceZNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        this.renderFaceZNeg(renderer, block, dx, dy, dz, offx, offy, offz, renderer.func_147793_a(block, renderer.field_147845_a, MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dy), MathHelper.func_76128_c((double)dz), 2));
    }

    public void renderFaceZNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        float f5 = 0.8f;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z - 1, 2)) {
            tessellator.func_78380_c(renderer.field_147851_l + Math.abs(offz) > 0.0 ? l : block.func_149677_c(renderer.field_147845_a, x, y, z - 1));
            tessellator.func_78386_a(f5, f5, f5);
            renderer.func_147761_c(block, dx + offx, dy + offy, dz + offz, icon);
        }
    }

    public void renderFaceZPos(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.renderFaceZPos(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void renderFaceZPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        this.renderFaceZPos(renderer, block, dx, dy, dz, offx, offy, offz, renderer.func_147793_a(block, renderer.field_147845_a, MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dy), MathHelper.func_76128_c((double)dz), 3));
    }

    public void renderFaceZPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        float f5 = 0.8f;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z + 1, 3)) {
            tessellator.func_78380_c(renderer.field_147853_m - Math.abs(offz) < 1.0 ? l : block.func_149677_c(renderer.field_147845_a, x, y, z + 1));
            tessellator.func_78386_a(f5, f5, f5);
            renderer.func_147734_d(block, dx + offx, dy + offy, dz + offz, icon);
        }
    }

    public void renderFaceXNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.renderFaceXNeg(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void renderFaceXNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        this.renderFaceXNeg(renderer, block, dx, dy, dz, offx, offy, offz, renderer.func_147793_a(block, renderer.field_147845_a, MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dy), MathHelper.func_76128_c((double)dz), 4));
    }

    public void renderFaceXNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        float f6 = 0.6f;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x - 1, y, z, 4)) {
            tessellator.func_78380_c(renderer.field_147859_h + Math.abs(offx) > 0.0 ? l : block.func_149677_c(renderer.field_147845_a, x - 1, y, z));
            tessellator.func_78386_a(f6, f6, f6);
            renderer.func_147798_e(block, dx + offx, dy + offy, dz + offz, icon);
        }
    }

    public void renderFaceXPos(RenderBlocks renderer, Block block, double dx, double dy, double dz) {
        this.renderFaceXPos(renderer, block, dx, dy, dz, 0.0, 0.0, 0.0);
    }

    public void renderFaceXPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz) {
        this.renderFaceXPos(renderer, block, dx, dy, dz, offx, offy, offz, renderer.func_147793_a(block, renderer.field_147845_a, MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dy), MathHelper.func_76128_c((double)dz), 5));
    }

    public void renderFaceXPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, double offx, double offy, double offz, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        float f6 = 0.6f;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x + 1, y, z, 5)) {
            tessellator.func_78380_c(renderer.field_147861_i - Math.abs(offx) < 1.0 ? l : block.func_149677_c(renderer.field_147845_a, x + 1, y, z));
            tessellator.func_78386_a(f6, f6, f6);
            renderer.func_147764_f(block, dx + offx, dy + offy, dz + offz, icon);
        }
    }
}

