/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.core.AELog;
import appeng.util.UUIDMatcher;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;

public class PlayerMappingsInitializer {
    private final Map<Integer, UUID> playerMappings;

    public PlayerMappingsInitializer(ConfigCategory playerList, FMLRelaunchLog log) {
        UUIDMatcher matcher = new UUIDMatcher();
        int capacity = playerList.size();
        this.playerMappings = new HashMap<Integer, UUID>(capacity);
        for (Map.Entry entry : playerList.getValues().entrySet()) {
            String maybeUUID = (String)entry.getKey();
            int id = ((Property)entry.getValue()).getInt();
            if (matcher.isUUID(maybeUUID)) {
                UUID UUIDString = UUID.fromString(maybeUUID);
                this.playerMappings.put(id, UUIDString);
                continue;
            }
            AELog.warning("The configuration for players contained an outdated entry instead an expected UUID " + maybeUUID + " for the player " + id + ". Please clean this up.", new Object[0]);
        }
    }

    public Map<Integer, UUID> getPlayerMappings() {
        return this.playerMappings;
    }
}

