/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.core.CommonUtils;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.CatalystInfo;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.InformationHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class IMCHandler {
    private static final Set<String> processedCatalystSenders = new HashSet<String>();

    private IMCHandler() {
    }

    public static void processIMC(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            String type = message.key;
            if (type == null || type.isEmpty() || !CommonUtils.isClient()) continue;
            switch (type) {
                case "registerHandlerInfo": {
                    IMCHandler.handleRegisterHandlerInfo(message);
                    break;
                }
                case "removeHandlerInfo": {
                    IMCHandler.handleRemoveHandlerInfo(message);
                    break;
                }
                case "registerCatalystInfo": {
                    IMCHandler.handleRegisterCatalystInfo(message);
                    break;
                }
                case "removeCatalystInfo": {
                    IMCHandler.handleRemoveCatalystInfo(message);
                    break;
                }
                case "addItemInfo": {
                    IMCHandler.handleAddItemInfo(message);
                }
            }
        }
    }

    private static void handleRegisterHandlerInfo(FMLInterModComms.IMCMessage message) {
        String itemName;
        String imageResource;
        String excludedModId;
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String handler = tag.func_74779_i("handler");
        NEIClientConfig.logger.info("Processing registerHandlerInfo `{}` from {}", new Object[]{handler, message.getSender()});
        String modName = tag.func_74779_i("modName");
        String modId = tag.func_74779_i("modId");
        boolean requiresMod = tag.func_74767_n("modRequired");
        String string = excludedModId = tag.func_74764_b("excludedModId") ? tag.func_74779_i("excludedModId") : null;
        if (handler.isEmpty() || modName.isEmpty() || modId.isEmpty()) {
            NEIClientConfig.logger.warn("Missing relevant information to registerHandlerInfo!");
            return;
        }
        if (requiresMod && !Loader.isModLoaded((String)modId)) {
            return;
        }
        if (excludedModId != null && Loader.isModLoaded((String)excludedModId)) {
            return;
        }
        HandlerInfo info = new HandlerInfo(handler, modName, modId, requiresMod, excludedModId);
        String string2 = imageResource = tag.func_74764_b("imageResource") ? tag.func_74779_i("imageResource") : null;
        if (imageResource != null && !imageResource.isEmpty()) {
            info.setImage(imageResource, tag.func_74762_e("imageX"), tag.func_74762_e("imageY"), tag.func_74762_e("imageWidth"), tag.func_74762_e("imageHeight"));
        }
        if (!info.hasImageOrItem() && (itemName = tag.func_74779_i("itemName")) != null && !itemName.isEmpty()) {
            info.setItem(itemName, tag.func_74764_b("nbtInfo") ? tag.func_74779_i("nbtInfo") : null);
        }
        int yShift = tag.func_74764_b("yShift") ? tag.func_74762_e("yShift") : 0;
        info.setYShift(yShift);
        try {
            int imageHeight = tag.func_74764_b("handlerHeight") ? tag.func_74762_e("handlerHeight") : HandlerInfo.DEFAULT_HEIGHT;
            int imageWidth = tag.func_74764_b("handlerWidth") ? tag.func_74762_e("handlerWidth") : HandlerInfo.DEFAULT_WIDTH;
            int maxRecipesPerPage = tag.func_74764_b("maxRecipesPerPage") ? tag.func_74762_e("maxRecipesPerPage") : HandlerInfo.DEFAULT_MAX_PER_PAGE;
            info.setHandlerDimensions(imageHeight, imageWidth, maxRecipesPerPage);
        }
        catch (NumberFormatException ignored) {
            NEIClientConfig.logger.info("Error setting handler dimensions for {}", new Object[]{handler});
        }
        info.setUseCustomScroll(tag.func_74764_b("useCustomScroll") && tag.func_74767_n("useCustomScroll"));
        info.setShowFavoritesButton(!tag.func_74764_b("showFavoritesButton") || tag.func_74767_n("showFavoritesButton"));
        info.setShowOverlayButton(!tag.func_74764_b("showOverlayButton") || tag.func_74767_n("showOverlayButton"));
        GuiRecipeTab.handlerAdderFromIMC.remove(handler);
        GuiRecipeTab.handlerAdderFromIMC.put(handler, info);
    }

    private static void handleRemoveHandlerInfo(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String handler = tag.func_74779_i("handler");
        NEIClientConfig.logger.info("Processing removeHandlerInfo `{}` from {}", new Object[]{handler, message.getSender()});
        GuiRecipeTab.handlerRemoverFromIMC.add(handler);
    }

    private static void handleRegisterCatalystInfo(FMLInterModComms.IMCMessage message) {
        NBTTagCompound tag;
        String handlerID;
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        if (!processedCatalystSenders.contains(message.getSender())) {
            NEIClientConfig.logger.info("Processing registerCatalystInfo from {}", new Object[]{message.getSender()});
            processedCatalystSenders.add(message.getSender());
        }
        if ((handlerID = (tag = message.getNBTValue()).func_74779_i("handlerID")).isEmpty()) {
            NEIClientConfig.logger.warn("Missing handlerID for registerCatalystInfo!");
            return;
        }
        ItemStack itemStack = IMCHandler.getItemStackFromIMC(message, "registerCatalystInfo");
        if (itemStack == null) {
            return;
        }
        int priority = tag.func_74762_e("priority");
        RecipeCatalysts.addOrPut(RecipeCatalysts.catalystsAdderFromIMC, handlerID, new CatalystInfo(itemStack, priority));
        NEIClientConfig.logger.info("Added catalyst `{}` to handler {}", new Object[]{itemStack.func_82833_r(), handlerID});
    }

    private static void handleRemoveCatalystInfo(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String handlerID = tag.func_74779_i("handlerID");
        if (handlerID.isEmpty()) {
            NEIClientConfig.logger.warn("Missing handlerID for removeCatalystInfo!");
            return;
        }
        ItemStack itemStack = IMCHandler.getItemStackFromIMC(message, "removeCatalystInfo");
        if (itemStack == null) {
            return;
        }
        RecipeCatalysts.catalystsRemoverFromIMC.computeIfAbsent(handlerID, k -> new ArrayList()).add(itemStack);
        NEIClientConfig.logger.info("Removed catalyst `{}` from handler {}", new Object[]{itemStack.func_82833_r(), handlerID});
    }

    private static void handleAddItemInfo(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            IMCHandler.logInvalidMessage(message, "NBT");
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        if (tag.func_74764_b("pages")) {
            IMCHandler.addMultipleInfoPages(message);
        }
        if (tag.func_74764_b("page")) {
            IMCHandler.addSingleInfoPage(message);
        }
    }

    private static void addMultipleInfoPages(FMLInterModComms.IMCMessage message) {
        NBTTagCompound tag = message.getNBTValue();
        String filter = tag.func_74779_i("filter");
        NBTTagList pages = tag.func_150295_c("pages", 8);
        for (int i = 0; i < pages.func_74745_c(); ++i) {
            String page = pages.func_150307_f(i);
            InformationHandler.addInformationPage(filter, page);
        }
    }

    private static void addSingleInfoPage(FMLInterModComms.IMCMessage message) {
        NBTTagCompound tag = message.getNBTValue();
        String filter = tag.func_74779_i("filter");
        String page = tag.func_74779_i("page");
        InformationHandler.addInformationPage(filter, page);
    }

    private static ItemStack getItemStackFromIMC(FMLInterModComms.IMCMessage message, String logAction) {
        NBTTagCompound tag = message.getNBTValue();
        String itemName = tag.func_74779_i("itemName");
        String nbtInfo = tag.func_74764_b("nbtInfo") ? tag.func_74779_i("nbtInfo") : null;
        NEIClientConfig.logger.info("Processing {} for item `{}` from {}", new Object[]{logAction, itemName, message.getSender()});
        ItemStack itemStack = NEIServerUtils.getModdedItem(itemName, nbtInfo);
        if (itemStack == null) {
            NEIClientConfig.logger.warn("Cannot find item `{}`!", new Object[]{itemName});
        }
        return itemStack;
    }

    private static void logInvalidMessage(FMLInterModComms.IMCMessage message, String type) {
        FMLLog.bigWarning((String)String.format("Received invalid IMC '%s' from %s. Not a %s Message.", message.key, message.getSender(), type), (Object[])new Object[0]);
    }
}

