/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.item.IGasMask;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.HazmatRegistry;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ItemModInsert;
import com.hbm.items.armor.ItemModOxy;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.PlayerInformPacket;
import com.hbm.potion.HbmPotion;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ChatBuilder;
import com.hbm.util.Compat;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.ForgeEventFactory;

public class ArmorUtil {
    private static final MethodHandle canBreatheInSpaceFiskHandle;
    private static final MethodHandle getHeroIterationHandle;
    private static final Class<?> heroIteration;
    public static final String[] metals;
    public static final String FILTERK_KEY = "hfrFilter";

    public static void register() {
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.BACTERIA);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_mono, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_MONOXIDE);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_combo, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_MONOXIDE);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_rag, ArmorRegistry.HazardClass.PARTICLE_COARSE);
        ArmorRegistry.registerHazard(ModItems.gas_mask_filter_piss, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_LUNG);
        ArmorRegistry.registerHazard(ModItems.gas_mask, ArmorRegistry.HazardClass.SAND, ArmorRegistry.HazardClass.LIGHT);
        ArmorRegistry.registerHazard(ModItems.gas_mask_m65, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.mask_rag, ArmorRegistry.HazardClass.PARTICLE_COARSE);
        ArmorRegistry.registerHazard(ModItems.mask_piss, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.GAS_LUNG);
        ArmorRegistry.registerHazard(ModItems.goggles, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.ashglasses, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.attachment_mask, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.asbestos_helmet, ArmorRegistry.HazardClass.SAND, ArmorRegistry.HazardClass.LIGHT);
        ArmorRegistry.registerHazard(ModItems.hazmat_helmet, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hazmat_helmet_red, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hazmat_helmet_grey, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hazmat_paa_helmet, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.liquidator_helmet, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.t45_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.t51_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.ajr_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.ajro_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.steamsuit_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.hev_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.fau_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.dns_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.schrabidium_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.euphemium_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.rpa_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.envsuit_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorRegistry.registerHazard(ModItems.trenchmaster_helmet, ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("gregtech", "gt.armor.hazmat.universal.head", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("gregtech", "gt.armor.hazmat.biochemgas.head", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
        ArmorUtil.registerIfExists("gregtech", "gt.armor.hazmat.radiation.head", ArmorRegistry.HazardClass.PARTICLE_COARSE, ArmorRegistry.HazardClass.PARTICLE_FINE, ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.BACTERIA, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.GAS_MONOXIDE, ArmorRegistry.HazardClass.LIGHT, ArmorRegistry.HazardClass.SAND);
    }

    private static void registerIfExists(String domain, String name, ArmorRegistry.HazardClass ... classes) {
        Item item = Compat.tryLoadItem(domain, name);
        if (item != null) {
            ArmorRegistry.registerHazard(item, classes);
        }
    }

    public static boolean checkArmor(EntityLivingBase entity, Item ... armor) {
        for (int i = 0; i < 4; ++i) {
            if (ArmorUtil.checkArmorPiece(entity, armor[i], 3 - i)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkArmorPiece(EntityLivingBase entity, Item armor, int slot) {
        return !ArmorUtil.checkArmorNull(entity, slot) && entity.func_71124_b(slot + 1).func_77973_b() == armor;
    }

    public static boolean checkArmorNull(EntityLivingBase player, int slot) {
        return player.func_71124_b(slot + 1) == null;
    }

    public static void damageSuit(EntityLivingBase entity, int slot, int amount) {
        if (entity.func_71124_b(slot + 1) == null) {
            return;
        }
        entity.func_71124_b(slot + 1).func_77972_a(amount, entity);
        if (entity.func_71124_b((int)(slot + 1)).field_77994_a == 0) {
            entity.func_70062_b(slot + 1, null);
        }
    }

    public static void resetFlightTime(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            ReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)mp.field_71135_a, (Object)0, (String[])new String[]{"floatingTickCount", "field_147365_f"});
        }
    }

    @Deprecated
    public static boolean checkForHazmat(EntityLivingBase player) {
        if (ArmorUtil.checkArmor(player, ModItems.hazmat_helmet, ModItems.hazmat_plate, ModItems.hazmat_legs, ModItems.hazmat_boots) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_red, ModItems.hazmat_plate_red, ModItems.hazmat_legs_red, ModItems.hazmat_boots_red) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_grey, ModItems.hazmat_plate_grey, ModItems.hazmat_legs_grey, ModItems.hazmat_boots_grey) || ArmorUtil.checkArmor(player, ModItems.schrabidium_helmet, ModItems.schrabidium_plate, ModItems.schrabidium_legs, ModItems.schrabidium_boots) || ArmorUtil.checkForHaz2(player)) {
            return true;
        }
        return player.func_70644_a((Potion)HbmPotion.mutation) || player.func_70644_a((Potion)HbmPotion.nitan);
    }

    @Deprecated
    public static boolean checkForHaz2(EntityLivingBase player) {
        return ArmorUtil.checkArmor(player, ModItems.hazmat_paa_helmet, ModItems.hazmat_paa_plate, ModItems.hazmat_paa_legs, ModItems.hazmat_paa_boots) || ArmorUtil.checkArmor(player, ModItems.liquidator_helmet, ModItems.liquidator_plate, ModItems.liquidator_legs, ModItems.liquidator_boots) || ArmorUtil.checkArmor(player, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots) || ArmorUtil.checkArmor(player, ModItems.rpa_helmet, ModItems.rpa_plate, ModItems.rpa_legs, ModItems.rpa_boots) || ArmorUtil.checkArmor(player, ModItems.fau_helmet, ModItems.fau_plate, ModItems.fau_legs, ModItems.fau_boots) || ArmorUtil.checkArmor(player, ModItems.dns_helmet, ModItems.dns_plate, ModItems.dns_legs, ModItems.dns_boots);
    }

    public static boolean checkForAsbestos(EntityLivingBase player) {
        return ArmorUtil.checkArmor(player, ModItems.asbestos_helmet, ModItems.asbestos_plate, ModItems.asbestos_legs, ModItems.asbestos_boots);
    }

    public static boolean checkForOxy(EntityLivingBase entity, CBT_Atmosphere atmosphere) {
        if (!(entity instanceof EntityPlayer)) {
            return ChunkAtmosphereManager.proxy.canBreathe(atmosphere);
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (ArmorUtil.checkModBreathing(player)) {
            return true;
        }
        ItemStack tank = ArmorUtil.getOxygenTank(player);
        if (tank == null) {
            return ChunkAtmosphereManager.proxy.canBreathe(atmosphere);
        }
        boolean isInWater = entity.func_70086_ai() < 300;
        boolean canBreatheTank = ((ItemModOxy)tank.func_77973_b()).attemptBreathing(entity, tank, atmosphere, isInWater);
        if (isInWater && canBreatheTank) {
            entity.func_70050_g(300);
        }
        return canBreatheTank;
    }

    public static ItemStack getOxygenTank(EntityPlayer player) {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = player.func_82169_q(i);
            if (stack == null || !(stack.func_77973_b() instanceof ArmorFSB)) {
                return null;
            }
            if (((ArmorFSB)stack.func_77973_b()).canSeal) continue;
            return null;
        }
        ItemStack helmet = player.func_82169_q(3);
        if (ArmorModHandler.hasMods(helmet)) {
            ItemStack tankMod = ArmorModHandler.pryMods(helmet)[1];
            if (tankMod == null || !(tankMod.func_77973_b() instanceof ItemModOxy)) {
                return null;
            }
            return tankMod;
        }
        return null;
    }

    private static boolean checkModBreathing(EntityPlayer player) {
        if (canBreatheInSpaceFiskHandle != null) {
            try {
                Object iter = getHeroIterationHandle.invoke(player);
                if (canBreatheInSpaceFiskHandle.invoke((EntityLivingBase)player, iter)) {
                    return true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean checkForCorrosion(EntityLivingBase entity, CBT_Atmosphere atmosphere) {
        if (!ChunkAtmosphereManager.proxy.willCorrode(atmosphere)) {
            return false;
        }
        if (!(entity instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)entity;
        ItemStack insert = ArmorUtil.getCorrosionProtection(player);
        if (insert == null) {
            boolean isSealed = true;
            Random rand = entity.func_70681_au();
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = player.func_82169_q(i);
                if (stack == null || !(stack.func_77973_b() instanceof ArmorFSB) || !((ArmorFSB)stack.func_77973_b()).canSeal) {
                    isSealed = false;
                }
                if (stack == null) continue;
                if (rand.nextInt(2) == 0) {
                    stack.func_77964_b(stack.func_77960_j() + 1);
                }
                if (stack.func_77960_j() < stack.func_77958_k() && stack.func_77973_b() instanceof ArmorFSB && ((ArmorFSB)stack.func_77973_b()).isArmorEnabled(stack)) continue;
                stack.field_77994_a = 0;
                player.field_71071_by.field_70460_b[i] = null;
                entity.field_70170_p.func_72956_a((Entity)entity, "random.fizz", 0.2f, 1.0f);
            }
            if (isSealed && entity instanceof EntityPlayerMP) {
                PacketDispatcher.wrapper.sendTo(new PlayerInformPacket((IChatComponent)ChatBuilder.start("").nextTranslation("info.corrosion", new Object[0]).color(EnumChatFormatting.RED).flush(), 12, 3000), (EntityPlayerMP)entity);
            }
            return !isSealed;
        }
        return false;
    }

    public static ItemStack getCorrosionProtection(EntityPlayer player) {
        ItemStack chest = player.func_82169_q(2);
        if (chest != null && ArmorModHandler.hasMods(chest)) {
            ItemStack insertMod = ArmorModHandler.pryMods(chest)[6];
            if (insertMod == null || !(insertMod.func_77973_b() instanceof ItemModInsert)) {
                return null;
            }
            if (!((ItemModInsert)insertMod.func_77973_b()).corrosionProtection) {
                return null;
            }
            return insertMod;
        }
        return null;
    }

    public static boolean checkForDigamma(EntityPlayer player) {
        if (ArmorUtil.checkArmor((EntityLivingBase)player, ModItems.fau_helmet, ModItems.fau_plate, ModItems.fau_legs, ModItems.fau_boots)) {
            return true;
        }
        if (ArmorUtil.checkArmor((EntityLivingBase)player, ModItems.dns_helmet, ModItems.dns_plate, ModItems.dns_legs, ModItems.dns_boots)) {
            return true;
        }
        return player.func_82165_m(HbmPotion.stability.field_76415_H);
    }

    public static boolean checkForDigamma2(EntityPlayer player) {
        if (!ArmorUtil.checkArmor((EntityLivingBase)player, ModItems.robes_helmet, ModItems.robes_plate, ModItems.robes_legs, ModItems.robes_boots)) {
            return false;
        }
        if (!player.func_82165_m(HbmPotion.stability.field_76415_H)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack[] mods;
            ItemStack armor = player.func_82169_q(i);
            if (armor == null || !ArmorModHandler.hasMods(armor) || (mods = ArmorModHandler.pryMods(armor))[5] != null && mods[5].func_77973_b() == ModItems.cladding_iron) continue;
            return false;
        }
        return player.func_110138_aP() < 3.0f;
    }

    public static boolean checkForFaraday(EntityPlayer player) {
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        if (armor[0] == null || armor[1] == null || armor[2] == null || armor[3] == null) {
            return false;
        }
        return ArmorUtil.isFaradayArmor(armor[0]) && ArmorUtil.isFaradayArmor(armor[1]) && ArmorUtil.isFaradayArmor(armor[2]) && ArmorUtil.isFaradayArmor(armor[3]);
    }

    public static boolean isFaradayArmor(ItemStack item) {
        String name = item.func_77977_a();
        for (String metal : metals) {
            if (!name.toLowerCase(Locale.US).contains(metal)) continue;
            return true;
        }
        return HazmatRegistry.getCladding(item) > 0.0;
    }

    public static boolean checkForFiend(EntityPlayer player) {
        return ArmorUtil.checkArmorPiece((EntityLivingBase)player, ModItems.jackt, 2) && Library.checkForHeld(player, ModItems.shimmer_sledge);
    }

    public static boolean checkForFiend2(EntityPlayer player) {
        return ArmorUtil.checkArmorPiece((EntityLivingBase)player, ModItems.jackt2, 2) && Library.checkForHeld(player, ModItems.shimmer_axe);
    }

    public static void installGasMaskFilter(ItemStack mask, ItemStack filter) {
        if (mask == null || filter == null) {
            return;
        }
        if (!mask.func_77942_o()) {
            mask.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound attach = new NBTTagCompound();
        filter.func_77955_b(attach);
        mask.field_77990_d.func_74782_a(FILTERK_KEY, (NBTBase)attach);
    }

    public static void removeFilter(ItemStack mask) {
        if (mask == null) {
            return;
        }
        if (!mask.func_77942_o()) {
            return;
        }
        mask.field_77990_d.func_82580_o(FILTERK_KEY);
    }

    public static ItemStack getGasMaskFilterRecursively(ItemStack mask, EntityLivingBase entity) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(mask);
        if (filter == null && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[0] != null && mods[0].func_77973_b() instanceof IGasMask) {
            filter = ((IGasMask)mods[0].func_77973_b()).getFilter(mods[0], entity);
        }
        return filter;
    }

    public static ItemStack getGasMaskFilter(ItemStack mask) {
        if (mask == null) {
            return null;
        }
        if (!mask.func_77942_o()) {
            return null;
        }
        NBTTagCompound attach = mask.field_77990_d.func_74775_l(FILTERK_KEY);
        ItemStack filter = ItemStack.func_77949_a((NBTTagCompound)attach);
        return filter;
    }

    public static void damageGasMaskFilter(EntityLivingBase entity, int damage) {
        ItemStack[] mods;
        ItemStack mask = entity.func_71124_b(4);
        if (mask == null) {
            return;
        }
        if (!(mask.func_77973_b() instanceof IGasMask) && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[0] != null && mods[0].func_77973_b() instanceof IGasMask) {
            mask = mods[0];
        }
        if (mask != null) {
            ArmorUtil.damageGasMaskFilter(mask, damage);
        }
    }

    public static void damageGasMaskFilter(ItemStack mask, int damage) {
        ItemStack[] mods;
        ItemStack filter = ArmorUtil.getGasMaskFilter(mask);
        if (filter == null && ArmorModHandler.hasMods(mask) && (mods = ArmorModHandler.pryMods(mask))[0] != null && mods[0].func_77973_b() instanceof IGasMask) {
            filter = ArmorUtil.getGasMaskFilter(mods[0]);
        }
        if (filter == null || filter.func_77958_k() == 0) {
            return;
        }
        filter.func_77964_b(filter.func_77960_j() + damage);
        if (filter.func_77960_j() > filter.func_77958_k()) {
            ArmorUtil.removeFilter(mask);
        } else {
            ArmorUtil.installGasMaskFilter(mask, filter);
        }
    }

    public static void addGasMaskTooltip(ItemStack mask, EntityPlayer player, List list, boolean ext) {
        if (mask == null || !(mask.func_77973_b() instanceof IGasMask)) {
            return;
        }
        ItemStack filter = ((IGasMask)mask.func_77973_b()).getFilter(mask, (EntityLivingBase)player);
        if (filter == null) {
            list.add(EnumChatFormatting.RED + "No filter installed!");
            return;
        }
        list.add(EnumChatFormatting.GOLD + "Installed filter:");
        int meta = filter.func_77960_j();
        int max = filter.func_77958_k();
        String append = "";
        if (max > 0) {
            append = " (" + (max - meta) * 100 / max + "%)";
        }
        ArrayList lore = new ArrayList();
        list.add("  " + filter.func_82833_r() + append);
        filter.func_77973_b().func_77624_a(filter, player, lore, ext);
        ForgeEventFactory.onItemTooltip((ItemStack)filter, (EntityPlayer)player, lore, (boolean)ext);
        lore.forEach(x -> list.add(EnumChatFormatting.YELLOW + "  " + x));
    }

    public static boolean isWearingEmptyMask(EntityPlayer player) {
        ItemStack mask = player.func_71124_b(4);
        if (mask == null) {
            return false;
        }
        if (mask.func_77973_b() instanceof IGasMask) {
            return ArmorUtil.getGasMaskFilter(mask) == null;
        }
        ItemStack mod = ArmorModHandler.pryMods(mask)[0];
        if (mod != null && mod.func_77973_b() instanceof IGasMask) {
            return ArmorUtil.getGasMaskFilter(mod) == null;
        }
        return false;
    }

    static {
        if (Loader.isModLoaded((String)"fiskheroes")) {
            try {
                Class<?> worldHelper = Class.forName("com.fiskmods.heroes.util.WorldHelper");
                Class<?> heroTracker = Class.forName("com.fiskmods.heroes.common.hero.HeroTracker");
                heroIteration = Class.forName("com.fiskmods.heroes.common.hero.HeroIteration");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodType canBreatheType = MethodType.methodType(Boolean.TYPE, EntityLivingBase.class, heroIteration);
                canBreatheInSpaceFiskHandle = lookup.findStatic(worldHelper, "canBreatheInSpace", canBreatheType);
                MethodType herpesIterationType = MethodType.methodType(heroIteration, EntityPlayer.class);
                getHeroIterationHandle = lookup.findStatic(heroTracker, "iter", herpesIterationType);
            }
            catch (Exception e) {
                throw new AssertionError();
            }
        } else {
            canBreatheInSpaceFiskHandle = null;
            getHeroIterationHandle = null;
            heroIteration = null;
        }
        metals = new String[]{"chainmail", "iron", "silver", "gold", "platinum", "tin", "lead", "liquidator", "schrabidium", "euphemium", "steel", "cmb", "titanium", "alloy", "copper", "bronze", "electrum", "t45", "t51", "bj", "starmetal", "hazmat", "rubber", "hev", "ajr", "rpa", "spacesuit"};
    }
}

