/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.AlkylationRecipes;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineAlkylation
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IPersistentNBT {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[4];
    AxisAlignedBB bb = null;

    public TileEntityMachineAlkylation() {
        super(11);
        this.tanks[0] = new FluidTank(Fluids.CHLOROMETHANE, 8000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 4000);
        this.tanks[2] = new FluidTank(Fluids.UNSATURATEDS, 8000);
        this.tanks[3] = new FluidTank(Fluids.CHLORINE, 8000);
    }

    @Override
    public String getName() {
        return "container.alkylation";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.updateConnections();
            }
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                this.alkylate();
            }
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void alkylate() {
        Tuple.Triplet<FluidStack, FluidStack, FluidStack> out = AlkylationRecipes.getOutput(this.tanks[0].getTankType());
        if (out == null) {
            this.tanks[2].setTankType(Fluids.NONE);
            this.tanks[3].setTankType(Fluids.NONE);
            return;
        }
        this.tanks[1].setTankType(out.getX().type);
        this.tanks[2].setTankType(out.getY().type);
        this.tanks[3].setTankType(out.getZ().type);
        if (this.power < 4000L) {
            return;
        }
        if (this.tanks[0].getFill() < 100) {
            return;
        }
        if (this.tanks[1].getFill() < out.getX().fill) {
            return;
        }
        if (this.tanks[2].getFill() + out.getY().fill > this.tanks[2].getMaxFill()) {
            return;
        }
        if (this.tanks[3].getFill() + out.getZ().fill > this.tanks[3].getMaxFill()) {
            return;
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        this.tanks[1].setFill(this.tanks[1].getFill() - out.getX().fill);
        this.tanks[2].setFill(this.tanks[2].getFill() + out.getY().fill);
        this.tanks[3].setFill(this.tanks[3].getFill() + out.getZ().fill);
        this.power -= 4000L;
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            if (this.tanks[2].getFill() > 0) {
                this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.tanks[3].getFill() <= 0) continue;
            this.sendFluid(this.tanks[3], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 + dir.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 1 + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 1 + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c - rot.offsetX * 1 + dir.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 1 + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 2 + dir.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 + dir.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 3, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 3, dir.getOpposite())};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[2], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tanks[0].getFill() == 0 && this.tanks[1].getFill() == 0 && this.tanks[2].getFill() == 0 && this.tanks[3].getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(data, "t" + i);
        }
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(data, "t" + i);
        }
    }
}

