/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IPropulsion;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Rocket;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityXenonThruster
extends TileEntityMachineBase
implements IPropulsion,
IFluidStandardReceiver,
IEnergyReceiverMK2 {
    public FluidTank[] tanks = new FluidTank[1];
    public long power;
    public static long maxPower = 20000000L;
    private static final int POWER_COST_MULTIPLIER = 5000;
    private boolean isOn;
    public float thrustAmount;
    private boolean hasRegistered;
    private int fuelCost;
    AxisAlignedBB bb = null;

    public TileEntityXenonThruster() {
        super(0);
        this.tanks[0] = new FluidTank(Fluids.XENON, 4000);
    }

    @Override
    public String getName() {
        return "container.xenonThruster";
    }

    @Override
    public void func_145845_h() {
        if (!CelestialBody.inOrbit(this.field_145850_b)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.hasRegistered) {
                if (this.isFacingPrograde()) {
                    this.registerPropulsion();
                }
                this.hasRegistered = true;
            }
            for (DirPos pos : this.getConPos()) {
                for (FluidTank tank : this.tanks) {
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    this.trySubscribe(tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.networkPackNT(250);
        } else if (this.isOn) {
            this.thrustAmount = (float)((double)this.thrustAmount + 0.01);
            if (this.thrustAmount > 1.0f) {
                this.thrustAmount = 1.0f;
            }
        } else {
            this.thrustAmount = (float)((double)this.thrustAmount - 0.01);
            if (this.thrustAmount < 0.0f) {
                this.thrustAmount = 0.0f;
            }
        }
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ, dir)};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isOn);
        buf.writeLong(this.power);
        buf.writeInt(this.fuelCost);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isOn = buf.readBoolean();
        this.power = buf.readLong();
        this.fuelCost = buf.readInt();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("on", this.isOn);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOn = nbt.func_74767_n("on");
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    public boolean isFacingPrograde() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)) == ForgeDirection.WEST;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public boolean canPerformBurn(int shipMass, double deltaV) {
        FT_Rocket trait = this.tanks[0].getTankType().getTrait(FT_Rocket.class);
        int isp = trait != null ? trait.getISP() : 300;
        this.fuelCost = SolarSystem.getFuelCost(deltaV, shipMass, isp);
        if (this.power < (long)(this.fuelCost * 5000)) {
            return false;
        }
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() >= this.fuelCost) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.power < (long)(this.fuelCost * 5000)) {
            errors.add(EnumChatFormatting.RED + I18nUtil.resolveKey(this.func_145838_q().func_149739_a() + ".name", new Object[0]) + " - Insufficient power: needs " + BobMathUtil.getShortNumber(this.fuelCost * 5000) + "HE");
        }
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() >= this.fuelCost) continue;
            errors.add(EnumChatFormatting.RED + I18nUtil.resolveKey(this.func_145838_q().func_149739_a() + ".name", new Object[0]) + " - Insufficient fuel: needs " + this.fuelCost + "mB");
        }
    }

    @Override
    public float getThrust() {
        return 1400000.0f;
    }

    @Override
    public int startBurn() {
        this.isOn = true;
        this.power -= (long)(this.fuelCost * 5000);
        for (FluidTank tank : this.tanks) {
            tank.setFill(tank.getFill() - this.fuelCost);
        }
        return 200;
    }

    @Override
    public int endBurn() {
        this.isOn = false;
        return 200;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }
}

