/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.handler.RocketStruct;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Rocket;
import com.hbm.items.weapon.ItemCustomRocket;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Stack;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOrbitalStation
extends TileEntityMachineBase
implements IFluidStandardReceiver {
    private OrbitalStation station;
    private EntityRideableRocket docked;
    private FluidTank[] tanks = new FluidTank[1];
    public boolean isReserved = false;
    public boolean hasDocked = false;
    public boolean hasRider = false;
    public boolean needsFuel = false;
    public boolean hasFuel = false;
    public float rot;
    public float prevRot;
    AxisAlignedBB bb = null;

    public TileEntityOrbitalStation() {
        super(16);
        this.tanks[0] = new FluidTank(Fluids.HYDRAZINE, 16000);
    }

    @Override
    public String getName() {
        return "container.orbitalStation";
    }

    @Override
    public void func_145845_h() {
        if (!CelestialBody.inOrbit(this.field_145850_b)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.station = OrbitalStation.getStationFromPosition(this.field_145851_c, this.field_145849_e);
            if (this.isCore()) {
                this.station.update(this.field_145850_b);
            }
            this.station.addPort(this);
            if (this.docked != null && this.docked.isReusable()) {
                int fillRequirement = this.getFillRequirement(false);
                for (FluidTank fluidTank : this.tanks) {
                    fluidTank.changeTankSize(Math.max(fillRequirement, fluidTank.getFill()));
                }
                for (Cloneable cloneable : this.getConPos()) {
                    for (FluidTank tank : this.tanks) {
                        if (tank.getTankType() == Fluids.NONE) continue;
                        this.trySubscribe(tank.getTankType(), this.field_145850_b, ((BlockPos)cloneable).getX(), ((BlockPos)cloneable).getY(), ((BlockPos)cloneable).getZ(), ((DirPos)cloneable).getDir());
                    }
                }
            }
            if (this.docked != null && (this.docked.field_70128_L || this.docked.getState() == EntityRideableRocket.RocketState.UNDOCKING)) {
                if (!this.docked.field_70128_L && this.docked.isReusable()) {
                    boolean toOrbit = this.docked.getTarget().inOrbit;
                    for (Cloneable cloneable : this.tanks) {
                        ((FluidTank)cloneable).changeTankSize(Math.max(0, ((FluidTank)cloneable).getFill() - this.getFillRequirement(toOrbit)));
                    }
                }
                this.undockRocket();
            }
            if (this.docked != null && this.docked.isReusable()) {
                boolean hasFuel = this.hasSufficientFuel(this.docked.getTarget().inOrbit);
                if (hasFuel && this.docked.getState() == EntityRideableRocket.RocketState.NEEDSFUEL) {
                    this.docked.setState(this.docked.navDrive != null ? EntityRideableRocket.RocketState.AWAITING : EntityRideableRocket.RocketState.LANDED);
                } else if (!hasFuel && this.docked.getState() != EntityRideableRocket.RocketState.NEEDSFUEL) {
                    this.docked.setState(EntityRideableRocket.RocketState.NEEDSFUEL);
                }
            }
            this.hasDocked = this.docked != null;
            this.hasRider = this.hasDocked && this.docked.field_70153_n != null;
            this.needsFuel = this.hasDocked && this.docked.isReusable();
            boolean bl = this.hasFuel = this.needsFuel && this.hasSufficientFuel(this.docked.getTarget().inOrbit);
            if (this.hasDocked) {
                this.isReserved = false;
            }
            this.networkPackNT(512);
        } else {
            if (this.isCore() && this.station != null) {
                this.station.update(this.field_145850_b);
            }
            this.prevRot = this.rot;
            if (this.hasDocked) {
                this.rot += 2.25f;
                if (this.rot > 90.0f) {
                    this.rot = 90.0f;
                }
            } else {
                this.rot -= 2.25f;
                if (this.rot < 0.0f) {
                    this.rot = 0.0f;
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.station != null) {
            if (!this.isCore()) {
                this.station.removePort(this);
            }
            if (this.docked != null) {
                this.docked.dropNDie(null);
            }
        }
    }

    public boolean isCore() {
        return this.func_145838_q() == ModBlocks.orbital_station;
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e + 3, ForgeDirection.NORTH), new DirPos(this.field_145851_c + 0, this.field_145848_d + 1, this.field_145849_e + 3, ForgeDirection.NORTH), new DirPos(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 3, ForgeDirection.NORTH), new DirPos(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e - 3, ForgeDirection.SOUTH), new DirPos(this.field_145851_c + 0, this.field_145848_d + 1, this.field_145849_e - 3, ForgeDirection.SOUTH), new DirPos(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e - 3, ForgeDirection.SOUTH), new DirPos(this.field_145851_c + 3, this.field_145848_d + 1, this.field_145849_e - 1, ForgeDirection.EAST), new DirPos(this.field_145851_c + 3, this.field_145848_d + 1, this.field_145849_e + 0, ForgeDirection.EAST), new DirPos(this.field_145851_c + 3, this.field_145848_d + 1, this.field_145849_e + 1, ForgeDirection.EAST), new DirPos(this.field_145851_c - 3, this.field_145848_d + 1, this.field_145849_e - 1, ForgeDirection.WEST), new DirPos(this.field_145851_c - 3, this.field_145848_d + 1, this.field_145849_e + 0, ForgeDirection.WEST), new DirPos(this.field_145851_c - 3, this.field_145848_d + 1, this.field_145849_e + 1, ForgeDirection.WEST)};
    }

    public void enterCapsule(EntityPlayer player) {
        if (this.docked == null || this.docked.field_70153_n != null) {
            return;
        }
        this.docked.func_130002_c(player);
    }

    public void dockRocket(EntityRideableRocket rocket) {
        this.despawnRocket();
        this.docked = rocket;
    }

    public void undockRocket() {
        this.docked = null;
    }

    public void despawnRocket() {
        if (this.docked != null) {
            Stack<ItemStack> itemsToStuff = new Stack<ItemStack>();
            RocketStruct rocket = this.docked.getRocket();
            if (rocket.stages.size() > 0) {
                itemsToStuff.push(ItemCustomRocket.build(this.docked.getRocket(), true));
            } else {
                itemsToStuff.push(new ItemStack((Item)rocket.capsule.part));
            }
            if (this.docked.navDrive != null) {
                itemsToStuff.push(this.docked.navDrive.func_77946_l());
            }
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i] != null) continue;
                this.slots[i] = (ItemStack)itemsToStuff.pop();
                if (itemsToStuff.empty()) break;
            }
            this.docked.func_70106_y();
            this.docked = null;
        }
    }

    public void reservePort() {
        this.isReserved = true;
    }

    public void spawnRocket(ItemStack stack) {
        EntityRideableRocket rocket = new EntityRideableRocket(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.5f, (float)this.field_145849_e + 0.5f, stack);
        rocket.field_70163_u -= (double)rocket.field_70131_O;
        rocket.setState(rocket.isReusable() ? EntityRideableRocket.RocketState.NEEDSFUEL : EntityRideableRocket.RocketState.LANDED);
        this.field_145850_b.func_72838_d((Entity)rocket);
        this.dockRocket(rocket);
    }

    public boolean hasStoredItems() {
        for (ItemStack stack : this.slots) {
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    public void giveStoredItems(EntityPlayer player) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            if (!player.field_71071_by.func_70441_a(this.slots[i].func_77946_l())) {
                player.func_71019_a(this.slots[i].func_77946_l(), false);
            }
            this.slots[i] = null;
        }
        player.field_71069_bz.func_75142_b();
        this.func_70296_d();
    }

    public boolean hasSufficientFuel(boolean toOrbit) {
        int fillRequirement = this.getFillRequirement(toOrbit);
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() >= fillRequirement) continue;
            return false;
        }
        return true;
    }

    public int getFillRequirement(boolean toOrbit) {
        if (toOrbit) {
            return 500;
        }
        int mass = this.docked != null ? this.docked.getRocket().getLaunchMass() : 4000;
        FT_Rocket fuelTrait = this.tanks[0].getTankType().getTrait(FT_Rocket.class);
        int thrust = fuelTrait != null ? (int)fuelTrait.getThrust() : 600000;
        int isp = fuelTrait != null ? fuelTrait.getISP() : 300;
        return SolarSystem.getCostBetween(this.station.orbiting, this.station.orbiting, mass, thrust, isp, false, true);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        return IntStream.range(0, this.slots.length).toArray();
    }

    @Override
    public void serialize(ByteBuf buf) {
        int i;
        super.serialize(buf);
        if (this.isCore()) {
            this.station.serialize(buf);
        }
        buf.writeBoolean(this.hasDocked);
        buf.writeBoolean(this.hasRider);
        buf.writeBoolean(this.needsFuel);
        buf.writeBoolean(this.hasFuel);
        for (i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != null) {
                buf.writeShort(Item.func_150891_b((Item)this.slots[i].func_77973_b()));
                continue;
            }
            buf.writeShort(-1);
        }
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        super.deserialize(buf);
        if (this.isCore()) {
            OrbitalStation.clientStation = this.station = OrbitalStation.deserialize(buf);
        }
        this.hasDocked = buf.readBoolean();
        this.hasRider = buf.readBoolean();
        this.needsFuel = buf.readBoolean();
        this.hasFuel = buf.readBoolean();
        for (i = 0; i < this.slots.length; ++i) {
            short id = buf.readShort();
            this.slots[i] = id > 0 ? new ItemStack(Item.func_150899_d((int)id)) : null;
        }
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        this.tanks[0].setTankType(Fluids.HYDRAZINE);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }
}

