/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.NotableComments;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineAssemblyFactory;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineAssemblyFactory;
import com.hbm.inventory.recipes.AssemblyMachineRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.machine.ModuleMachineAssembler;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.TileEntityProxyDyn;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@NotableComments
public class TileEntityMachineAssemblyFactory
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IControlReceiver,
IGUIProvider,
TileEntityProxyDyn.IProxyDelegateProvider {
    public FluidTank[] allTanks;
    public FluidTank[] inputTanks;
    public FluidTank[] outputTanks;
    public FluidTank water;
    public FluidTank lps;
    public long power;
    public long maxPower = 1000000L;
    public boolean[] didProcess = new boolean[4];
    public boolean frame = false;
    private AudioWrapper audio;
    public TragicYuri[] animations;
    public ModuleMachineAssembler[] assemblerModule;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    protected DelegateAssemblyFactoy delegate = new DelegateAssemblyFactoy();
    AxisAlignedBB bb = null;
    public DirPos[] coolantLine;

    public TileEntityMachineAssemblyFactory() {
        super(60);
        int i;
        this.animations = new TragicYuri[2];
        for (i = 0; i < this.animations.length; ++i) {
            this.animations[i] = new TragicYuri(i);
        }
        this.inputTanks = new FluidTank[4];
        this.outputTanks = new FluidTank[4];
        for (i = 0; i < 4; ++i) {
            this.inputTanks[i] = new FluidTank(Fluids.NONE, 4000);
            this.outputTanks[i] = new FluidTank(Fluids.NONE, 4000);
        }
        this.water = new FluidTank(Fluids.WATER, 4000);
        this.lps = new FluidTank(Fluids.SPENTSTEAM, 4000);
        this.allTanks = new FluidTank[this.inputTanks.length + this.outputTanks.length + 2];
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.allTanks[i] = this.inputTanks[i];
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.allTanks[i + this.inputTanks.length] = this.outputTanks[i];
        }
        this.allTanks[this.allTanks.length - 2] = this.water;
        this.allTanks[this.allTanks.length - 1] = this.lps;
        this.assemblerModule = new ModuleMachineAssembler[4];
        for (i = 0; i < 4; ++i) {
            this.assemblerModule[i] = new ModuleMachineAssembler(i, this, this.slots).itemInput(5 + i * 14).itemOutput(17 + i * 14).fluidInput(this.inputTanks[i]).fluidOutput(this.outputTanks[i]);
        }
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        int k;
        for (k = 0; k < 4; ++k) {
            if (i != 17 + k * 14) continue;
            return true;
        }
        for (k = 0; k < 4; ++k) {
            if (!this.assemblerModule[k].isSlotClogged(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        int i;
        if (slot == 0) {
            return true;
        }
        for (i = 0; i < 4; ++i) {
            if (slot != 4 + i * 14 || stack.func_77973_b() != ModItems.blueprints) continue;
            return true;
        }
        if (slot >= 1 && slot <= 3 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            return true;
        }
        for (i = 0; i < 4; ++i) {
            if (!this.assemblerModule[i].isItemValid(slot, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
    }

    @Override
    public String getName() {
        return "container.machineAssemblyFactory";
    }

    @Override
    public void func_145845_h() {
        if (this.maxPower <= 0L) {
            this.maxPower = 10000000L;
        }
        if (!this.field_145850_b.field_72995_K) {
            long nextMaxPower = 0L;
            for (int i = 0; i < 4; ++i) {
                GenericRecipe recipe = (GenericRecipe)AssemblyMachineRecipes.INSTANCE.recipeNameMap.get(this.assemblerModule[i].recipe);
                if (recipe == null) continue;
                nextMaxPower += recipe.power * 100L;
            }
            this.maxPower = nextMaxPower;
            this.maxPower = BobMathUtil.max(this.power, this.maxPower, 1000000L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.upgradeManager.checkSlots(this.slots, 1, 3);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                for (FluidTank tank : this.inputTanks) {
                    if (tank.getTankType() == Fluids.NONE) continue;
                    this.trySubscribe(tank.getTankType(), this.field_145850_b, pos);
                }
                for (FluidTank tank : this.outputTanks) {
                    if (tank.getFill() <= 0) continue;
                    this.tryProvide(tank, this.field_145850_b, pos);
                }
            }
            for (DirPos pos : this.getCoolPos()) {
                this.delegate.trySubscribe(this.field_145850_b, pos);
                this.delegate.trySubscribe(this.water.getTankType(), this.field_145850_b, pos);
                this.delegate.tryProvide(this.lps, this.field_145850_b, pos);
            }
            double speed = 1.0;
            double pow = 1.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3);
            pow -= (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3) * 0.25;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 1.0;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10.0 / 3.0;
            boolean markDirty = false;
            for (int i = 0; i < 4; ++i) {
                this.assemblerModule[i].update(speed * 2.0, pow * 2.0, this.canCool(), this.slots[4 + i * 14]);
                this.didProcess[i] = this.assemblerModule[i].didProcess;
                markDirty |= this.assemblerModule[i].markDirty;
                if (!this.assemblerModule[i].didProcess) continue;
                this.water.setFill(this.water.getFill() - 100);
                this.lps.setFill(this.lps.getFill() + 100);
            }
            if (markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(100);
        } else {
            if ((this.didProcess[0] || this.didProcess[1] || this.didProcess[2] || this.didProcess[3]) && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 50.0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updatePitch(0.75f);
                this.audio.updateVolume(this.getVolume(0.5f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            for (TragicYuri animation : this.animations) {
                animation.update(this.didProcess[0] || this.didProcess[1] || this.didProcess[2] || this.didProcess[3]);
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.frame = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.motor", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.5f, 15.0f, 0.75f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public boolean canCool() {
        return this.water.getFill() >= 100 && this.lps.getFill() <= this.lps.getMaxFill() - 100;
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 2, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 0, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 2, Library.POS_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 2, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 0, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 2, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - dir.offsetX + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + dir.offsetX - rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ - rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ * 3, rot.getOpposite())};
    }

    public DirPos[] getCoolPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c - rot.offsetX + dir.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c + rot.offsetX - dir.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ - dir.offsetZ * 3, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ * 3, dir.getOpposite())};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(ByteBuf buf) {
        void var2_6;
        super.serialize(buf);
        for (FluidTank tank : this.inputTanks) {
            tank.serialize(buf);
        }
        for (FluidTank tank : this.outputTanks) {
            tank.serialize(buf);
        }
        this.water.serialize(buf);
        this.lps.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        for (boolean b : this.didProcess) {
            buf.writeBoolean(b);
        }
        boolean bl = false;
        while (var2_6 < 4) {
            this.assemblerModule[var2_6].serialize(buf);
            ++var2_6;
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        super.deserialize(buf);
        for (FluidTank tank : this.inputTanks) {
            tank.deserialize(buf);
        }
        for (FluidTank tank : this.outputTanks) {
            tank.deserialize(buf);
        }
        this.water.deserialize(buf);
        this.lps.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        for (i = 0; i < 4; ++i) {
            this.didProcess[i] = buf.readBoolean();
        }
        for (i = 0; i < 4; ++i) {
            this.assemblerModule[i].deserialize(buf);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i].readFromNBT(nbt, "i" + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i].readFromNBT(nbt, "i" + i);
        }
        this.water.readFromNBT(nbt, "w");
        this.lps.readFromNBT(nbt, "s");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        for (i = 0; i < 4; ++i) {
            this.assemblerModule[i].readFromNBT(nbt);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i].writeToNBT(nbt, "i" + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i].writeToNBT(nbt, "i" + i);
        }
        this.water.writeToNBT(nbt, "w");
        this.lps.writeToNBT(nbt, "s");
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        for (i = 0; i < 4; ++i) {
            this.assemblerModule[i].writeToNBT(nbt);
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.inputTanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.outputTanks;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.allTanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineAssemblyFactory(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineAssemblyFactory(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index >= 0 && index < 4) {
                this.assemblerModule[index].recipe = selection;
                this.markChanged();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_chemical_factory));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.speed", "+" + level * 100 / 3 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    @Override
    public Object getDelegateForPosition(int x, int y, int z) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        if (this.coolantLine == null) {
            this.coolantLine = new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c - rot.offsetX + dir.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + rot.offsetX - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ * 2, dir.getOpposite())};
        }
        for (DirPos pos : this.coolantLine) {
            if (!pos.compare(x, y, z)) continue;
            return this.delegate;
        }
        return null;
    }

    public static enum ArmState {
        REPOSITION,
        EXTEND,
        CUT,
        RETRACT,
        RETIRE,
        WAIT;

    }

    public static enum YuriState {
        WORKING,
        RETIRING,
        SLIDING;

    }

    public class TragicYuri {
        public AssemblerArm striker;
        public AssemblerArm saw;
        Random rand = new Random();
        YuriState state = YuriState.WORKING;
        double slider = 0.0;
        double prevSlider = 0.0;
        boolean direction = false;
        int timeUntilReposition;

        public TragicYuri(int group) {
            this.striker = new AssemblerArm(group == 0 ? 0 : 3);
            this.saw = new AssemblerArm(group == 0 ? 1 : 2).yepThatsASaw();
            this.timeUntilReposition = 140 + this.rand.nextInt(161);
        }

        public void update(boolean working) {
            this.prevSlider = this.slider;
            if (TileEntityMachineAssemblyFactory.this.didProcess[this.striker.recipeIndex] || TileEntityMachineAssemblyFactory.this.didProcess[this.saw.recipeIndex]) {
                switch (this.state) {
                    case WORKING: {
                        --this.timeUntilReposition;
                        if (this.timeUntilReposition > 0) break;
                        this.state = YuriState.RETIRING;
                        break;
                    }
                    case RETIRING: {
                        if (this.striker.state != ArmState.WAIT || this.saw.state != ArmState.WAIT) break;
                        this.state = YuriState.SLIDING;
                        boolean bl = this.direction = !this.direction;
                        if (TileEntityMachineAssemblyFactory.this.muffled) break;
                        MainRegistry.proxy.playSoundClient(TileEntityMachineAssemblyFactory.this.field_145851_c, TileEntityMachineAssemblyFactory.this.field_145848_d, TileEntityMachineAssemblyFactory.this.field_145849_e, "hbm:block.assemblerStart", TileEntityMachineAssemblyFactory.this.getVolume(0.25f), 1.25f + ((TileEntityMachineAssemblyFactory)TileEntityMachineAssemblyFactory.this).field_145850_b.field_73012_v.nextFloat() * 0.25f);
                        break;
                    }
                    case SLIDING: {
                        double sliderSpeed = 0.1;
                        if (this.direction) {
                            this.slider += sliderSpeed;
                            if (this.slider >= 1.0) {
                                this.slider = 1.0;
                                this.state = YuriState.WORKING;
                            }
                        } else {
                            this.slider -= sliderSpeed;
                            if (this.slider <= 0.0) {
                                this.slider = 0.0;
                                this.state = YuriState.WORKING;
                            }
                        }
                        if (this.state != YuriState.WORKING) break;
                        this.timeUntilReposition = 140 + this.rand.nextInt(161);
                    }
                }
            }
            this.striker.updateArm();
            this.saw.updateArm();
        }

        public double getSlider(float interp) {
            return this.prevSlider + (this.slider - this.prevSlider) * (double)interp;
        }

        public class AssemblerArm {
            public double[] angles = new double[4];
            public double[] prevAngles = new double[4];
            public double[] targetAngles = new double[4];
            public double[] speed = new double[4];
            public double sawAngle;
            public double prevSawAngle;
            public int recipeIndex;
            ArmState state = ArmState.REPOSITION;
            int actionDelay = 0;
            boolean saw = false;

            public AssemblerArm(int index) {
                this.recipeIndex = index;
                this.resetSpeed();
                this.chooseNewArmPoistion();
            }

            public AssemblerArm yepThatsASaw() {
                this.saw = true;
                this.chooseNewArmPoistion();
                return this;
            }

            private void resetSpeed() {
                this.speed[0] = 15.0;
                this.speed[1] = 15.0;
                this.speed[2] = 15.0;
                this.speed[3] = this.saw ? 0.125 : 0.5;
            }

            public void updateArm() {
                this.resetSpeed();
                for (int i = 0; i < this.angles.length; ++i) {
                    this.prevAngles[i] = this.angles[i];
                }
                this.prevSawAngle = this.sawAngle;
                int serviceIndex = this.recipeIndex;
                if (TragicYuri.this.slider > 0.5) {
                    serviceIndex += serviceIndex % 2 == 0 ? 1 : -1;
                }
                if (!TileEntityMachineAssemblyFactory.this.didProcess[serviceIndex]) {
                    this.state = ArmState.RETIRE;
                }
                if (this.state == ArmState.CUT || this.state == ArmState.EXTEND) {
                    this.sawAngle += 45.0;
                }
                if (this.actionDelay > 0) {
                    --this.actionDelay;
                    return;
                }
                switch (this.state) {
                    case REPOSITION: {
                        if (!this.move()) break;
                        this.actionDelay = 2;
                        this.state = ArmState.EXTEND;
                        this.targetAngles[3] = this.saw ? -0.375 : -0.75;
                        break;
                    }
                    case EXTEND: {
                        if (!this.move()) break;
                        if (this.saw) {
                            this.state = ArmState.CUT;
                            this.targetAngles[2] = -this.targetAngles[2];
                            if (TileEntityMachineAssemblyFactory.this.muffled) break;
                            MainRegistry.proxy.playSoundClient(TileEntityMachineAssemblyFactory.this.field_145851_c, TileEntityMachineAssemblyFactory.this.field_145848_d, TileEntityMachineAssemblyFactory.this.field_145849_e, "hbm:block.assemblerCut", TileEntityMachineAssemblyFactory.this.getVolume(0.5f), 1.0f + TragicYuri.this.rand.nextFloat() * 0.25f);
                            break;
                        }
                        this.state = ArmState.RETRACT;
                        this.targetAngles[3] = 0.0;
                        if (TileEntityMachineAssemblyFactory.this.muffled) break;
                        MainRegistry.proxy.playSoundClient(TileEntityMachineAssemblyFactory.this.field_145851_c, TileEntityMachineAssemblyFactory.this.field_145848_d, TileEntityMachineAssemblyFactory.this.field_145849_e, "hbm:block.assemblerStrike", TileEntityMachineAssemblyFactory.this.getVolume(0.5f), 1.0f);
                        break;
                    }
                    case CUT: {
                        this.speed[2] = Math.abs(this.targetAngles[2] / 20.0);
                        if (!this.move()) break;
                        this.state = ArmState.RETRACT;
                        this.targetAngles[3] = 0.0;
                        break;
                    }
                    case RETRACT: {
                        if (!this.move()) break;
                        this.actionDelay = 2 + TragicYuri.this.rand.nextInt(5);
                        this.chooseNewArmPoistion();
                        this.state = TragicYuri.this.state == YuriState.RETIRING ? ArmState.RETIRE : ArmState.REPOSITION;
                        break;
                    }
                    case RETIRE: {
                        this.targetAngles[0] = 0.0;
                        this.targetAngles[1] = 0.0;
                        this.targetAngles[2] = 0.0;
                        this.targetAngles[3] = 0.0;
                        if (!this.move()) break;
                        this.actionDelay = 2 + TragicYuri.this.rand.nextInt(5);
                        this.chooseNewArmPoistion();
                        this.state = ArmState.WAIT;
                        break;
                    }
                    case WAIT: {
                        if (TragicYuri.this.state != YuriState.WORKING) break;
                        this.state = ArmState.REPOSITION;
                    }
                }
            }

            public void chooseNewArmPoistion() {
                double[][] dArrayArray;
                if (!this.saw) {
                    double[][] dArrayArray2 = new double[6][];
                    dArrayArray2[0] = new double[]{10.0, 10.0, -10.0};
                    dArrayArray2[1] = new double[]{15.0, 15.0, -15.0};
                    dArrayArray2[2] = new double[]{25.0, 10.0, -15.0};
                    dArrayArray2[3] = new double[]{30.0, 0.0, -10.0};
                    dArrayArray2[4] = new double[]{-10.0, 10.0, 0.0};
                    dArrayArray = dArrayArray2;
                    dArrayArray2[5] = new double[]{-20.0, 30.0, -15.0};
                } else {
                    double[][] dArrayArray3 = new double[6][];
                    dArrayArray3[0] = new double[]{-15.0, 15.0, -10.0};
                    dArrayArray3[1] = new double[]{-15.0, 15.0, -15.0};
                    dArrayArray3[2] = new double[]{-15.0, 15.0, 10.0};
                    dArrayArray3[3] = new double[]{-15.0, 15.0, 15.0};
                    dArrayArray3[4] = new double[]{-15.0, 15.0, 2.0};
                    dArrayArray = dArrayArray3;
                    dArrayArray3[5] = new double[]{-15.0, 15.0, -2.0};
                }
                double[][] pos = dArrayArray;
                int chosen = TragicYuri.this.rand.nextInt(pos.length);
                this.targetAngles[0] = pos[chosen][0];
                this.targetAngles[1] = pos[chosen][1];
                this.targetAngles[2] = pos[chosen][2];
            }

            private boolean move() {
                boolean didMove = false;
                for (int i = 0; i < this.angles.length; ++i) {
                    if (this.angles[i] == this.targetAngles[i]) continue;
                    didMove = true;
                    double angle = this.angles[i];
                    double target = this.targetAngles[i];
                    double turn = this.speed[i];
                    double delta = Math.abs(angle - target);
                    if (delta <= turn) {
                        this.angles[i] = this.targetAngles[i];
                        continue;
                    }
                    if (angle < target) {
                        int n = i;
                        this.angles[n] = this.angles[n] + turn;
                        continue;
                    }
                    int n = i;
                    this.angles[n] = this.angles[n] - turn;
                }
                return !didMove;
            }

            public double[] getPositions(float interp) {
                return new double[]{BobMathUtil.interp(this.prevAngles[0], this.angles[0], interp), BobMathUtil.interp(this.prevAngles[1], this.angles[1], interp), BobMathUtil.interp(this.prevAngles[2], this.angles[2], interp), BobMathUtil.interp(this.prevAngles[3], this.angles[3], interp), BobMathUtil.interp(this.prevSawAngle, this.sawAngle, interp)};
            }
        }
    }

    public class DelegateAssemblyFactoy
    implements IEnergyReceiverMK2,
    IFluidStandardTransceiverMK2 {
        @Override
        public long getPower() {
            return TileEntityMachineAssemblyFactory.this.getPower();
        }

        @Override
        public void setPower(long power) {
            TileEntityMachineAssemblyFactory.this.setPower(power);
        }

        @Override
        public long getMaxPower() {
            return TileEntityMachineAssemblyFactory.this.getMaxPower();
        }

        @Override
        public boolean isLoaded() {
            return TileEntityMachineAssemblyFactory.this.isLoaded();
        }

        @Override
        public FluidTank[] getReceivingTanks() {
            return new FluidTank[]{TileEntityMachineAssemblyFactory.this.water};
        }

        @Override
        public FluidTank[] getSendingTanks() {
            return new FluidTank[]{TileEntityMachineAssemblyFactory.this.lps};
        }

        @Override
        public FluidTank[] getAllTanks() {
            return TileEntityMachineAssemblyFactory.this.getAllTanks();
        }
    }
}

