/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.ThreeInts;
import com.hbm.handler.atmosphere.AtmosphereBlob;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.handler.atmosphere.IAtmosphereProvider;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityAirScrubber;
import cpw.mods.fml.common.Optional;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityAirPump
extends TileEntityMachineBase
implements IFluidStandardReceiver,
IAtmosphereProvider,
SimpleComponent,
CompatHandler.OCComponent {
    private int onTicks = 0;
    private boolean registered = false;
    private int recovering = 0;
    private int registerWait = 10;
    private AtmosphereBlob currentBlob;
    private int airFill = 0;
    private int wasteFill = 0;
    private int bonusFill = 0;
    public FluidTank tank;
    private Random rand = new Random();
    public CBT_Atmosphere currentAtmosphere;
    private TileEntityAirScrubber scrubber;

    public TileEntityAirPump() {
        super(1);
        this.tank = new FluidTank(Fluids.OXYGEN, 16000);
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    public void spawnParticles() {
        if (this.field_145850_b.func_82737_E() % 2L == 0L) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "tower");
            data.func_74776_a("lift", 0.1f);
            data.func_74776_a("base", 0.3f);
            data.func_74776_a("max", 1.0f);
            data.func_74768_a("life", 20 + this.field_145850_b.field_73012_v.nextInt(20));
            data.func_74768_a("color", this.tank.getTankType().getColor());
            data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextDouble() - 0.5);
            data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextDouble() - 0.5);
            data.func_74780_a("posY", (double)(this.field_145848_d + 1));
            MainRegistry.proxy.effectNT(data);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.onTicks > 0) {
                --this.onTicks;
            }
            if (this.registerWait > 0) {
                --this.registerWait;
            }
            if (this.tank.getFill() + this.bonusFill >= 20) {
                this.onTicks = 20;
                if (this.registerWait <= 0) {
                    if (!this.registered) {
                        ChunkAtmosphereManager.proxy.registerAtmosphere(this);
                        this.registered = true;
                        if (this.airFill > 1) {
                            this.recovering = 100;
                        }
                    } else if (this.recovering > 0) {
                        --this.recovering;
                        if (this.currentBlob != null) {
                            this.recovering = 0;
                        }
                    } else {
                        if (this.currentBlob != null) {
                            int size = this.currentBlob.getBlobSize();
                            if (size != 0) {
                                if (this.airFill > size) {
                                    this.airFill = size;
                                }
                                if (this.wasteFill > size) {
                                    this.wasteFill = size;
                                }
                                int toFill = Math.min(size - this.airFill, 20);
                                this.airFill += toFill;
                                if (toFill > 0) {
                                    this.consumeFromTank(toFill);
                                } else if (this.rand.nextBoolean()) {
                                    this.consumeFromTank(1);
                                    ++this.wasteFill;
                                }
                                if (this.scrubber != null && this.scrubber.isLoaded && !this.scrubber.func_145837_r()) {
                                    int toScrub = MathHelper.func_76125_a((int)this.wasteFill, (int)0, (int)20);
                                    int scrubbed = this.scrubber.scrub(toScrub);
                                    this.wasteFill -= scrubbed;
                                }
                            } else {
                                this.currentBlob = null;
                            }
                        }
                        if (this.currentBlob == null) {
                            this.consumeFromTank(20);
                            this.airFill = 0;
                            this.wasteFill = 0;
                        }
                    }
                }
            } else if (this.registered) {
                ChunkAtmosphereManager.proxy.unregisterAtmosphere(this);
                this.registered = false;
                this.currentBlob = null;
                this.airFill = 0;
                this.wasteFill = 0;
            }
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.currentAtmosphere = ChunkAtmosphereManager.proxy.getAtmosphere(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.subscribeToAllAround(this.tank.getTankType(), this);
            this.networkPackNT(100);
        } else if (this.onTicks > 0) {
            this.spawnParticles();
        }
    }

    private void consumeFromTank(int amount) {
        int bonusConsumption = MathHelper.func_76125_a((int)amount, (int)0, (int)this.bonusFill);
        this.bonusFill -= bonusConsumption;
        this.tank.setFill(this.tank.getFill() - (amount -= bonusConsumption));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.registered) {
            ChunkAtmosphereManager.proxy.unregisterAtmosphere(this);
            this.registered = false;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.onTicks);
        buf.writeInt(this.airFill);
        buf.writeInt(this.wasteFill);
        buf.writeInt(this.bonusFill);
        this.tank.serialize(buf);
        if (this.currentAtmosphere != null) {
            buf.writeBoolean(true);
            this.currentAtmosphere.writeToBytes(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.onTicks = buf.readInt();
        this.airFill = buf.readInt();
        this.wasteFill = buf.readInt();
        this.bonusFill = buf.readInt();
        this.tank.deserialize(buf);
        if (buf.readBoolean()) {
            this.currentAtmosphere = new CBT_Atmosphere();
            this.currentAtmosphere.readFromBytes(buf);
        } else {
            this.currentAtmosphere = null;
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_atmospheric_vent";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getAtmosphereDetails(Context context, Arguments args) {
        ArrayList<Object[]> fluids = new ArrayList<Object[]>();
        if (this.currentAtmosphere != null && this.currentAtmosphere.fluids != null && this.currentAtmosphere.fluids.size() != 0) {
            for (CBT_Atmosphere.FluidEntry fluid : this.currentAtmosphere.fluids) {
                fluids.add(new Object[]{fluid.fluid.getName(), fluid.pressure});
            }
        } else {
            return new Object[]{"VACUUM"};
        }
        return fluids.toArray();
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tank.getFill(), this.tank.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isSealed(Context context, Arguments args) {
        return new Object[]{this.hasSeal()};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "at");
        this.airFill = nbt.func_74762_e("fill");
        this.wasteFill = nbt.func_74762_e("waste");
        this.bonusFill = nbt.func_74762_e("bonus");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "at");
        nbt.func_74768_a("fill", this.airFill);
        nbt.func_74768_a("waste", this.wasteFill);
        nbt.func_74768_a("bonus", this.bonusFill);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public String getName() {
        return "container.atmosphereVent";
    }

    @Override
    public int getMaxBlobRadius() {
        return 256;
    }

    @Override
    public ThreeInts getRootPosition() {
        return new ThreeInts(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public FluidType getFluidType() {
        return this.tank.getTankType();
    }

    @Override
    public double getFluidPressure() {
        if (this.currentBlob == null || this.currentBlob.getBlobSize() == 0) {
            return 0.0;
        }
        return (double)this.airFill / (double)this.currentBlob.getBlobSize() * 0.2;
    }

    public boolean hasSeal() {
        return this.airFill > 1;
    }

    @Override
    public void onBlobCreated(AtmosphereBlob blob) {
        this.currentBlob = blob;
    }

    @Override
    public void consume(int amount) {
        this.airFill -= amount;
        this.wasteFill += amount;
        if (this.airFill < 1) {
            this.airFill = 1;
        }
    }

    @Override
    public void produce(int amount) {
        int produced = MathHelper.func_76125_a((int)amount, (int)0, (int)this.wasteFill);
        this.bonusFill += produced;
        this.wasteFill -= produced;
    }

    public boolean isRecycling() {
        return this.bonusFill > 0;
    }

    public boolean registerScrubber(TileEntityAirScrubber scrubber) {
        if (!this.isLoaded || this.func_145837_r()) {
            return false;
        }
        if (this.tank.getTankType() != Fluids.OXYGEN) {
            return false;
        }
        if (this.scrubber == scrubber) {
            return true;
        }
        if (this.scrubber != null && this.scrubber.isLoaded && !this.scrubber.func_145837_r() && this.scrubber.canOperate()) {
            return false;
        }
        this.scrubber = scrubber;
        return true;
    }
}

