/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.world;

import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.ImpactWorldHandler;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class RenderNTMSkyboxImpact
extends IRenderHandler {
    private static final ResourceLocation sunTexture = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation moonTexture = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation digammaStar = new ResourceLocation("hbm:textures/misc/star_digamma.png");
    private static final ResourceLocation bobmazonSat = new ResourceLocation("hbm:textures/misc/sat_bobmazon.png");
    public int starGLCallList;
    public int glSkyList;
    public int glSkyList2;
    public boolean displayListsInitialized = false;
    protected double x;
    protected double y;
    protected double z;

    public RenderNTMSkyboxImpact() {
        if (!this.displayListsInitialized) {
            this.initializeDisplayLists();
        }
    }

    private void initializeDisplayLists() {
        this.starGLCallList = GLAllocation.func_74526_a((int)3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte2 = 64;
        int i = 6;
        float f = 16.0f;
        for (int j = -384; j <= 384; j += 64) {
            for (int l = -384; l <= 384; l += 64) {
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(l + 0));
                tessellator.func_78377_a((double)(j + 64), (double)f, (double)(l + 0));
                tessellator.func_78377_a((double)(j + 64), (double)f, (double)(l + 64));
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(l + 64));
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.func_78382_b();
        for (int k = -384; k <= 384; k += 64) {
            for (int i1 = -384; i1 <= 384; i1 += 64) {
                tessellator.func_78377_a((double)(k + 64), (double)f, (double)(i1 + 0));
                tessellator.func_78377_a((double)(k + 0), (double)f, (double)(i1 + 0));
                tessellator.func_78377_a((double)(k + 0), (double)f, (double)(i1 + 64));
                tessellator.func_78377_a((double)(k + 64), (double)f, (double)(i1 + 64));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
        this.displayListsInitialized = true;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float atmosphericDust = ImpactWorldHandler.getDustForClient((World)world);
        GL11.glDisable((int)3553);
        Vec3 vec3 = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        float f1 = (float)vec3.field_72450_a;
        float f2 = (float)vec3.field_72448_b;
        float f3 = (float)vec3.field_72449_c;
        float dust = Math.max(1.0f - atmosphericDust * 2.0f, 0.0f);
        float rain = dust * (1.0f - world.func_72867_j(partialTicks));
        if (mc.field_71474_y.field_74337_g) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float f18 = world.func_72880_h(partialTicks);
        if (f18 > 0.0f) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-19.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)f18, (float)f18, (float)f18, (float)(f18 * rain));
            GL11.glCallList((int)this.starGLCallList);
            GL11.glPopMatrix();
        }
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GL11.glPushMatrix();
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f10 = 30.0f;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)(-f10), 99.9, (double)(-f10));
        tessellator.func_78377_a((double)f10, 99.9, (double)(-f10));
        tessellator.func_78377_a((double)f10, 99.9, (double)f10);
        tessellator.func_78377_a((double)(-f10), 99.9, (double)f10);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rain);
        mc.field_71446_o.func_110577_a(sunTexture);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-f10), 100.0, (double)(-f10), 0.0, 0.0);
        tessellator.func_78374_a((double)f10, 100.0, (double)(-f10), 1.0, 0.0);
        tessellator.func_78374_a((double)f10, 100.0, (double)f10, 1.0, 1.0);
        tessellator.func_78374_a((double)(-f10), 100.0, (double)f10, 0.0, 1.0);
        tessellator.func_78381_a();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)rain);
        f10 = 20.0f;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(moonTexture);
        float sinphi = FMLClientHandler.instance().getClient().field_71441_e.func_72853_d();
        int cosphi = (int)(sinphi % 4.0f);
        int var29 = (int)(sinphi / 4.0f % 2.0f);
        float yy = (float)(cosphi + 0) / 4.0f;
        float rand7 = (float)(var29 + 0) / 2.0f;
        float zz = (float)(cosphi + 1) / 4.0f;
        float rand9 = (float)(var29 + 1) / 2.0f;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-f10), -100.0, (double)f10, (double)zz, (double)rand9);
        tessellator.func_78374_a((double)f10, -100.0, (double)f10, (double)yy, (double)rand9);
        tessellator.func_78374_a((double)f10, -100.0, (double)(-f10), (double)yy, (double)rand7);
        tessellator.func_78374_a((double)(-f10), -100.0, (double)(-f10), (double)zz, (double)rand7);
        tessellator.func_78381_a();
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        float brightness = (float)Math.sin((double)world.func_72826_c(partialTicks) * Math.PI);
        brightness *= brightness;
        GL11.glPushMatrix();
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)dust);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)140.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(digammaStar);
        float digamma = HbmLivingProps.getDigamma((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        float var12 = 1.0f * (1.0f + digamma * 0.25f);
        double dist = 100.0 - (double)digamma * 2.5;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-var12), dist, (double)(-var12), 0.0, 0.0);
        tessellator.func_78374_a((double)var12, dist, (double)(-var12), 0.0, 1.0);
        tessellator.func_78374_a((double)var12, dist, (double)var12, 1.0, 1.0);
        tessellator.func_78374_a((double)(-var12), dist, (double)var12, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)rain);
        GL11.glRotatef((float)-40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(System.currentTimeMillis() % 360000L) / 1000.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(System.currentTimeMillis() % 36000L) / 100.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(bobmazonSat);
        var12 = 0.5f;
        dist = 100.0;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-var12), dist, (double)(-var12), 0.0, 0.0);
        tessellator.func_78374_a((double)var12, dist, (double)(-var12), 0.0, 1.0);
        tessellator.func_78374_a((double)var12, dist, (double)var12, 1.0, 1.0);
        tessellator.func_78374_a((double)(-var12), dist, (double)var12, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b - world.func_72919_O();
        if (d0 < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GL11.glPopMatrix();
            f8 = 1.0f;
            f9 = -((float)(d0 + 65.0));
            f10 = -f8;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)f1, (float)f2, (float)f3);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    private void renderStars() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                tessellator.func_78377_a(d5 + d24, d6 + d22, d7 + d25);
            }
        }
        tessellator.func_78381_a();
    }
}

