/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.dim.trait.CBT_Water;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemInfiniteFluid
extends Item {
    private FluidType type;
    private int amount;
    private int chance;
    private boolean requiresTable;

    public ItemInfiniteFluid(FluidType type, int amount) {
        this(type, amount, 1, false);
    }

    public ItemInfiniteFluid(FluidType type, int amount, int chance) {
        this(type, amount, chance, false);
    }

    public ItemInfiniteFluid(FluidType type, int amount, boolean requiresTable) {
        this(type, amount, 1, requiresTable);
    }

    public ItemInfiniteFluid(FluidType type, int amount, int chance, boolean requiresTable) {
        this.type = type;
        this.amount = amount;
        this.chance = chance;
        this.requiresTable = requiresTable;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean inHand) {
        if (!this.requiresTable) {
            return;
        }
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (world.field_73011_w instanceof WorldProviderOrbit) {
            stack.field_77990_d.func_74757_a("noAtmo", true);
            stack.field_77990_d.func_74768_a("fluid", 0);
            return;
        }
        CBT_Water table = CelestialBody.getTrait(world, CBT_Water.class);
        boolean canOperate = table != null && table.fluid == this.type;
        stack.field_77990_d.func_74757_a("noAtmo", !canOperate);
        stack.field_77990_d.func_74768_a("fluid", table != null ? table.fluid.getID() : 0);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this.canOperate(stack)) {
            return;
        }
        FluidType currentFluid = Fluids.fromID(stack.field_77990_d.func_74762_e("fluid"));
        if (currentFluid == Fluids.NONE) {
            list.add("Current environment has insufficient vapor pressure");
        } else {
            list.add("Current environment has an incompatible fluid table");
        }
        list.add("Requires: " + this.type.getLocalizedName() + " table");
        if (currentFluid == Fluids.NONE) {
            list.add("Releasing 0.2atm of vapor into the atmosphere will add a table on dry celestial bodies");
        } else {
            list.add("Current environment: " + currentFluid.getLocalizedName() + " table");
        }
    }

    public FluidType getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getChance() {
        return this.chance;
    }

    public boolean allowPressure(int pressure) {
        return this == ModItems.fluid_barrel_infinite || pressure == 0;
    }

    public boolean canOperate(ItemStack stack) {
        return stack.field_77990_d == null || !stack.field_77990_d.func_74767_n("noAtmo");
    }
}

