/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.handler.ArmorModHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.armor.JetpackBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public abstract class JetpackFueledBase
extends JetpackBase
implements IFillableItem {
    public FluidType fuel;
    public int maxFuel;

    public JetpackFueledBase(FluidType fuel, int maxFuel) {
        this.fuel = fuel;
        this.maxFuel = maxFuel;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.LIGHT_PURPLE + this.fuel.getLocalizedName() + ": " + JetpackFueledBase.getFuel(itemstack) + "mB / " + this.maxFuel + "mB");
        list.add("");
        super.func_77624_a(itemstack, player, list, bool);
    }

    @Override
    public void addDesc(List list, ItemStack stack, ItemStack armor) {
        ItemStack jetpack = ArmorModHandler.pryMods(armor)[1];
        if (jetpack == null) {
            return;
        }
        list.add(EnumChatFormatting.RED + "  " + stack.func_82833_r() + " (" + this.fuel.getLocalizedName() + ": " + JetpackFueledBase.getFuel(jetpack) + "mB / " + this.maxFuel + "mB)");
    }

    protected void useUpFuel(EntityPlayer player, ItemStack stack, int rate) {
        if (player.field_70173_aa % rate == 0) {
            JetpackFueledBase.setFuel(stack, JetpackFueledBase.getFuel(stack) - 1);
        }
    }

    public static int getFuel(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            return 0;
        }
        return stack.field_77990_d.func_74762_e("fuel");
    }

    public static void setFuel(ItemStack stack, int i) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("fuel", i);
    }

    public int getMaxFill(ItemStack stack) {
        return this.maxFuel;
    }

    public int getLoadSpeed(ItemStack stack) {
        return 10;
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return type == this.fuel;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        int fill = JetpackFueledBase.getFuel(stack);
        int req = this.maxFuel - fill;
        int toFill = Math.min(amount, req);
        JetpackFueledBase.setFuel(stack, fill + toFill);
        return amount - toFill;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return 0;
    }

    @Override
    public FluidType getFirstFluidType(ItemStack stack) {
        return null;
    }

    @Override
    public int getFill(ItemStack stack) {
        return 0;
    }
}

