/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ItemModOxy
extends ItemArmorMod
implements IFillableItem {
    private FluidType fuel;
    private int maxFuel;
    private int rate;
    private int consumption;
    private AudioWrapper audioBreathing;

    public ItemModOxy(int maxFuel, int rate, int consumption) {
        super(1, true, false, false, false);
        this.maxFuel = maxFuel;
        this.rate = rate;
        this.consumption = consumption;
        this.fuel = Fluids.OXYGEN;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.LIGHT_PURPLE + this.fuel.getLocalizedName() + ": " + ItemModOxy.getFuel(itemstack) + "mB / " + this.maxFuel + "mB");
        list.add("");
        super.func_77624_a(itemstack, player, list, bool);
        list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"armor.mustSeal", (Object[])new Object[0]));
    }

    @Override
    public void addDesc(List list, ItemStack stack, ItemStack armor) {
        list.add(EnumChatFormatting.RED + "  " + stack.func_82833_r() + " (" + this.fuel.getLocalizedName() + ": " + ItemModOxy.getFuel(stack) + "mB / " + this.maxFuel + "mB");
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        if (entity.field_70170_p.field_72995_K) {
            EntityPlayer player = MainRegistry.proxy.me();
            if (entity != player) {
                return;
            }
            ItemStack stack = ArmorModHandler.pryMods(armor)[1];
            if (ItemModOxy.getInUse(stack) && !player.field_71075_bZ.field_75098_d) {
                if (this.audioBreathing == null || !this.audioBreathing.isPlaying()) {
                    this.audioBreathing = MainRegistry.proxy.getLoopedSound("hbm:player.plss_breathing", (Entity)entity, 0.1f, 5.0f, 1.0f, 10);
                    this.audioBreathing.startSound();
                }
                this.audioBreathing.keepAlive();
            } else if (this.audioBreathing != null) {
                this.audioBreathing.stopSound();
                this.audioBreathing = null;
            }
        }
    }

    public boolean attemptBreathing(EntityLivingBase entity, ItemStack stack, CBT_Atmosphere atmosphere, boolean forceConsume) {
        if (!forceConsume && ChunkAtmosphereManager.proxy.canBreathe(atmosphere)) {
            ItemModOxy.setInUse(stack, false);
            return true;
        }
        if (entity.field_70173_aa % this.rate == 0) {
            ItemModOxy.setFuel(stack, Math.max(ItemModOxy.getFuel(stack) - this.consumption, 0));
        }
        boolean hasFuel = ItemModOxy.getFuel(stack) > 0;
        ItemModOxy.setInUse(stack, hasFuel);
        return hasFuel;
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return type == this.fuel;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        int fill = ItemModOxy.getFuel(stack);
        int toFill = Math.min(amount, this.maxFuel - fill);
        ItemModOxy.setFuel(stack, fill + toFill);
        return amount - toFill;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return 0;
    }

    @Override
    public FluidType getFirstFluidType(ItemStack stack) {
        return null;
    }

    public static boolean getInUse(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            return false;
        }
        return stack.field_77990_d.func_74762_e("ticks") > 20;
    }

    public static void setInUse(ItemStack stack, boolean inUse) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (inUse) {
            stack.field_77990_d.func_74768_a("ticks", stack.field_77990_d.func_74762_e("ticks") + 1);
        } else {
            stack.field_77990_d.func_74768_a("ticks", 0);
        }
    }

    public static int getFuel(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            return 0;
        }
        return stack.field_77990_d.func_74762_e("fuel");
    }

    public static void setFuel(ItemStack stack, int i) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("fuel", i);
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public int getFill(ItemStack stack) {
        return 0;
    }
}

