/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.trait;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.util.BobMathUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class FT_Combustible
extends FluidTrait {
    protected FuelGrade fuelGrade;
    protected long combustionEnergy;

    public FT_Combustible() {
    }

    public FT_Combustible(FuelGrade grade, long energy) {
        this.fuelGrade = grade;
        this.combustionEnergy = energy;
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add(EnumChatFormatting.GOLD + "[Combustible]");
        if (this.combustionEnergy > 0L) {
            info.add(EnumChatFormatting.GOLD + "Provides " + EnumChatFormatting.RED + "" + BobMathUtil.getShortNumber(this.combustionEnergy) + "HE " + EnumChatFormatting.GOLD + "per bucket");
            info.add(EnumChatFormatting.GOLD + "Fuel grade: " + EnumChatFormatting.RED + this.fuelGrade.getGrade());
        }
    }

    public long getCombustionEnergy() {
        return this.combustionEnergy;
    }

    public FuelGrade getGrade() {
        return this.fuelGrade;
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("energy").value(this.combustionEnergy);
        writer.name("grade").value(this.fuelGrade.name());
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        this.combustionEnergy = obj.get("energy").getAsLong();
        this.fuelGrade = FuelGrade.valueOf(obj.get("grade").getAsString());
    }

    public static enum FuelGrade {
        LOW("Low"),
        MEDIUM("Medium"),
        HIGH("High"),
        AERO("Aviation"),
        GAS("Gaseous");

        private String grade;

        private FuelGrade(String grade) {
            this.grade = grade;
        }

        public String getGrade() {
            return this.grade;
        }
    }
}

