/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntitySiegeLaser
extends EntityThrowable {
    private float damage = 2.0f;
    private float explosive = 0.0f;
    private float breakChance = 0.0f;
    private boolean incendiary = false;

    public EntitySiegeLaser(World world) {
        super(world);
    }

    public EntitySiegeLaser(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntitySiegeLaser(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(12, (Object)0xFFFFFF);
    }

    public EntitySiegeLaser setDamage(float f) {
        this.damage = f;
        return this;
    }

    public EntitySiegeLaser setExplosive(float f) {
        this.explosive = f;
        return this;
    }

    public EntitySiegeLaser setBreakChance(float f) {
        this.breakChance = f;
        return this;
    }

    public EntitySiegeLaser setIncendiary() {
        this.incendiary = true;
        return this;
    }

    public EntitySiegeLaser setColor(int color) {
        this.func_70096_w().func_75692_b(12, (Object)color);
        return this;
    }

    public int getColor() {
        return this.func_70096_w().func_75679_c(12);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 60) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            Object dmg = this.func_85052_h() != null ? new EntityDamageSourceIndirect("laser", (Entity)this, (Entity)this.func_85052_h()) : new DamageSource("laser");
            if (mop.field_72308_g.func_70097_a(dmg, this.damage)) {
                this.func_70106_y();
                if (this.incendiary) {
                    mop.field_72308_g.func_70015_d(3);
                }
                if (this.explosive > 0.0f) {
                    this.field_70170_p.func_72885_a((Entity)this, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, this.explosive, this.incendiary, false);
                }
            }
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (this.explosive > 0.0f) {
                this.field_70170_p.func_72885_a((Entity)this, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, this.explosive, this.incendiary, false);
            } else if (this.incendiary) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
                int x = mop.field_72311_b + dir.offsetX;
                int y = mop.field_72312_c + dir.offsetY;
                int z = mop.field_72309_d + dir.offsetZ;
                if (this.field_70170_p.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_70170_p, x, y, z)) {
                    this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                }
            }
            if (this.field_70146_Z.nextFloat() < this.breakChance) {
                this.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
            }
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("damage", this.damage);
        nbt.func_74776_a("explosive", this.explosive);
        nbt.func_74776_a("breakChance", this.breakChance);
        nbt.func_74757_a("incendiary", this.incendiary);
        nbt.func_74768_a("color", this.getColor());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.damage = nbt.func_74760_g("damage");
        this.explosive = nbt.func_74760_g("explosive");
        this.breakChance = nbt.func_74760_g("breakChance");
        this.incendiary = nbt.func_74767_n("incendiary");
        this.setColor(nbt.func_74762_e("color"));
    }
}

