/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.trait;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Destroyed;
import com.hbm.dim.trait.CelestialBodyTrait;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CBT_War
extends CelestialBodyTrait {
    public int health;
    public int shield;
    public List<Projectile> projectiles;

    public CBT_War() {
        this.health = 100;
        this.shield = 0;
        this.projectiles = new ArrayList<Projectile>();
    }

    public CBT_War(int health, int shield) {
        this.health = health;
        this.shield = shield;
        this.projectiles = new ArrayList<Projectile>();
    }

    public void launchProjectile(Projectile proj) {
        this.projectiles.add(proj);
    }

    public void launchProjectile(float traveltime, int size, int damage, float x, double y, double z, ProjectileType type, int target) {
        Projectile projectile = new Projectile(traveltime, size, damage, x, y, z, type, target);
        this.projectiles.add(projectile);
    }

    public void split(int amount, Projectile projectile, ProjectileType type) {
        if (projectile.getTravel() <= 0.0f) {
            for (int j = 0; j < amount; ++j) {
                Random rand = new Random();
                float randX = rand.nextFloat() * 160.0f - 80.0f;
                float randY = rand.nextFloat() * 90.0f - 80.0f;
                this.launchProjectile(Math.abs(20 + j * 10), projectile.getSize(), projectile.getDamage(), (float)projectile.getTranslateX(), projectile.getTranslateY() - (double)(randY * (float)j), projectile.getTranslateZ() + (double)(randX * (float)j), type, projectile.getTarget());
                projectile.GUIangle = projectile.GUIangle;
            }
            this.destroyProjectile(projectile);
        }
    }

    @Override
    public void update(boolean isremote) {
        if (!isremote && this != null) {
            for (int i = 0; i < this.getProjectiles().size(); ++i) {
                Projectile projectile = this.getProjectiles().get(i);
                projectile.update();
                if (projectile.getTravel() <= 0.0f) {
                    projectile.impact();
                }
                if (projectile.getAnimtime() >= 100) {
                    this.destroyProjectile(projectile);
                    WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(projectile.getTarget());
                    --i;
                    System.out.println("damaged: " + targetWorld + " health left: " + this.health);
                    if (this.health > 0) {
                        CelestialBody.damage(projectile.getDamage(), (World)targetWorld);
                    } else if (this.health <= 0) {
                        CelestialBody target = CelestialBody.getPlanet((World)targetWorld);
                        target.modifyTraits(new CBT_Destroyed());
                        this.health = 0;
                    }
                }
                if (projectile.getType() != ProjectileType.SPLITSHOT || !(projectile.getTravel() <= 0.0f)) continue;
                this.split(4, projectile, ProjectileType.SMALL);
                this.destroyProjectile(projectile);
                --i;
            }
        }
    }

    public void destroyProjectile(Projectile proj) {
        this.projectiles.remove(proj);
    }

    public List<Projectile> getProjectiles() {
        return this.projectiles;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("health", this.health);
        nbt.func_74768_a("shield", this.shield);
        NBTTagCompound projectilesTag = new NBTTagCompound();
        for (int i = 0; i < this.projectiles.size(); ++i) {
            NBTTagCompound projTag = new NBTTagCompound();
            this.projectiles.get(i).writeToNBT(projTag);
            projectilesTag.func_74782_a("projectile" + i, (NBTBase)projTag);
        }
        nbt.func_74782_a("projectiles", (NBTBase)projectilesTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.shield = nbt.func_74762_e("shield");
        this.health = nbt.func_74762_e("health");
        NBTTagCompound projectilesTag = nbt.func_74775_l("projectiles");
        this.projectiles = new ArrayList<Projectile>();
        int i = 0;
        while (projectilesTag.func_74764_b("projectile" + i)) {
            NBTTagCompound projTag = projectilesTag.func_74775_l("projectile" + i);
            Projectile projectile = new Projectile();
            projectile.readFromNBT(projTag);
            this.projectiles.add(projectile);
            ++i;
        }
    }

    @Override
    public void writeToBytes(ByteBuf buf) {
        buf.writeInt(this.health);
        buf.writeInt(this.shield);
        buf.writeInt(this.projectiles.size());
        for (Projectile projectile : this.projectiles) {
            projectile.writeToBytes(buf);
        }
    }

    @Override
    public void readFromBytes(ByteBuf buf) {
        this.shield = buf.readInt();
        this.health = buf.readInt();
        int numProjectiles = buf.readInt();
        this.projectiles = new ArrayList<Projectile>(numProjectiles);
        for (int i = 0; i < numProjectiles; ++i) {
            Projectile projectile = new Projectile();
            projectile.readFromBytes(buf);
            this.projectiles.add(projectile);
        }
    }

    public static enum ProjectileType {
        SMALL,
        MEDIUM,
        HUGE,
        INCENDIARY,
        NUCLEAR,
        SPLITSHOT;

    }

    public static class Projectile {
        private float traveltime;
        private int size;
        private int damage;
        private int animtime;
        private float flashtime;
        private double translateX;
        private double translateY;
        private double translateZ;
        private ProjectileType type;
        public int GUIangle;
        private int target;

        public Projectile() {
            this.animtime = 0;
            this.flashtime = 0.0f;
            this.type = ProjectileType.MEDIUM;
        }

        public Projectile(float traveltime, int size, int damage, double posX, double posY, double posZ, ProjectileType type, int target) {
            this.traveltime = traveltime;
            this.size = size;
            this.damage = damage;
            this.animtime = 0;
            this.flashtime = 0.0f;
            this.translateX = posX;
            this.translateY = posY;
            this.translateZ = posZ;
            this.type = type;
            this.target = target;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("damage", this.damage);
            nbt.func_74776_a("traveltime", this.traveltime);
            nbt.func_74768_a("size", this.size);
            nbt.func_74780_a("translateX", this.translateX);
            nbt.func_74780_a("translateY", this.translateY);
            nbt.func_74780_a("translateZ", this.translateZ);
            nbt.func_74768_a("animtime", this.animtime);
            nbt.func_74778_a("type", this.type.name());
            nbt.func_74768_a("target", this.target);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.damage = nbt.func_74762_e("damage");
            this.traveltime = nbt.func_74760_g("traveltime");
            this.size = nbt.func_74762_e("size");
            this.translateX = nbt.func_74769_h("translateX");
            this.translateY = nbt.func_74769_h("translateY");
            this.translateZ = nbt.func_74769_h("translateZ");
            this.animtime = nbt.func_74762_e("animtime");
            this.type = ProjectileType.valueOf(nbt.func_74779_i("type"));
            this.target = nbt.func_74762_e("target");
        }

        public void writeToBytes(ByteBuf buf) {
            buf.writeInt(this.damage);
            buf.writeFloat(this.traveltime);
            buf.writeInt(this.size);
            buf.writeDouble(this.translateX);
            buf.writeDouble(this.translateY);
            buf.writeDouble(this.translateZ);
            buf.writeInt(this.animtime);
            buf.writeByte(this.type.ordinal());
            buf.writeInt(this.GUIangle);
            buf.writeInt(this.target);
        }

        public void readFromBytes(ByteBuf buf) {
            this.damage = buf.readInt();
            this.traveltime = buf.readFloat();
            this.size = buf.readInt();
            this.translateX = buf.readDouble();
            this.translateY = buf.readDouble();
            this.translateZ = buf.readDouble();
            this.animtime = buf.readInt();
            this.type = ProjectileType.values()[buf.readByte()];
            this.GUIangle = buf.readInt();
            this.target = buf.readInt();
        }

        public ProjectileType getType() {
            return this.type;
        }

        public void setType(ProjectileType type) {
            this.type = type;
        }

        public float getFlashtime() {
            return this.flashtime;
        }

        public void update() {
            if (this.traveltime > 0.0f) {
                this.traveltime -= 1.0f;
            } else {
                this.traveltime = 0.0f;
                if (this.getType() != ProjectileType.SPLITSHOT) {
                    this.animtime = Math.min(100, this.animtime + 1);
                }
            }
        }

        public void impact() {
            this.flashtime += 0.6f;
            this.flashtime = Math.min(100.0f, this.flashtime + 0.1f * (100.0f - this.flashtime) * 0.15f);
            if (this.flashtime >= 100.0f) {
                this.flashtime = 100.0f;
            }
            if (this.animtime == 0) {
                this.flashtime = 0.0f;
            }
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getDamage() {
            return this.damage;
        }

        public float getTravel() {
            return this.traveltime;
        }

        public void setTravel(float travel) {
            this.traveltime = travel;
        }

        public void setDamage(int damage) {
            this.damage = damage;
        }

        public int getAnimtime() {
            return this.animtime;
        }

        public void setAnimtime(int animtime) {
            this.animtime = animtime;
        }

        public void setFlashtime(float flashtime) {
            this.flashtime = flashtime;
        }

        public double getTranslateX() {
            return this.translateX;
        }

        public int getTarget() {
            return this.target;
        }

        public double getTranslateY() {
            return this.translateY;
        }

        public double getTranslateZ() {
            return this.translateZ;
        }
    }
}

