/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.minmus;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.ChunkProviderCelestial;
import com.hbm.dim.mapgen.MapGenCrater;
import com.hbm.dim.mapgen.MapGenVanillaCaves;
import com.hbm.world.gen.terrain.MapGenBubble;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;

public class ChunkProviderMinmus
extends ChunkProviderCelestial {
    private MapGenBase caveGenerator = new MapGenVanillaCaves(ModBlocks.minmus_stone).withLava(ModBlocks.minmus_smooth);
    private MapGenCrater smallCrater = new MapGenCrater(5);
    private MapGenCrater largeCrater = new MapGenCrater(96);
    private MapGenBubble brine = new MapGenBubble(WorldConfig.minmusBrineSpawn);

    public ChunkProviderMinmus(World world, long seed, boolean hasMapFeatures) {
        super(world, seed, hasMapFeatures);
        this.smallCrater.setSize(6, 24);
        this.largeCrater.setSize(64, 128);
        this.smallCrater.regolith = this.largeCrater.regolith = ModBlocks.minmus_regolith;
        this.smallCrater.rock = this.largeCrater.rock = ModBlocks.minmus_stone;
        this.brine.block = ModBlocks.ore_brine;
        this.brine.meta = (byte)CelestialBody.getMeta(world);
        this.brine.replace = ModBlocks.minmus_stone;
        this.brine.setSize(8, 16);
        this.stoneBlock = ModBlocks.minmus_stone;
        this.seaBlock = ModBlocks.minmus_smooth;
        this.seaLevel = 63;
    }

    @Override
    public ChunkProviderCelestial.BlockMetaBuffer getChunkPrimer(int x, int z) {
        ChunkProviderCelestial.BlockMetaBuffer buffer = super.getChunkPrimer(x, z);
        this.brine.setMetas(buffer.metas);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, buffer.blocks);
        this.smallCrater.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.largeCrater.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.brine.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        return buffer;
    }
}

