/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.mapgen;

import com.hbm.config.SpaceConfig;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;

public class MapGenVolcano
extends MapGenBase {
    private int chancePerChunk = 100;
    private int minSize = 32;
    private int maxSize = 64;
    private Block coreBlock;
    private Block materialBlock;

    public MapGenVolcano(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
    }

    public void setSize(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.field_75040_a = maxSize / 8 + 1;
    }

    public void setMaterial(Block coreBlock, Block mateBlock) {
        this.coreBlock = coreBlock;
        this.materialBlock = mateBlock;
    }

    private double heightFunc(double x, double rad, double depth) {
        double xs = x / (rad * 2.0);
        double inner = x * x * x / (rad / 4.0) + 32.0;
        double outer = 1.0 / (xs * xs);
        return Math.min(inner, outer) * depth;
    }

    protected void func_151538_a(World world, int offsetX, int offsetZ, int chunkX, int chunkZ, Block[] blocks) {
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(offsetX) % this.chancePerChunk && this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(offsetZ) % this.chancePerChunk) {
            double radius = this.field_75038_b.nextInt(this.maxSize - this.minSize) + this.minSize;
            double depth = 0.75;
            int xCoord = -offsetX + chunkX;
            int zCoord = -offsetZ + chunkZ;
            for (int bx = 15; bx >= 0; --bx) {
                block1: for (int bz = 15; bz >= 0; --bz) {
                    for (int y = 254; y >= 0; --y) {
                        int i;
                        int index = (bx * 16 + bz) * 256 + y;
                        if (blocks[index] == null || !blocks[index].func_149662_c()) continue;
                        int x = xCoord * 16 + bx;
                        int z = zCoord * 16 + bz;
                        double r = Math.sqrt(x * x + z * z);
                        if (!(r - (double)this.field_75038_b.nextInt(16) <= radius)) continue block1;
                        int height = (int)MathHelper.func_151237_a((double)this.heightFunc(r, radius, depth), (double)0.0, (double)(y - 1));
                        if (height > 0) {
                            for (i = 0; i < height && i + y < 255; ++i) {
                                blocks[index + i] = this.materialBlock;
                            }
                        } else {
                            for (i = 0; i > height && i + y > 1; --i) {
                                blocks[index + i + 1] = null;
                            }
                        }
                        index += height;
                        y += height;
                        if (x != 0 || z != 0 || !SpaceConfig.enableVolcanoGen) continue block1;
                        blocks[index + 1] = this.coreBlock;
                        continue block1;
                    }
                }
            }
        }
    }
}

