/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.eve;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.ChunkProviderCelestial;
import com.hbm.dim.eve.biome.BiomeGenBaseEve;
import com.hbm.dim.noise.MapGenVNoise;
import com.hbm.world.gen.terrain.MapGenBubble;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class ChunkProviderEve
extends ChunkProviderCelestial {
    private final NoiseGeneratorPerlin crackNoise;
    private final MapGenVNoise noise = new MapGenVNoise();
    private MapGenBubble oil = new MapGenBubble(WorldConfig.eveGasSpawn);

    public ChunkProviderEve(World world, long seed, boolean hasMapFeatures) {
        super(world, seed, hasMapFeatures);
        this.reclamp = false;
        this.stoneBlock = ModBlocks.eve_rock;
        this.seaBlock = ModBlocks.mercury_block;
        this.crackNoise = new NoiseGeneratorPerlin(world.field_73012_v, 4);
        this.noise.fluidBlock = ModBlocks.mercury_block;
        this.noise.rockBlock = ModBlocks.eve_rock;
        this.noise.surfBlock = ModBlocks.eve_silt;
        this.noise.cellSize = 72;
        this.noise.crackSize = 2.0;
        this.noise.plateThickness = 35;
        this.noise.shapeExponent = 2.0;
        this.noise.plateStartY = 57;
        this.noise.applyToBiome = BiomeGenBaseEve.eveOcean;
        this.oil.block = ModBlocks.ore_gas;
        this.oil.meta = (byte)CelestialBody.getMeta(world);
        this.oil.replace = ModBlocks.eve_rock;
        this.oil.setSize(8, 16);
    }

    @Override
    public ChunkProviderCelestial.BlockMetaBuffer getChunkPrimer(int x, int z) {
        ChunkProviderCelestial.BlockMetaBuffer buffer = super.getChunkPrimer(x, z);
        this.oil.setMetas(buffer.metas);
        boolean hasOcean = false;
        boolean hasSeismic = false;
        for (int i = 0; i < this.biomesForGeneration.length; ++i) {
            if (this.biomesForGeneration[i] == BiomeGenBaseEve.eveOcean) {
                hasOcean = true;
            }
            if (this.biomesForGeneration[i] == BiomeGenBaseEve.eveSeismicPlains) {
                hasSeismic = true;
            }
            if (hasOcean && hasSeismic) break;
        }
        if (hasSeismic) {
            this.generateCracks(x, z, buffer);
        }
        if (hasOcean) {
            this.noise.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        this.oil.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        return buffer;
    }

    private void generateCracks(int chunkX, int chunkZ, ChunkProviderCelestial.BlockMetaBuffer buffer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index;
                int y;
                double crackValue;
                if (this.biomesForGeneration[x + z * 16] != BiomeGenBaseEve.eveSeismicPlains || !((crackValue = this.crackNoise.func_151601_a((double)(chunkX * 16 + x) * 0.3, (double)(chunkZ * 16 + z) * 0.3)) > 0.9)) continue;
                int bedrockY = -1;
                for (y = 0; y < 256; ++y) {
                    index = (x * 16 + z) * 256 + y;
                    if (buffer.blocks[index] == Blocks.field_150357_h) {
                        if (bedrockY != -1) continue;
                        bedrockY = y;
                        continue;
                    }
                    buffer.blocks[index] = Blocks.field_150350_a;
                }
                if (bedrockY == -1) continue;
                for (y = bedrockY + 1; y < Math.min(bedrockY + 10, 256); ++y) {
                    index = (x * 16 + z) * 256 + y;
                    buffer.blocks[index] = Blocks.field_150353_l;
                }
            }
        }
    }
}

