/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.hbm.config.CommonConfig;
import com.hbm.dim.BiomeCollisionException;
import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;

public class SpaceConfig {
    public static int moonDimension = 413015;
    public static int dunaDimension = 413016;
    public static int ikeDimension = 413017;
    public static int eveDimension = 413018;
    public static int dresDimension = 413019;
    public static int mohoDimension = 413020;
    public static int minmusDimension = 413021;
    public static int laytheDimension = 413022;
    public static int orbitDimension = 413023;
    public static int tektoDimension = 413024;
    public static int thatmoDimension = 413025;
    public static int orbitBiome = 126;
    public static int moonBiome = 125;
    public static int minmusBiome = 124;
    public static int minmusBasinBiome = 123;
    public static int dunaBiome = 122;
    public static int dunaLowlandsBiome = 121;
    public static int dunaPolarBiome = 120;
    public static int dunaHillsBiome = 119;
    public static int dunaPolarHillsBiome = 118;
    public static int eveBiome = 117;
    public static int eveMountainsBiome = 116;
    public static int eveOceanBiome = 115;
    public static int eveSeismicBiome = 114;
    public static int eveRiverBiome = 113;
    public static int dresBiome = 112;
    public static int dresBasinBiome = 111;
    public static int mohoBiome = 101;
    public static int mohoBasaltBiome = 100;
    public static int mohoLavaBiome = 99;
    public static int mohoPlateauBiome = 98;
    public static int laytheBiome = 97;
    public static int laytheOceanBiome = 96;
    public static int laythePolarBiome = 95;
    public static int laytheCoastBiome = 94;
    public static int ikeBiome = 93;
    public static int tektoPolyvinylBiome = 92;
    public static int tektoHalogenHillBiome = 91;
    public static int tektoRiverBiome = 90;
    public static int tektoForestBiome = 89;
    public static int tektoVinylIslandBiome = 88;
    public static int thatmoBiome = 87;
    public static boolean allowNetherPortals = false;
    public static boolean enableVolcanoGen = true;
    public static boolean crashOnBiomeConflict = true;
    public static boolean showOreLocations = true;
    public static int maxProbeDistance = 32000;
    public static int maxStationDistance = 32000;
    private static HashMap<Integer, String> registeredIds = new HashMap();

    public static void loadFromConfig(Configuration config) {
        String CATEGORY_DIM = "17_dims";
        allowNetherPortals = CommonConfig.createConfigBool(config, "17_dims", "17.00_allowNetherPortals", "Should Nether portals function on other celestial bodies?", false);
        moonDimension = CommonConfig.createConfigInt(config, "17_dims", "17.01_moonDimension", "Mun dimension ID", moonDimension);
        dunaDimension = CommonConfig.createConfigInt(config, "17_dims", "17.02_dunaDimension", "Duna dimension ID", dunaDimension);
        ikeDimension = CommonConfig.createConfigInt(config, "17_dims", "17.03_ikeDimension", "Ike dimension ID", ikeDimension);
        eveDimension = CommonConfig.createConfigInt(config, "17_dims", "17.04_eveDimension", "Eve dimension ID", eveDimension);
        dresDimension = CommonConfig.createConfigInt(config, "17_dims", "17.05_dresDimension", "Dres dimension ID", dresDimension);
        mohoDimension = CommonConfig.createConfigInt(config, "17_dims", "17.06_mohoDimension", "Moho dimension ID", mohoDimension);
        minmusDimension = CommonConfig.createConfigInt(config, "17_dims", "17.07_minmusDimension", "Minmus dimension ID", minmusDimension);
        laytheDimension = CommonConfig.createConfigInt(config, "17_dims", "17.08_laytheDimension", "Laythe dimension ID", laytheDimension);
        orbitDimension = CommonConfig.createConfigInt(config, "17_dims", "17.09_orbitDimension", "Orbital dimension ID", orbitDimension);
        tektoDimension = CommonConfig.createConfigInt(config, "17_dims", "17.10_tektoDimension", "Tekto dimension ID", tektoDimension);
        thatmoDimension = CommonConfig.createConfigInt(config, "17_dims", "17.10_thatmoDimension", "Thatmo dimension ID", thatmoDimension);
        String CATEGORY_GENERAL = "01_general";
        maxProbeDistance = CommonConfig.createConfigInt(config, "01_general", "1.90_maxProbeDistance", "How far from the center of the dimension can probes generate landing coordinates", maxProbeDistance);
        maxStationDistance = CommonConfig.createConfigInt(config, "01_general", "1.93_maxStationDistance", "How far from the center of the dimension can orbital stations be generated", maxStationDistance);
        enableVolcanoGen = CommonConfig.createConfigBool(config, "01_general", "1.91_enableVolcanoGen", "Should volcanoes be active when spawning, disabling will prevent natural volcanoes from spewing lava and growing", enableVolcanoGen);
        crashOnBiomeConflict = CommonConfig.createConfigBool(config, "01_general", "1.92_crashOnBiomeConflict", "To avoid biome ID collisions, the game will crash if one occurs, and give instructions on how to fix. Only disable this if you know what you're doing!", crashOnBiomeConflict);
        showOreLocations = CommonConfig.createConfigBool(config, "01_general", "1.93_showOreLocations", "Should ores indicate which planets they can be found on.", showOreLocations);
        int defaultBiomeOffset = Loader.isModLoaded((String)"endlessids") ? 12000 : 0;
        String CATEGORY_BIOME = "16_biomes";
        moonBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.02_moonBiome", "Mun Biome ID", moonBiome + defaultBiomeOffset);
        dunaBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.03_dunaBiome", "Duna Biome ID", dunaBiome + defaultBiomeOffset);
        dunaLowlandsBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.04_dunaLowlandsBiome", "Duna Lowlands Biome ID", dunaLowlandsBiome + defaultBiomeOffset);
        dunaPolarBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.05_dunaPolarBiome", "Duna Polar Biome ID", dunaPolarBiome + defaultBiomeOffset);
        dunaHillsBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.06_dunaHillsBiome", "Duna Hills Biome ID", dunaHillsBiome + defaultBiomeOffset);
        dunaPolarHillsBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.07_dunaPolarHillsBiome", "Duna Polar Hills Biome ID", dunaPolarHillsBiome + defaultBiomeOffset);
        eveBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.08_eveBiome", "Eve Biome ID", eveBiome + defaultBiomeOffset);
        eveMountainsBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.09_eveMountainsBiome", "Eve Mountains Biome ID", eveMountainsBiome + defaultBiomeOffset);
        eveOceanBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.10_eveOceanBiome", "Eve Ocean Biome ID", eveOceanBiome + defaultBiomeOffset);
        eveSeismicBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.12_eveSeismicBiome", "Eve Seismic Biome ID", eveSeismicBiome + defaultBiomeOffset);
        eveRiverBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.24_eveRiverBiome", "Eve River Biome ID", eveRiverBiome + defaultBiomeOffset);
        ikeBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.13_ikeBiome", "Ike Biome ID", ikeBiome + defaultBiomeOffset);
        laytheBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.14_laytheBiome", "Laythe Biome ID", laytheBiome + defaultBiomeOffset);
        laytheOceanBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.15_laytheOceanBiome", "Laythe Ocean Biome ID", laytheOceanBiome + defaultBiomeOffset);
        laythePolarBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.16_laythePolarBiome", "Laythe Polar Biome ID", laythePolarBiome + defaultBiomeOffset);
        minmusBasinBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.17_minmusBasinsBiome", "Minmus Basins Biome ID", minmusBasinBiome + defaultBiomeOffset);
        minmusBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.18_minmusBiome", "Minmus Biome ID", minmusBiome + defaultBiomeOffset);
        mohoBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.19_mohoBiome", "Moho Biome ID", mohoBiome + defaultBiomeOffset);
        dresBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.20_dresBiome", "Dres Biome ID", dresBiome + defaultBiomeOffset);
        dresBasinBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.21_dresBasinsBiome", "Dres Basins Biome ID", dresBasinBiome + defaultBiomeOffset);
        mohoBasaltBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.22_mohoBasaltBiome", "Moho Basalt Biome ID", mohoBasaltBiome + defaultBiomeOffset);
        orbitBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.23_orbitBiome", "Space Biome ID", orbitBiome + defaultBiomeOffset);
        laytheCoastBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.24_laytheCoastBiome", "Laythe Coast Biome ID", laytheCoastBiome + defaultBiomeOffset);
        mohoLavaBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.25_mohoLavaBiome", "Moho Lava Biome ID", mohoLavaBiome + defaultBiomeOffset);
        mohoPlateauBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.26_mohoPlateauBiome", "Moho Plateau Biome ID", mohoPlateauBiome + defaultBiomeOffset);
        tektoPolyvinylBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.27_tektoPolyvinylBiome", "Tekto Polyvinyl Biome ID", tektoPolyvinylBiome + defaultBiomeOffset);
        tektoHalogenHillBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.28_tektoHalogenHillBiome", "Tekto Halogen Hills Biome ID", tektoHalogenHillBiome + defaultBiomeOffset);
        tektoRiverBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.29_tektoRiverBiome", "Tekto River Biome ID", tektoRiverBiome + defaultBiomeOffset);
        tektoForestBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.30_tektoForestBiome", "Tekto Forest Biome ID", tektoForestBiome + defaultBiomeOffset);
        tektoVinylIslandBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.31_tektoVinylSandsBiome", "Tekto Vinyl Sands Biome ID", tektoVinylIslandBiome + defaultBiomeOffset);
        thatmoBiome = SpaceConfig.createConfigBiome(config, "16_biomes", "16.32_thatmoBiome", "Thatmo Biome ID", thatmoBiome + defaultBiomeOffset);
    }

    private static int createConfigBiome(Configuration config, String category, String name, String comment, int def) {
        int value = CommonConfig.createConfigInt(config, category, name, comment, def);
        if (registeredIds.containsKey(value)) {
            throw new BiomeCollisionException(String.format("Biome ID conflict, attempted to register NTM Space biome on top of another:\nBiome config 1: %s\nBiome config 2: %s\nPlease modify hbm.cfg to fix this error. Note that the maximum biome ID is 255, if you run out you MUST install EndlessIDs!", name, registeredIds.get(value)));
        }
        registeredIds.put(value, name);
        return value;
    }
}

