/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.network.TileEntityPneumoTube;
import com.hbm.util.Compat;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PneumoTube
extends BlockContainer
implements IToolable,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    public IIcon baseIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconIn;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconOut;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconConnector;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconStraight;
    @SideOnly(value=Side.CLIENT)
    public IIcon activeIcon;
    public boolean[] renderSides = new boolean[]{true, true, true, true, true, true};
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public PneumoTube() {
        super(Material.field_151573_f);
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPneumoTube();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.iconIn = reg.func_94245_a("hbm:pneumatic_tube_in");
        this.iconOut = reg.func_94245_a("hbm:pneumatic_tube_out");
        this.iconConnector = reg.func_94245_a("hbm:pneumatic_tube_connector");
        this.iconStraight = reg.func_94245_a("hbm:pneumatic_tube_straight");
        this.activeIcon = this.baseIcon = this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.activeIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return this.renderSides[side % 6];
    }

    public void resetRenderSides() {
        for (int i = 0; i < 6; ++i) {
            this.renderSides[i] = true;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null && IToolable.ToolType.getType(player.func_70694_bm()) == IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        if (!player.func_70093_af()) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileEntityPneumoTube) {
                TileEntityPneumoTube tube = (TileEntityPneumoTube)tile;
                if (tube.isCompressor()) {
                    if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
                        if (!world.field_72995_K) {
                            boolean canUse;
                            FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, x, y, z, player.func_70694_bm());
                            boolean bl = canUse = !type.hasTrait(FluidTraitSimple.FT_Amat.class) && !type.hasTrait(FT_Corrosive.class) && (type.hasTrait(FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class));
                            if (canUse) {
                                tube.compair.setTankType(type);
                                tube.func_70296_d();
                                player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
                            } else {
                                player.func_146105_b(new ChatComponentText("Invalid gas!").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                            }
                        }
                    } else {
                        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
                    }
                    return true;
                }
                if (tube.isEndpoint()) {
                    FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)1, (World)world, (int)x, (int)y, (int)z);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntity tile;
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityPneumoTube tube = (TileEntityPneumoTube)world.func_147438_o(x, y, z);
        ForgeDirection rot = player.func_70093_af() ? tube.ejectionDir : tube.insertionDir;
        ForgeDirection oth = player.func_70093_af() ? tube.insertionDir : tube.ejectionDir;
        for (int i = 0; i < 7 && (rot = ForgeDirection.getOrientation((int)((rot.ordinal() + 1) % 7))) != ForgeDirection.UNKNOWN && (rot == oth || (tile = Compat.getTileStandard(world, x + rot.offsetX, y + rot.offsetY, z + rot.offsetZ)) instanceof TileEntityPneumoTube || !(tile instanceof IInventory)); ++i) {
        }
        if (player.func_70093_af()) {
            tube.ejectionDir = rot;
        } else {
            tube.insertionDir = rot;
        }
        tube.func_70296_d();
        if (world instanceof WorldServer) {
            ((WorldServer)world).func_73040_p().func_151250_a(x, y, z);
        }
        return true;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB entityBounding, List list, Entity entity) {
        ArrayList<AxisAlignedBB> bbs = new ArrayList<AxisAlignedBB>();
        double lower = 0.3125;
        double upper = 0.6875;
        bbs.add(AxisAlignedBB.func_72330_a((double)((double)x + lower), (double)((double)y + lower), (double)((double)z + lower), (double)((double)x + upper), (double)((double)y + upper), (double)((double)z + upper)));
        if (this.canConnectTo((IBlockAccess)world, x, y, z, Library.POS_X) || this.canConnectToAir((IBlockAccess)world, x, y, z, Library.POS_X)) {
            bbs.add(AxisAlignedBB.func_72330_a((double)((double)x + upper), (double)((double)y + lower), (double)((double)z + lower), (double)(x + 1), (double)((double)y + upper), (double)((double)z + upper)));
        }
        if (this.canConnectTo((IBlockAccess)world, x, y, z, Library.NEG_X) || this.canConnectToAir((IBlockAccess)world, x, y, z, Library.NEG_X)) {
            bbs.add(AxisAlignedBB.func_72330_a((double)x, (double)((double)y + lower), (double)((double)z + lower), (double)((double)x + lower), (double)((double)y + upper), (double)((double)z + upper)));
        }
        if (this.canConnectTo((IBlockAccess)world, x, y, z, Library.POS_Y) || this.canConnectToAir((IBlockAccess)world, x, y, z, Library.POS_Y)) {
            bbs.add(AxisAlignedBB.func_72330_a((double)((double)x + lower), (double)((double)y + upper), (double)((double)z + lower), (double)((double)x + upper), (double)(y + 1), (double)((double)z + upper)));
        }
        if (this.canConnectTo((IBlockAccess)world, x, y, z, Library.NEG_Y) || this.canConnectToAir((IBlockAccess)world, x, y, z, Library.NEG_Y)) {
            bbs.add(AxisAlignedBB.func_72330_a((double)((double)x + lower), (double)y, (double)((double)z + lower), (double)((double)x + upper), (double)((double)y + lower), (double)((double)z + upper)));
        }
        if (this.canConnectTo((IBlockAccess)world, x, y, z, Library.POS_Z) || this.canConnectToAir((IBlockAccess)world, x, y, z, Library.POS_Z)) {
            bbs.add(AxisAlignedBB.func_72330_a((double)((double)x + lower), (double)((double)y + lower), (double)((double)z + upper), (double)((double)x + upper), (double)((double)y + upper), (double)(z + 1)));
        }
        if (this.canConnectTo((IBlockAccess)world, x, y, z, Library.NEG_Z) || this.canConnectToAir((IBlockAccess)world, x, y, z, Library.NEG_Z)) {
            bbs.add(AxisAlignedBB.func_72330_a((double)((double)x + lower), (double)((double)y + lower), (double)z, (double)((double)x + upper), (double)((double)y + upper), (double)((double)z + lower)));
        }
        for (AxisAlignedBB bb : bbs) {
            if (!entityBounding.func_72326_a(bb)) continue;
            list.add(bb);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        boolean pZ;
        float lower = 0.3125f;
        float upper = 0.6875f;
        TileEntity te = world.func_147438_o(x, y, z);
        boolean nX = this.canConnectTo(world, x, y, z, Library.NEG_X) || this.canConnectToAir(world, x, y, z, Library.NEG_X);
        boolean pX = this.canConnectTo(world, x, y, z, Library.POS_X) || this.canConnectToAir(world, x, y, z, Library.POS_X);
        boolean nY = this.canConnectTo(world, x, y, z, Library.NEG_Y) || this.canConnectToAir(world, x, y, z, Library.NEG_Y);
        boolean pY = this.canConnectTo(world, x, y, z, Library.POS_Y) || this.canConnectToAir(world, x, y, z, Library.POS_Y);
        boolean nZ = this.canConnectTo(world, x, y, z, Library.NEG_Z) || this.canConnectToAir(world, x, y, z, Library.NEG_Z);
        boolean bl = pZ = this.canConnectTo(world, x, y, z, Library.POS_Z) || this.canConnectToAir(world, x, y, z, Library.POS_Z);
        if (te instanceof TileEntityPneumoTube) {
            TileEntityPneumoTube tube = (TileEntityPneumoTube)te;
            nX |= tube.insertionDir == Library.NEG_X || tube.ejectionDir == Library.NEG_X;
            pX |= tube.insertionDir == Library.POS_X || tube.ejectionDir == Library.POS_X;
            nY |= tube.insertionDir == Library.NEG_Y || tube.ejectionDir == Library.NEG_Y;
            pY |= tube.insertionDir == Library.POS_Y || tube.ejectionDir == Library.POS_Y;
            nZ |= tube.insertionDir == Library.NEG_Z || tube.ejectionDir == Library.NEG_Z;
            pZ |= tube.insertionDir == Library.POS_Z || tube.ejectionDir == Library.POS_Z;
        }
        this.func_149676_a(nX ? 0.0f : lower, nY ? 0.0f : lower, nZ ? 0.0f : lower, pX ? 1.0f : upper, pY ? 1.0f : upper, pZ ? 1.0f : upper);
    }

    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        TileEntity tile = world instanceof World ? Compat.getTileStandard((World)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) : world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        return tile instanceof TileEntityPneumoTube;
    }

    public boolean canConnectToAir(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        TileEntity tile;
        FluidType air = Fluids.AIR;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPneumoTube) {
            TileEntityPneumoTube tube = (TileEntityPneumoTube)te;
            if (!tube.isCompressor()) {
                return false;
            }
            if (tube.ejectionDir == dir || tube.insertionDir == dir) {
                return false;
            }
            air = tube.compair.getTankType();
        }
        if ((tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) instanceof TileEntityPneumoTube) {
            return false;
        }
        return Library.canConnectFluid(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir, air);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

