/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.conveyor.IConveyorBelt;
import api.hbm.conveyor.IConveyorItem;
import api.hbm.conveyor.IConveyorPackage;
import api.hbm.conveyor.IEnterableBlock;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CranePartitioner
extends BlockContainer
implements IConveyorBelt,
IEnterableBlock,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBack;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBelt;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInner;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInnerSide;
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();
    private final Random dropRandom = new Random();

    public CranePartitioner() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconTop = iconRegister.func_94245_a("hbm:crane_top");
        this.iconBack = iconRegister.func_94245_a("hbm:crane_partitioner_back");
        this.iconBelt = iconRegister.func_94245_a("hbm:crane_splitter_belt");
        this.iconInner = iconRegister.func_94245_a("hbm:crane_splitter_inner");
        this.iconInnerSide = iconRegister.func_94245_a("hbm:crane_splitter_inner_side");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCranePartitioner();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        return this.getTravelDirection(world, x, y, z, null) == dir;
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
        return false;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
    }

    @Override
    public boolean canItemStay(World world, int x, int y, int z, Vec3 itemPos) {
        return true;
    }

    @Override
    public Vec3 getTravelLocation(World world, int x, int y, int z, Vec3 itemPos, double speed) {
        ForgeDirection dir = this.getTravelDirection(world, x, y, z, itemPos);
        Vec3 snap = this.getClosestSnappingPosition(world, x, y, z, itemPos);
        Vec3 dest = Vec3.func_72443_a((double)(snap.field_72450_a - (double)dir.offsetX * speed), (double)(snap.field_72448_b - (double)dir.offsetY * speed), (double)(snap.field_72449_c - (double)dir.offsetZ * speed));
        Vec3 motion = Vec3.func_72443_a((double)(dest.field_72450_a - itemPos.field_72450_a), (double)(dest.field_72448_b - itemPos.field_72448_b), (double)(dest.field_72449_c - itemPos.field_72449_c));
        double len = motion.func_72433_c();
        Vec3 ret = Vec3.func_72443_a((double)(itemPos.field_72450_a + motion.field_72450_a / len * speed), (double)(itemPos.field_72448_b + motion.field_72448_b / len * speed), (double)(itemPos.field_72449_c + motion.field_72449_c / len * speed));
        return ret;
    }

    @Override
    public Vec3 getClosestSnappingPosition(World world, int x, int y, int z, Vec3 itemPos) {
        ForgeDirection dir = this.getTravelDirection(world, x, y, z, itemPos);
        itemPos.field_72450_a = MathHelper.func_151237_a((double)itemPos.field_72450_a, (double)x, (double)(x + 1));
        itemPos.field_72449_c = MathHelper.func_151237_a((double)itemPos.field_72449_c, (double)z, (double)(z + 1));
        double posX = (double)x + 0.5;
        double posZ = (double)z + 0.5;
        if (dir.offsetX != 0) {
            posX = itemPos.field_72450_a;
        }
        if (dir.offsetZ != 0) {
            posZ = itemPos.field_72449_c;
        }
        return Vec3.func_72443_a((double)posX, (double)((double)y + 0.25), (double)posZ);
    }

    public ForgeDirection getTravelDirection(World world, int x, int y, int z, Vec3 itemPos) {
        int meta = world.func_72805_g(x, y, z);
        return ForgeDirection.getOrientation((int)meta);
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        TileEntityCranePartitioner partitioner = (TileEntityCranePartitioner)world.func_147438_o(x, y, z);
        ItemStack stack = entity.getItemStack();
        ItemStack remainder = null;
        remainder = CrystallizerRecipes.getAmount(stack) > 0 ? InventoryUtil.tryAddItemToInventory((IInventory)partitioner, 0, 8, stack) : InventoryUtil.tryAddItemToInventory((IInventory)partitioner, 9, 17, stack);
        if (remainder != null) {
            EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, remainder.func_77946_l());
            world.func_72838_d((Entity)item);
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            IInventory battery = (IInventory)tile;
            for (int i = 0; i < battery.func_70302_i_(); ++i) {
                ItemStack itemstack = battery.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.dropRandom.nextFloat() * 0.8f + 0.1f;
                float f1 = this.dropRandom.nextFloat() * 0.8f + 0.1f;
                float f2 = this.dropRandom.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.dropRandom.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.dropRandom.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.dropRandom.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.dropRandom.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public static class TileEntityCranePartitioner
    extends TileEntityMachineBase {
        public static Comparator<ItemStack> stackSizeComparator = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                return (int)Math.signum(o1.field_77994_a - o2.field_77994_a);
            }
        };

        public TileEntityCranePartitioner() {
            super(18);
        }

        @Override
        public String getName() {
            return "container.partitioner";
        }

        @Override
        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < 9; ++i) {
                    if (this.slots[i] == null) continue;
                    stacks.add(this.slots[i]);
                }
                stacks.sort(stackSizeComparator);
                boolean markDirty = false;
                for (ItemStack stack : stacks) {
                    int amount = CrystallizerRecipes.getAmount(stack);
                    while (stack.field_77994_a >= amount) {
                        ItemStack entityStack = stack.func_77946_l();
                        entityStack.field_77994_a = amount;
                        stack.field_77994_a -= amount;
                        EntityMovingItem item = new EntityMovingItem(this.field_145850_b);
                        item.setItemStack(entityStack);
                        item.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.25, (double)this.field_145849_e + 0.5);
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                }
                for (int i = 0; i < 9; ++i) {
                    if (this.slots[i] == null || this.slots[i].field_77994_a > 0) continue;
                    this.slots[i] = null;
                }
                if (markDirty) {
                    this.func_70296_d();
                }
            }
        }

        @Override
        public boolean func_102008_b(int slot, ItemStack stack, int side) {
            return slot >= 9;
        }

        @Override
        public boolean func_94041_b(int i, ItemStack stack) {
            return i <= 8 && CrystallizerRecipes.getAmount(stack) >= 1;
        }

        @Override
        public int[] func_94128_d(int side) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
        }
    }
}

