/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.repack.com.unascribed.ears.common.render;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import pl.asie.foamfix.repack.com.unascribed.ears.api.features.EarsFeatures;
import pl.asie.foamfix.repack.com.unascribed.ears.common.EarsCommon;
import pl.asie.foamfix.repack.com.unascribed.ears.common.debug.EarsLog;
import pl.asie.foamfix.repack.com.unascribed.ears.common.render.EarsRenderDelegate;
import pl.asie.foamfix.repack.com.unascribed.ears.common.util.Decider;

public abstract class AbstractEarsRenderDelegate<TPeer, TModelPart>
implements EarsRenderDelegate {
    protected TPeer peer;
    protected EarsFeatures feat;
    protected int skipRendering;
    protected int stackDepth;
    protected EarsRenderDelegate.BodyPart permittedBodyPart;
    protected EarsRenderDelegate.TexSource bound;
    protected boolean emissive;

    protected abstract EarsFeatures getEarsFeatures();

    @Override
    public void setUp() {
        this.skipRendering = 0;
        this.stackDepth = 0;
        this.bound = EarsRenderDelegate.TexSource.SKIN;
        this.doBindSkin();
        this.setUpRenderState();
    }

    public TPeer getPeer() {
        return this.peer;
    }

    protected abstract void setUpRenderState();

    @Override
    public void tearDown() {
        this.tearDownRenderState();
        this.peer = null;
    }

    protected abstract void tearDownRenderState();

    @Override
    public void push() {
        ++this.stackDepth;
        this.pushMatrix();
        if (this.skipRendering > 0) {
            ++this.skipRendering;
        }
    }

    protected abstract void pushMatrix();

    @Override
    public void pop() {
        if (this.stackDepth <= 0) {
            new Exception("STACK UNDERFLOW").printStackTrace();
            return;
        }
        --this.stackDepth;
        this.popMatrix();
        if (this.skipRendering > 0) {
            --this.skipRendering;
        }
    }

    protected abstract void popMatrix();

    @Override
    public void anchorTo(EarsRenderDelegate.BodyPart part) {
        if (this.permittedBodyPart != null && part != this.permittedBodyPart) {
            EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER_DELEGATE, "anchorTo(...): Part is not permissible in this pass, skip rendering until pop");
            if (this.skipRendering == 0) {
                this.skipRendering = 1;
            }
            return;
        }
        TModelPart modelPart = this.decideModelPart(Decider.begin(part)).orElse(null);
        if (modelPart == null || !this.isVisible(modelPart)) {
            EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER_DELEGATE, "anchorTo(...): Part is not {}, skip rendering until pop", modelPart == null ? "valid" : "visible");
            if (this.skipRendering == 0) {
                this.skipRendering = 1;
            }
            return;
        }
        this.doAnchorTo(part, modelPart);
    }

    protected abstract boolean isVisible(TModelPart var1);

    protected abstract Decider<EarsRenderDelegate.BodyPart, TModelPart> decideModelPart(Decider<EarsRenderDelegate.BodyPart, TModelPart> var1);

    protected abstract void doAnchorTo(EarsRenderDelegate.BodyPart var1, TModelPart var2);

    @Override
    public void translate(float x, float y, float z) {
        if (this.skipRendering > 0) {
            return;
        }
        this.doTranslate(x, y, z);
    }

    protected abstract void doTranslate(float var1, float var2, float var3);

    @Override
    public void rotate(float ang, float x, float y, float z) {
        if (this.skipRendering > 0) {
            return;
        }
        this.doRotate(ang, x, y, z);
    }

    protected abstract void doRotate(float var1, float var2, float var3, float var4);

    @Override
    public void scale(float x, float y, float z) {
        if (this.skipRendering > 0) {
            return;
        }
        this.doScale(x, y, z);
    }

    protected abstract void doScale(float var1, float var2, float var3);

    @Override
    public void renderFront(int u, int v, int w, int h, EarsRenderDelegate.TexRotation rot, EarsRenderDelegate.TexFlip flip, EarsRenderDelegate.QuadGrow grow) {
        if (this.skipRendering > 0) {
            return;
        }
        float[][] uv = EarsCommon.calculateUVs(u, v, w, h, rot, flip, this.bound);
        float g = grow.grow;
        float b = this.emissive ? 1.0f : this.getBrightness();
        float nX = 0.0f;
        float nY = this.emissive ? 1.0f : 0.0f;
        float nZ = this.emissive ? 0.0f : -1.0f;
        this.beginQuad();
        this.addVertex(-g, (float)h + g, 0, b, b, b, 1.0f, uv[0][0], uv[0][1], nX, nY, nZ);
        this.addVertex((float)w + g, (float)h + g, 0, b, b, b, 1.0f, uv[1][0], uv[1][1], nX, nY, nZ);
        this.addVertex((float)w + g, -g, 0, b, b, b, 1.0f, uv[2][0], uv[2][1], nX, nY, nZ);
        this.addVertex(-g, -g, 0, b, b, b, 1.0f, uv[3][0], uv[3][1], nX, nY, nZ);
        this.drawQuad();
    }

    @Override
    public void renderBack(int u, int v, int w, int h, EarsRenderDelegate.TexRotation rot, EarsRenderDelegate.TexFlip flip, EarsRenderDelegate.QuadGrow grow) {
        if (this.skipRendering > 0) {
            return;
        }
        float[][] uv = EarsCommon.calculateUVs(u, v, w, h, rot, flip.flipHorizontally(), this.bound);
        float g = grow.grow;
        float b = this.emissive ? 1.0f : this.getBrightness();
        float nX = 0.0f;
        float nY = this.emissive ? 1.0f : 0.0f;
        float nZ = this.emissive ? 0.0f : 1.0f;
        this.beginQuad();
        this.addVertex(-g, -g, 0, b, b, b, 1.0f, uv[3][0], uv[3][1], nX, nY, nZ);
        this.addVertex((float)w + g, -g, 0, b, b, b, 1.0f, uv[2][0], uv[2][1], nX, nY, nZ);
        this.addVertex((float)w + g, (float)h + g, 0, b, b, b, 1.0f, uv[1][0], uv[1][1], nX, nY, nZ);
        this.addVertex(-g, (float)h + g, 0, b, b, b, 1.0f, uv[0][0], uv[0][1], nX, nY, nZ);
        this.drawQuad();
    }

    protected abstract void beginQuad();

    protected abstract void addVertex(float var1, float var2, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12);

    protected abstract void drawQuad();

    protected float getBrightness() {
        return 1.0f;
    }

    @Override
    public void renderDoubleSided(int u, int v, int width, int height, EarsRenderDelegate.TexRotation rot, EarsRenderDelegate.TexFlip flip, EarsRenderDelegate.QuadGrow grow) {
        this.renderFront(u, v, width, height, rot, flip, grow);
        this.renderBack(u, v, width, height, rot, flip.flipHorizontally(), grow);
    }

    @Override
    public void renderDebugDot(float r, float g, float b, float a) {
        if (this.skipRendering > 0) {
            return;
        }
        this.doRenderDebugDot(r, g, b, a);
    }

    protected abstract void doRenderDebugDot(float var1, float var2, float var3, float var4);

    @Override
    public void bind(EarsRenderDelegate.TexSource src) {
        if (src == this.bound) {
            return;
        }
        if (src == EarsRenderDelegate.TexSource.SKIN) {
            this.doBindSkin();
        } else if (!src.isBuiltIn()) {
            this.doBindAux(src, src.getPNGData(this.feat));
        } else if (this.canBind(src)) {
            this.doBindBuiltin(src);
        } else {
            EarsLog.debug(EarsLog.Tag.COMMON_RENDERER, "Attempt to bind unsupported texture {}", (Object)src);
        }
        this.bound = src;
    }

    protected abstract void doBindSkin();

    protected abstract void doBindAux(EarsRenderDelegate.TexSource var1, byte[] var2);

    protected void doBindBuiltin(EarsRenderDelegate.TexSource src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canBind(EarsRenderDelegate.TexSource tex) {
        return tex == EarsRenderDelegate.TexSource.SKIN || !tex.isBuiltIn();
    }

    public static ByteBuffer toNativeBuffer(byte[] arr) {
        ByteBuffer buf = ByteBuffer.allocateDirect(arr.length).order(ByteOrder.nativeOrder());
        ((Buffer)buf.put(arr)).flip();
        return buf;
    }

    @Override
    public boolean needsSecondaryLayersDrawn() {
        return false;
    }

    @Override
    public void setEmissive(boolean emissive) {
        this.emissive = emissive;
    }
}

