/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModulePlantGrowth
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.block.BlockCrops", "net.minecraft.block.BlockReed", "net.minecraft.block.BlockCactus", "net.minecraft.block.BlockCocoa", "net.minecraft.block.BlockMushroom", "net.minecraft.block.BlockNetherWart", "net.minecraft.block.BlockSapling", "net.minecraft.block.BlockStem", "com.pam.harvestcraft.BlockPamFruit", "com.pam.harvestcraft.BlockPamSapling", "mods.natura.blocks.crops.BerryBush", "mods.natura.blocks.crops.NetherBerryBush", "mods.natura.blocks.crops.CropBlock", "mods.natura.blocks.crops.Glowshroom"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_149674_a", "updateTick", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V");
        if (methodNode == null) {
            methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_149674_a", "(Lnet/minecraft/world/World;IIILjava/util/Random;)V");
        }
        if (methodNode == null) {
            throw new RuntimeException(classNode.name + ": updateTick method not found");
        }
        if (transformedName.equals("net.minecraft.block.BlockCrops")) {
            this.hookBlockCrops(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockReed")) {
            this.hookBlockReed(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockCactus")) {
            this.hookBlockCactus(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockCocoa")) {
            this.hookBlockCocoa(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockMushroom")) {
            this.hookBlockMushroom(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockNetherWart")) {
            this.hookBlockNetherWart(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockSapling")) {
            this.hookBlockSapling(classNode, methodNode);
        } else if (transformedName.equals("net.minecraft.block.BlockStem")) {
            this.hookBlockStem(classNode, methodNode);
        } else if (transformedName.equals("com.pam.harvestcraft.BlockPamFruit")) {
            this.hookBlockPamFruit(classNode, methodNode);
        } else if (transformedName.equals("com.pam.harvestcraft.BlockPamSapling")) {
            this.hookBlockPamSapling(classNode, methodNode);
        } else if (transformedName.equals("mods.natura.blocks.crops.BerryBush") || transformedName.equals("mods.natura.blocks.crops.NetherBerryBush")) {
            this.hookBlockNaturaBerryBush(classNode, methodNode);
        } else if (transformedName.equals("mods.natura.blocks.crops.CropBlock")) {
            this.hookNaturaCropBlock(classNode, methodNode);
        } else if (transformedName.equals("mods.natura.blocks.crops.Glowshroom")) {
            this.hookBlockMushroom(classNode, methodNode);
        } else {
            throw new RuntimeException("Unexpected class passed to transformer : " + transformedName);
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    private void hookBlockCrops(ClassNode classNode, MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.findNextInstruction(ASMHelper.findFirstInstructionWithOpcode(method, 183));
        if (ifStartPoint == null) {
            throw new RuntimeException("Failed to transform BlockCrops, INVOKESPECIAL instruction not found");
        }
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, endLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber(ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 18)).getNext();
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode(ifStartPoint, 154);
        ifFailedLabel = ifJumpInsn.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = this.storeMetadataInNewVariable(method, metadataVar);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockReed(ClassNode classNode, MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 162);
        LabelNode ifDeniedLabel = ifJumpInsn.label;
        this.injectNotDeniedCheckBefore(method, ifJumpInsn.getNext(), ifDeniedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = metadataVar.index;
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifDeniedLabel, (AbstractInsnNode)newGotoLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifDeniedLabel, previousMetadataIndex);
    }

    private void hookBlockCactus(ClassNode classNode, MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 162);
        LabelNode ifDeniedLabel = ifJumpInsn.label;
        this.injectNotDeniedCheckBefore(method, ifJumpInsn.getNext(), ifDeniedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = metadataVar.index;
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifDeniedLabel, (AbstractInsnNode)newGotoLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifDeniedLabel, previousMetadataIndex);
    }

    private void hookBlockCocoa(ClassNode classNode, MethodNode method) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = metadataVar.index;
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockMushroom(ClassNode classNode, MethodNode method) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthWithoutMetadataChangeEventBefore(method, (AbstractInsnNode)ifFailedLabel);
    }

    private void hookBlockNetherWart(ClassNode classNode, MethodNode method) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 162).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = this.storeMetadataInNewVariable(method, metadataVar);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockSapling(ClassNode classNode, MethodNode method) {
        JumpInsnNode lightValueIf = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        JumpInsnNode randomIf = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)lightValueIf, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findNextInstruction(ASMHelper.findFirstInstructionWithOpcode(method, 183));
        if (ifStartPoint == null) {
            throw new RuntimeException("Failed to transform BlockSapling, INVOKESPECIAL instruction not found");
        }
        LabelNode ifFailedLabel = lightValueIf.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)randomIf, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        int previousMetadataIndex = this.getMetadataAndStoreInNewVariableBefore(method, ifAllowedLabel.getNext(), ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockStem(ClassNode classNode, MethodNode method) {
        JumpInsnNode lightValueIf = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.getOrFindInstructionOfType((AbstractInsnNode)lightValueIf, 15, true).getNext();
        LabelNode ifFailedLabel = lightValueIf.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)lightValueIf, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ASMHelper.findEndLabel(method));
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        JumpInsnNode randomIf = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)lightValueIf, 154);
        ifStartPoint = ASMHelper.getOrFindInstructionOfType((AbstractInsnNode)randomIf, 15, true).getNext();
        ifFailedLabel = randomIf.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)randomIf, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = this.storeMetadataInNewVariable(method, metadataVar);
        LabelNode newGotoLabel = new LabelNode();
        JumpInsnNode gotoInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)randomIf, 167);
        gotoInsn.label = newGotoLabel;
        method.instructions.insertBefore((AbstractInsnNode)ifFailedLabel, (AbstractInsnNode)newGotoLabel);
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockPamFruit(ClassNode classNode, MethodNode method) {
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ASMHelper.findFirstInstruction(method), ASMHelper.findEndLabel(method));
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = this.storeMetadataInNewVariable(method, metadataVar);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockPamSapling(ClassNode classNode, MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findLastInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        int previousMetadataIndex = this.getMetadataAndStoreInNewVariableBefore(method, ifAllowedLabel.getNext(), ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookBlockNaturaBerryBush(ClassNode classNode, MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 154);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        if (!classNode.name.endsWith("NetherBerryBush")) {
            ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 161);
        }
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, ifFailedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = metadataVar.index;
        this.fixPrecedingIfsToNotSkipInjectedInstructions(method, ifFailedLabel);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private void hookNaturaCropBlock(ClassNode classNode, MethodNode method) {
        JumpInsnNode ifJumpInsn = (JumpInsnNode)ASMHelper.findFirstInstructionWithOpcode(method, 161);
        AbstractInsnNode ifStartPoint = ASMHelper.findPreviousLabelOrLineNumber((AbstractInsnNode)ifJumpInsn).getNext();
        LabelNode endLabel = ASMHelper.findEndLabel(method);
        LabelNode ifFailedLabel = ifJumpInsn.label;
        LabelNode ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        int resultIndex = this.fireAllowGrowthEventAndStoreResultBefore(method, ifStartPoint, endLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        ifStartPoint = ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)ifJumpInsn, 18).getPrevious();
        ifJumpInsn = (JumpInsnNode)ASMHelper.findNextInstructionWithOpcode(ifStartPoint, 154);
        ifFailedLabel = ifJumpInsn.label;
        ifAllowedLabel = new LabelNode();
        method.instructions.insert((AbstractInsnNode)ifJumpInsn, (AbstractInsnNode)ifAllowedLabel);
        this.injectAllowedOrDefaultCheckBefore(method, ifStartPoint, resultIndex, ifAllowedLabel, ifFailedLabel);
        LocalVariableNode metadataVar = this.findStoredMetadataLocalVariable(method);
        int previousMetadataIndex = this.storeMetadataInNewVariable(method, metadataVar);
        this.injectOnGrowthEventBefore(method, (AbstractInsnNode)ifFailedLabel, previousMetadataIndex);
    }

    private LocalVariableNode findStoredMetadataLocalVariable(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        needle.add((AbstractInsnNode)new VarInsnNode(21, 2));
        needle.add((AbstractInsnNode)new VarInsnNode(21, 3));
        needle.add((AbstractInsnNode)new VarInsnNode(21, 4));
        String getBlockMetadataName = ObfHelper.isObfuscated() ? "func_72805_g" : "getBlockMetadata";
        needle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.world.World"), getBlockMetadataName, "(III)I", false));
        needle.add((AbstractInsnNode)new VarInsnNode(54, -1));
        InsnList foundInsns = ASMHelper.findAndGetFoundInsnList(method.instructions.getFirst(), needle);
        if (foundInsns.getFirst() == null) {
            throw new RuntimeException("Could not find pattern:\n" + ASMHelper.getInsnListAsString(needle) + "\nin method instructions:\n" + ASMHelper.getInsnListAsString(method.instructions));
        }
        VarInsnNode insnISTORE = (VarInsnNode)foundInsns.getLast();
        for (LocalVariableNode localVar : method.localVariables) {
            if (localVar.index != insnISTORE.var) continue;
            return localVar;
        }
        return null;
    }

    private int storeMetadataInNewVariable(MethodNode method, LocalVariableNode metadataVar) {
        LabelNode previousMetadataStart = new LabelNode();
        LocalVariableNode previousMetadata = new LocalVariableNode("previousMetadata", "I", null, previousMetadataStart, metadataVar.end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(previousMetadata);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(21, metadataVar.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, previousMetadata.index));
        toInject.add((AbstractInsnNode)previousMetadataStart);
        method.instructions.insert((AbstractInsnNode)metadataVar.start, toInject);
        return previousMetadata.index;
    }

    private int getMetadataAndStoreInNewVariableBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode endLabel) {
        LabelNode previousMetadataStart = new LabelNode();
        LocalVariableNode previousMetadata = new LocalVariableNode("previousMetadata", "I", null, previousMetadataStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(previousMetadata);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.world.World"), ObfHelper.isObfuscated() ? "func_72805_g" : "getBlockMetadata", "(III)I", false));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, previousMetadata.index));
        toInject.add((AbstractInsnNode)previousMetadataStart);
        method.instructions.insertBefore(injectPoint, toInject);
        return previousMetadata.index;
    }

    private int fireAllowGrowthEventAndStoreResultBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode endLabel) {
        LabelNode allowGrowthResultStart = new LabelNode();
        LocalVariableNode allowGrowthResult = new LocalVariableNode("allowGrowthResult", "Lcpw/mods/fml/common/eventhandler/Event$Result;", null, allowGrowthResultStart, endLabel, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(allowGrowthResult);
        InsnList toInject = new InsnList();
        this.addFireGrowthEventInsnsToList(toInject);
        toInject.add((AbstractInsnNode)new VarInsnNode(58, allowGrowthResult.index));
        toInject.add((AbstractInsnNode)allowGrowthResultStart);
        method.instructions.insertBefore(injectPoint, toInject);
        return allowGrowthResult.index;
    }

    private void addFireGrowthEventInsnsToList(InsnList insnList) {
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 2));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 3));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 4));
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 5));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "fireAllowPlantGrowthEvent", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;IIILjava/util/Random;)Lcpw/mods/fml/common/eventhandler/Event$Result;", false));
    }

    private void injectAllowedOrDefaultCheckBefore(MethodNode method, AbstractInsnNode injectPoint, int resultIndex, LabelNode ifAllowedLabel, LabelNode ifFailedLabel) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, resultIndex));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, "cpw/mods/fml/common/eventhandler/Event$Result", "ALLOW", "Lcpw/mods/fml/common/eventhandler/Event$Result;"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifAllowedLabel));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, resultIndex));
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, "cpw/mods/fml/common/eventhandler/Event$Result", "DEFAULT", "Lcpw/mods/fml/common/eventhandler/Event$Result;"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(166, ifFailedLabel));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectNotDeniedCheckBefore(MethodNode method, AbstractInsnNode injectPoint, LabelNode ifDeniedLabel) {
        InsnList toInject = new InsnList();
        this.addFireGrowthEventInsnsToList(toInject);
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, "cpw/mods/fml/common/eventhandler/Event$Result", "DENY", "Lcpw/mods/fml/common/eventhandler/Event$Result;"));
        toInject.add((AbstractInsnNode)new JumpInsnNode(165, ifDeniedLabel));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectOnGrowthEventBefore(MethodNode method, AbstractInsnNode injectPoint, int previousMetadataVarIndex) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, previousMetadataVarIndex));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "fireOnGrowthEvent", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;IIII)V", false));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void injectOnGrowthWithoutMetadataChangeEventBefore(MethodNode method, AbstractInsnNode injectPoint) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 4));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "fireOnGrowthWithoutMetadataChangeEvent", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;III)V", false));
        method.instructions.insertBefore(injectPoint, toInject);
    }

    private void fixPrecedingIfsToNotSkipInjectedInstructions(MethodNode method, LabelNode labelJumpedTo) {
        LabelNode beforeOnGrowthEvent = new LabelNode();
        method.instructions.insertBefore((AbstractInsnNode)labelJumpedTo, (AbstractInsnNode)beforeOnGrowthEvent);
        for (AbstractInsnNode curInsn = labelJumpedTo.getPrevious(); curInsn != null; curInsn = curInsn.getPrevious()) {
            boolean isJump = curInsn instanceof JumpInsnNode;
            if (isJump && ((JumpInsnNode)curInsn).label == labelJumpedTo) {
                ((JumpInsnNode)curInsn).label = beforeOnGrowthEvent;
                continue;
            }
            if (isJump) break;
        }
    }
}

