/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.RecipeSearchField;
import codechicken.nei.RestartableTask;
import codechicken.nei.SearchField;
import codechicken.nei.VisiblityData;
import codechicken.nei.Widget;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.filter.AllMultiRecipeFilter;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.recipe.AcceptsFollowingTooltipLineHandler;
import codechicken.nei.recipe.ContainerRecipe;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipeCatalyst;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.GuiRecipeTabs;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.NEIRecipeWidget;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.SearchRecipeHandler;
import codechicken.nei.scroll.ScrollBar;
import codechicken.nei.scroll.ScrollContainer;
import codechicken.nei.util.SlotInaccessible;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipe<H extends IRecipeHandler>
extends GuiContainer
implements IGuiContainerOverlay,
IGuiClientSide,
IGuiHandleMouseWheel,
IContainerTooltipHandler,
INEIGuiHandler {
    private static final int BORDER_PADDING = 5;
    private final DrawableResource BG_TEXTURE = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 0, 176, 166).build();
    private static final int BUTTON_WIDTH = 13;
    private static final int BUTTON_HEIGHT = 12;
    protected static final ScrollBar VERTICAL_SCROLLBAR = new ScrollBar().setScrollbarSize(14).setMarginStart(-6).setOverflowType(ScrollBar.OverflowType.AUTO).setScrollPlace(ScrollBar.ScrollPlace.END).setTrackTexture(new DrawableBuilder("nei:textures/nei_sprites.png", 42, 90, 13, 21).build(), 9, 9).setThumbTexture(new DrawableBuilder("nei:textures/nei_sprites.png", 21, 96, 8, 9).build(), 3, 2).setThumbPadding(6);
    public static final List<IRecipeFilter.IRecipeFilterProvider> recipeFilterers = new LinkedList<IRecipeFilter.IRecipeFilterProvider>();
    protected AcceptsFollowingTooltipLineHandler acceptsFollowingTooltipLineHandler;
    public ArrayList<H> currenthandlers = new ArrayList();
    public int page;
    public int recipetype;
    private Recipe.RecipeId recipeId;
    public GuiContainer firstGui;
    public GuiScreen firstGuiGeneral;
    public GuiScreen prevGui;
    private GuiButton nextpage;
    private GuiButton prevpage;
    private GuiButton prevtype;
    private GuiButton nexttype;
    protected String recipePageCacheKey = "";
    private final GuiRecipeTabs recipeTabs;
    private final GuiRecipeCatalyst recipeCatalyst;
    private SearchRecipeHandler<H> handler;
    private HandlerInfo handlerInfo;
    protected static final RestartableTask updateFilter = new RestartableTask("NEI Recipe Filtering"){

        @Override
        public void execute() {
            GuiRecipe guiRecipe;
            SearchRecipeHandler searchHandler;
            GuiScreen currentScreen = NEIClientUtils.mc().field_71462_r;
            if (currentScreen instanceof GuiRecipe && (searchHandler = (guiRecipe = (GuiRecipe)currentScreen).handler) != null && searchHandler.searchingAvailable()) {
                if (searchField.text().isEmpty()) {
                    searchHandler.setSearchIndices(null);
                    guiRecipe.changePage(0);
                } else {
                    IRecipeFilter filter = searchField.getRecipeFilter();
                    List<Integer> filtered = searchHandler.getSearchResult(filter);
                    if (filtered == null) {
                        this.stop();
                    }
                    if (this.interrupted()) {
                        return;
                    }
                    searchHandler.setSearchIndices(filtered);
                    guiRecipe.changePage(0);
                }
                guiRecipe.recipePageCacheKey = "";
            }
        }
    };
    protected static final RecipeSearchField searchField = new RecipeSearchField(""){

        @Override
        protected boolean noResults() {
            GuiScreen currentScreen = NEIClientUtils.mc().field_71462_r;
            return !(currentScreen instanceof GuiRecipe) || ((GuiRecipe)currentScreen).numRecipes() > 0;
        }

        @Override
        public void onTextChange(String oldText) {
            updateFilter.restart();
        }
    };
    protected static final Button toggleSearch = new Button(){

        @Override
        public boolean onButtonPress(boolean rightclick) {
            if (rightclick) {
                return false;
            }
            if (searchField.isVisible()) {
                searchField.setText("");
                searchField.setFocus(false);
                searchField.setVisible(false);
                this.state = 0;
            } else {
                searchField.setVisible(true);
                searchField.setFocus(true);
                this.state = 2;
            }
            return true;
        }
    };
    private boolean isHeightHackApplied = false;
    private ScrollContainer container = new ScrollContainer();
    @Deprecated
    private GuiOverlayButton[] overlayButtons = new GuiOverlayButton[0];
    @Deprecated
    public ContainerRecipe slotcontainer;

    protected GuiRecipe(GuiScreen prevgui) {
        super((Container)new ContainerRecipe());
        this.recipeTabs = new GuiRecipeTabs(){

            @Override
            protected void setRecipePage(int recipetype) {
                GuiRecipe.this.setRecipePage(recipetype);
            }
        };
        this.recipeCatalyst = new GuiRecipeCatalyst();
        this.slotcontainer = (ContainerRecipe)this.field_147002_h;
        this.prevGui = prevgui;
        this.firstGuiGeneral = prevgui;
        if (prevgui instanceof GuiContainer) {
            GuiContainer firstGui;
            this.firstGui = firstGui = (GuiContainer)prevgui;
        }
        if (prevgui instanceof IGuiContainerOverlay) {
            IGuiContainerOverlay gui = (IGuiContainerOverlay)prevgui;
            this.firstGui = gui.getFirstScreen();
            this.firstGuiGeneral = gui.getFirstScreenGeneral();
        }
    }

    public void func_73866_w_() {
        int tabHeight = GuiRecipeTabs.getTabHeight();
        this.field_146999_f = 176;
        this.field_147000_g = Math.min(this.field_146295_m - 22 - 22 - tabHeight, NEIClientConfig.getIntSetting("inventory.guirecipe.maxHeight"));
        super.func_73866_w_();
        this.field_147009_r = Math.max(19 + tabHeight, (this.field_146295_m - this.field_147000_g) / 2);
        if (this.handler == null) {
            this.setRecipePage(this.recipetype);
        }
        int rightButtonX = this.field_147003_i + this.field_146999_f - 5 - 13 + 1;
        int leftButtonX = this.field_147003_i + 5;
        this.prevtype = new GuiNEIButton(0, leftButtonX, this.field_147009_r + 3, 13, 12, "<"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.prevType();
            }
        };
        this.nexttype = new GuiNEIButton(1, rightButtonX, this.field_147009_r + 3, 13, 12, ">"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.nextType();
            }
        };
        this.prevpage = new GuiNEIButton(2, leftButtonX, this.field_147009_r + 17, 13, 12, "<"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.prevPage();
            }
        };
        this.nextpage = new GuiNEIButton(3, rightButtonX, this.field_147009_r + 17, 13, 12, ">"){

            public void func_146118_a(int mouseX, int mouseY) {
                GuiRecipe.this.nextPage();
            }
        };
        this.container.x = this.field_147003_i + 3;
        this.container.y = this.field_147009_r + 32;
        this.container.h = this.field_147000_g - 32 - 5;
        GuiRecipe.toggleSearch.icon = new DrawableBuilder("nei:textures/nei_sprites.png", 0, 76, 10, 10).build();
        GuiRecipe.toggleSearch.h = 12;
        GuiRecipe.toggleSearch.w = 12;
        GuiRecipe.toggleSearch.x = this.field_147003_i + 5 + 13;
        GuiRecipe.toggleSearch.y = this.field_147009_r + 17;
        GuiRecipe.searchField.y = this.field_147009_r + 16;
        GuiRecipe.searchField.x = this.field_147003_i + 5 + 13 + GuiRecipe.toggleSearch.w;
        GuiRecipe.searchField.w = this.field_146999_f - 36 + 1 - GuiRecipe.toggleSearch.w - 45;
        GuiRecipe.searchField.h = 14;
        this.field_146292_n.addAll(Arrays.asList(this.prevtype, this.nexttype, this.prevpage, this.nextpage));
        this.recipePageCacheKey = "";
        if (this.currenthandlers.size() == 1) {
            this.prevtype.field_146125_m = false;
            this.nexttype.field_146125_m = false;
        }
        this.recipeTabs.update(this);
    }

    private void updateRecipePage() {
        String cacheKey;
        List<Integer> indices = this.getRecipeIndices();
        String string = cacheKey = indices.isEmpty() ? "empty" : this.handlerInfo.getHandlerName() + ":" + indices.get(0) + ":" + indices.get(indices.size() - 1);
        if (!cacheKey.equals(this.recipePageCacheKey)) {
            this.recipePageCacheKey = cacheKey;
            boolean expandVertically = this.handlerInfo.expandVertically();
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            int shiftY = 0;
            for (int recipeIndex : indices) {
                NEIRecipeWidget widget = RecipeHandlerRef.of(this.handler.original, recipeIndex).getRecipeWidget();
                widget.setLocation(Math.max(0, (this.container.w - widget.w) / 2), shiftY);
                if (expandVertically) {
                    widget.h = Math.min(this.handlerInfo.getHeight() + this.handlerInfo.getYShift(), this.container.getVisibleHeight());
                }
                widgets.add(widget);
                shiftY += widget.h;
            }
            this.container.setWidgets(widgets);
            if (this.handlerInfo.getUseCustomScroll()) {
                this.container.setVerticalScroll(null);
            } else if (this.container.w == this.field_146999_f - 6) {
                this.container.setVerticalScroll(VERTICAL_SCROLLBAR);
            } else {
                this.container.setVerticalScroll(ScrollBar.defaultVerticalBar().setOverflowType(ScrollBar.OverflowType.OVERLAY).setScrollPlace(ScrollBar.ScrollPlace.END));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRecipeFilter getRecipeListFilter() {
        if (recipeFilterers.isEmpty()) {
            return null;
        }
        AllMultiRecipeFilter recipeFilter = new AllMultiRecipeFilter();
        List<IRecipeFilter.IRecipeFilterProvider> list = recipeFilterers;
        synchronized (list) {
            for (IRecipeFilter.IRecipeFilterProvider p : recipeFilterers) {
                IRecipeFilter filter = p.getRecipeFilter();
                if (filter == null) continue;
                recipeFilter.filters.add(filter);
            }
        }
        return recipeFilter.filters.size() == 1 ? recipeFilter.filters.get(0) : recipeFilter;
    }

    public static ItemFilter getSearchItemFilter() {
        return searchField.getFilter();
    }

    public void setRecipePage(int idx) {
        this.setRecipePage(idx, 0);
    }

    public void setRecipePage(int idx, int refIndex) {
        this.recipetype = (this.currenthandlers.size() + idx) % this.currenthandlers.size();
        this.handler = new SearchRecipeHandler<IRecipeHandler>((IRecipeHandler)this.currenthandlers.get(this.recipetype));
        this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handler.original);
        searchField.setText("");
        searchField.setVisible(false);
        GuiRecipe.toggleSearch.state = 0;
        this.container.setVerticalScrollOffset(0);
        this.page = Math.min(Math.max(0, refIndex), this.numRecipes() - 1) / this.getRecipesPerPage();
        this.changePage(0);
        this.recipeTabs.update(this);
    }

    public int openTargetRecipe(Recipe.RecipeId recipeId) {
        int refIndex = -1;
        int recipetype = 0;
        this.recipeId = recipeId;
        if (this.recipeId != null) {
            for (int j = 0; j < this.currenthandlers.size(); ++j) {
                IRecipeHandler localHandler = (IRecipeHandler)this.currenthandlers.get(j);
                HandlerInfo localHandlerInfo = GuiRecipeTab.getHandlerInfo(localHandler);
                if (!localHandlerInfo.getHandlerName().equals(this.recipeId.getHandleName())) continue;
                recipetype = j;
                if (this.recipeId.getIngredients().isEmpty()) break;
                refIndex = SearchRecipeHandler.findFirst(localHandler, recipeIndex -> this.recipeId.equalsIngredients(localHandler.getIngredientStacks(recipeIndex)));
                break;
            }
        }
        this.setRecipePage(recipetype, Math.max(0, refIndex));
        return refIndex;
    }

    public Recipe getFocusedRecipe() {
        NEIRecipeWidget recipeWidget;
        Point mouse = GuiDraw.getMousePosition();
        Widget activeWidget = this.container.getWidgetUnderMouse(mouse.x, mouse.y);
        if (activeWidget instanceof NEIRecipeWidget && (recipeWidget = (NEIRecipeWidget)activeWidget).isFocusedRecipe(mouse.x, mouse.y)) {
            return recipeWidget.getRecipe();
        }
        return null;
    }

    public boolean isMouseOver(PositionedStack stack, int refIndex) {
        NEIRecipeWidget recipeWidget;
        PositionedStack hovered;
        Point mouse = GuiDraw.getMousePosition();
        Widget activeWidget = this.container.getWidgetUnderMouse(mouse.x, mouse.y);
        if (activeWidget instanceof NEIRecipeWidget && (hovered = (recipeWidget = (NEIRecipeWidget)activeWidget).getPositionedStackMouseOver(mouse.x, mouse.y)) != null) {
            return stack.relx == hovered.relx && stack.rely == hovered.rely;
        }
        return false;
    }

    public Slot func_146975_c(int mousex, int mousey) {
        NEIRecipeWidget recipeWidget;
        PositionedStack hovered;
        Widget activeWidget = this.container.getWidgetUnderMouse(mousex, mousey);
        ContainerRecipe slotcontainer = (ContainerRecipe)this.field_147002_h;
        slotcontainer.setActiveStack(null);
        if (activeWidget instanceof NEIRecipeWidget && (hovered = (recipeWidget = (NEIRecipeWidget)activeWidget).getPositionedStackMouseOver(mousex, mousey)) != null) {
            slotcontainer.setActiveStack(hovered.item);
            return new SlotInaccessible(hovered.item, hovered.relx, hovered.rely);
        }
        PositionedStack activeStack = this.recipeCatalyst.getPositionedStackMouseOver(mousex, mousey);
        if (activeStack != null) {
            slotcontainer.setActiveStack(activeStack.item);
            return new SlotInaccessible(activeStack.item, activeStack.relx, activeStack.rely);
        }
        return null;
    }

    public String getHandlerName() {
        return this.handlerInfo.getHandlerName();
    }

    public H getHandler() {
        return this.handler.original;
    }

    public List<Integer> getRecipeIndices() {
        int recipesPerPage = this.getRecipesPerPage();
        int minIndex = this.page * recipesPerPage;
        int maxIndex = Math.min(this.numRecipes(), (this.page + 1) * recipesPerPage);
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int index = minIndex; index < maxIndex; ++index) {
            range.add(this.handler.ref(index));
        }
        return range;
    }

    private int numRecipes() {
        return this.handler == null ? 0 : this.handler.numRecipes();
    }

    public void func_73869_a(char c, int i) {
        if (searchField.isVisible() && searchField.focused() && searchField.handleKeyPress(i, c)) {
            return;
        }
        if (i == 1) {
            this.field_146297_k.func_147108_a(this.getFirstScreenGeneral());
            NEICPH.sendRequestContainer();
            return;
        }
        if (searchField.isVisible() && searchField.focused()) {
            searchField.lastKeyTyped(i, c);
            return;
        }
        if (this.recipeCatalyst.isShowWidget()) {
            if (this.recipeCatalyst.handleKeyPress(i, c)) {
                return;
            }
            this.recipeCatalyst.lastKeyTyped(i, c);
        }
        if (this.container.handleKeyPress(i, c)) {
            return;
        }
        this.container.lastKeyTyped(i, c);
        if (GuiContainerManager.getManager(this).lastKeyTyped(i, c)) {
            return;
        }
        if (i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(this.getFirstScreenGeneral());
            NEICPH.sendRequestContainer();
        } else if (NEIClientConfig.isKeyHashDown("gui.back")) {
            this.field_146297_k.func_147108_a(this.prevGui);
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_machine")) {
            this.prevType();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_machine")) {
            this.nextType();
        } else if (NEIClientConfig.isKeyHashDown("gui.prev_recipe")) {
            this.prevPage();
        } else if (NEIClientConfig.isKeyHashDown("gui.next_recipe")) {
            this.nextPage();
        }
    }

    protected void func_73864_a(int mousex, int mousey, int button) {
        if (this.handler != null && this.handler.searchingAvailable()) {
            if (toggleSearch.contains(mousex, mousey)) {
                toggleSearch.handleClick(mousex, mousey, button);
            } else if (searchField.contains(mousex, mousey)) {
                searchField.handleClick(mousex, mousey, button);
            } else {
                searchField.onGuiClick(mousex, mousey);
            }
        }
        if (this.recipeCatalyst.isShowWidget() && this.recipeCatalyst.handleClick(mousex, mousey, button)) {
            return;
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            if (this.container.handleClick(mousex, mousey, button)) {
                return;
            }
        }
        if (this.recipeTabs.mouseClicked(mousex, mousey, button)) {
            return;
        }
        super.func_73864_a(mousex, mousey, button);
    }

    protected void func_146273_a(int mousex, int mousey, int button, long heldTime) {
        if (this.recipeCatalyst.isShowWidget()) {
            this.recipeCatalyst.mouseDragged(mousex, mousey, button, heldTime);
        }
        this.container.mouseDragged(mousex, mousey, button, heldTime);
        super.func_146273_a(mousex, mousey, button, heldTime);
    }

    protected void func_146286_b(int mousex, int mousey, int state) {
        if (state != -1) {
            if (this.recipeCatalyst.isShowWidget()) {
                this.recipeCatalyst.mouseUp(mousex, mousey, state);
            }
            this.container.mouseUp(mousex, mousey, state);
        }
        super.func_146286_b(mousex, mousey, state);
    }

    @Override
    public void mouseScrolled(int scroll) {
        if (this.recipeTabs.mouseScrolled(scroll)) {
            return;
        }
        Point mouse = GuiDraw.getMousePosition();
        if (this.recipeCatalyst.isShowWidget() && this.recipeCatalyst.onMouseWheel(scroll, mouse.x, mouse.y)) {
            return;
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            if (this.container.onMouseWheel(scroll, mouse.x, mouse.y)) {
                return;
            }
        }
        if (NEIClientUtils.shiftKey()) {
            if (scroll < 0) {
                this.nextType();
            } else {
                this.prevType();
            }
            return;
        }
        if (new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g).contains(mouse)) {
            if (scroll > 0) {
                this.prevPage();
            } else {
                this.nextPage();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.container.w = Math.max(this.field_146999_f - 6, this.handlerInfo.getWidth());
        this.handler.original.onUpdate();
        this.refreshPage();
        this.container.update();
        this.recipeCatalyst.setAvailableHeight(this.field_147000_g - 5);
        this.recipeCatalyst.y = this.field_147009_r;
        this.recipeCatalyst.x = this.field_147003_i - this.recipeCatalyst.w + 4;
        this.recipeCatalyst.update();
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        String pageInfo;
        if (this.recipeCatalyst.isShowWidget()) {
            currenttip = this.recipeCatalyst.handleTooltip(mousex, mousey, currenttip);
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            currenttip = this.container.handleTooltip(mousex, mousey, currenttip);
        }
        this.recipeTabs.handleTooltip(mousex, mousey, currenttip);
        if (currenttip.isEmpty() && searchField.isVisible() && new Rectangle(GuiRecipe.searchField.x + GuiRecipe.searchField.w, 15, 44, 16).contains(mousex - this.field_147003_i, mousey - this.field_147009_r) && this.field_146289_q.func_78256_a(pageInfo = String.format("%d/%d", this.page + 1, Math.max(1, this.numRecipes() - 1) / this.getRecipesPerPage() + 1)) >= 45) {
            currenttip.add(pageInfo);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        Widget activeWidget = this.container.getWidgetUnderMouse(mousex, mousey);
        if (activeWidget instanceof NEIRecipeWidget) {
            NEIRecipeWidget recipeWidget = (NEIRecipeWidget)activeWidget;
            currenttip = recipeWidget.handleItemTooltip(itemstack, mousex, mousey, currenttip);
        }
        if (NEIClientConfig.showCycledIngredientsTooltip() && itemstack != null) {
            PositionedStack hovered = null;
            if (activeWidget instanceof NEIRecipeWidget) {
                NEIRecipeWidget recipeWidget = (NEIRecipeWidget)activeWidget;
                hovered = recipeWidget.getPositionedStackMouseOver(mousex, mousey);
            }
            if (hovered == null || hovered.items.length <= 1) {
                this.acceptsFollowingTooltipLineHandler = null;
            } else if (this.acceptsFollowingTooltipLineHandler == null || this.acceptsFollowingTooltipLineHandler.tooltipGUID != hovered) {
                this.acceptsFollowingTooltipLineHandler = AcceptsFollowingTooltipLineHandler.of(hovered, hovered.getFilteredPermutations(), hovered.item);
            }
        } else if (this.acceptsFollowingTooltipLineHandler != null) {
            this.acceptsFollowingTooltipLineHandler = null;
        }
        if (this.acceptsFollowingTooltipLineHandler != null) {
            this.acceptsFollowingTooltipLineHandler.setActiveStack(((PositionedStack)this.acceptsFollowingTooltipLineHandler.tooltipGUID).item);
            currenttip.add("\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)this.acceptsFollowingTooltipLineHandler));
        }
        return currenttip;
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        if (this.recipeCatalyst.isShowWidget()) {
            hotkeys = this.recipeCatalyst.handleHotkeys(mousex, mousey, hotkeys);
        }
        try (CompatibilityHacks compatibilityHacks = new CompatibilityHacks();){
            hotkeys = this.container.handleHotkeys(mousex, mousey, hotkeys);
        }
        if (this.acceptsFollowingTooltipLineHandler != null) {
            hotkeys.put(NEIClientUtils.getKeyName(0x4000000, -2013265920), NEIClientUtils.translate("recipe.accepts.scroll", new Object[0]));
        }
        return hotkeys;
    }

    private void nextPage() {
        this.changePage(1);
    }

    private void prevPage() {
        this.changePage(-1);
    }

    protected void nextType() {
        this.setRecipePage(++this.recipetype);
    }

    protected void prevType() {
        this.setRecipePage(--this.recipetype);
    }

    protected void changePage(int shift) {
        int recipesPerPage = this.getRecipesPerPage();
        int numRecipes = this.numRecipes();
        int oldPage = this.page;
        if (numRecipes > 0) {
            int numPages = (int)Math.ceil((float)numRecipes / (float)recipesPerPage);
            this.page = Math.min(Math.max(0, this.page), numPages);
            this.page = (numPages + this.page + shift) % numPages;
        } else {
            this.page = 0;
        }
        if (this.page != oldPage) {
            this.container.setVerticalScrollOffset(0);
        }
    }

    public GuiRecipeCatalyst getRecipeCatalystWidget() {
        return this.recipeCatalyst;
    }

    public void forceRefreshPage() {
        this.field_146292_n.removeIf(Arrays.asList(this.overlayButtons)::contains);
        this.overlayButtons = new GuiOverlayButton[0];
        this.currenthandlers.sort(NEIClientConfig.HANDLER_COMPARATOR);
        this.recipePageCacheKey = "";
        this.refreshPage();
    }

    public void refreshPage() {
        boolean multiplepages;
        this.changePage(0);
        int recipesPerPage = this.getRecipesPerPage();
        this.prevpage.field_146124_l = this.nextpage.field_146124_l = (multiplepages = this.numRecipes() > recipesPerPage);
        this.recipeCatalyst.setCatalysts(RecipeCatalysts.getRecipeCatalysts(this.handler.original));
        this.updateRecipePage();
    }

    public void func_146979_b(int mouseX, int mouseY) {
        GL11.glTranslatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.container.draw(mouseX, mouseY);
        if (NEIClientConfig.getJEIStyleRecipeCatalysts() != 0 && this.recipeCatalyst.isShowWidget()) {
            this.recipeCatalyst.draw(mouseX, mouseY);
        }
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
    }

    public void func_146976_a(float f, int mouseX, int mouseY) {
        this.BG_TEXTURE.draw(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g, 5, 5, 5, 5);
        this.drawJEITabs(mouseX, mouseY);
    }

    private void drawJEITabs(int mouseX, int mouseY) {
        int recipesPerPage = this.getRecipesPerPage();
        int textMiddle = (13 - this.field_146289_q.field_78288_b) / 2;
        GuiRecipe.func_73734_a((int)(this.prevtype.field_146128_h + 13 - 1), (int)this.prevtype.field_146129_i, (int)this.nexttype.field_146128_h, (int)(this.prevtype.field_146129_i + 12), (int)0x30000000);
        GuiRecipe.func_73734_a((int)(this.prevpage.field_146128_h + 13 - 1), (int)this.prevpage.field_146129_i, (int)this.nextpage.field_146128_h, (int)(this.prevpage.field_146129_i + 12), (int)0x30000000);
        this.func_73732_a(this.field_146289_q, this.handler.original.getRecipeName().trim(), this.field_147003_i + this.field_146999_f / 2, this.prevtype.field_146129_i + textMiddle, 0xFFFFFF);
        if (this.handler.searchingAvailable()) {
            toggleSearch.draw(mouseX, mouseY);
        }
        if (searchField.isVisible()) {
            searchField.draw(mouseX, mouseY);
        }
        if (searchField.isVisible()) {
            String recipePage = NEIClientUtils.cropText(this.field_146289_q, String.format("%d/%d", this.page + 1, Math.max(0, this.numRecipes() - 1) / recipesPerPage + 1), 45);
            this.func_73732_a(this.field_146289_q, recipePage, GuiRecipe.searchField.x + GuiRecipe.searchField.w + 22, this.prevpage.field_146129_i + textMiddle, 0xFFFFFF);
        } else {
            String recipePage = NEIClientUtils.translate("recipe.page", this.page + 1, Math.max(0, this.numRecipes() - 1) / recipesPerPage + 1);
            this.func_73732_a(this.field_146289_q, recipePage, this.field_147003_i + this.field_146999_f / 2, this.prevpage.field_146129_i + textMiddle, 0xFFFFFF);
        }
        if (NEIClientConfig.areJEIStyleTabsVisible()) {
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.recipeTabs.draw(mouseX, mouseY);
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    @Override
    public GuiScreen getFirstScreenGeneral() {
        return this.firstGuiGeneral;
    }

    private int getRecipesPerPage() {
        if (this.handlerInfo.getMaxRecipesPerPage() <= 1) {
            return 1;
        }
        if (NEIClientConfig.getBooleanSetting("inventory.guirecipe.infiniteScroll")) {
            return Math.max(1, this.handler.numRecipes());
        }
        return Math.max(this.container.h / (this.handlerInfo.getHeight() + this.handlerInfo.getYShift()), 1);
    }

    public Point getRecipePosition(int recipe) {
        return this.getRefIndexPosition(this.getRecipeIndices().indexOf(recipe));
    }

    protected Point getRefIndexPosition(int refIndex) {
        Widget widget;
        List<Widget> children = this.container.getWidgets();
        if (refIndex >= 0 && refIndex < children.size() && (widget = children.get(refIndex)) instanceof NEIRecipeWidget) {
            NEIRecipeWidget recipeWidget = (NEIRecipeWidget)widget;
            return new Point(recipeWidget.x - this.field_147003_i, recipeWidget.y - this.field_147009_r + recipeWidget.getHandlerInfo().getYShift());
        }
        return new Point(0, 0);
    }

    public abstract ArrayList<H> getCurrentRecipeHandlers();

    @Override
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    @Override
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return Collections.emptyList();
    }

    @Override
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Override
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        if (searchField.isVisible() && searchField.contains(mousex, mousey)) {
            searchField.setText(SearchField.getEscapedSearchText(draggedStack));
            return true;
        }
        return false;
    }

    @Override
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        Rectangle4i rect = new Rectangle4i(x, y, w, h);
        if (this.recipeCatalyst.isShowWidget() && this.recipeCatalyst.boundsOutside().intersects(rect)) {
            return true;
        }
        if (this.getRecipesPerPage() == 1 && !this.container.getWidgets().isEmpty()) {
            return this.container.getWidgets().get(0).bounds().intersects(rect);
        }
        return this.container.boundsOutside().intersects(rect);
    }

    protected static Recipe.RecipeId getCurrentRecipeId(GuiScreen gui) {
        if (gui instanceof GuiRecipe) {
            GuiRecipe gRecipe = (GuiRecipe)gui;
            if (gRecipe.handler.numRecipes() > 0) {
                List<Integer> indices = gRecipe.getRecipeIndices();
                int curRecipe = indices.isEmpty() ? 0 : indices.get(0);
                Recipe recipe = Recipe.of(gRecipe.handler.original, curRecipe);
                return recipe != null ? recipe.getRecipeId() : null;
            }
        }
        return null;
    }

    @Deprecated
    public List<GuiButton> getOverlayButtons() {
        return Arrays.asList(this.overlayButtons);
    }

    @Deprecated
    public boolean isLimitedToOneRecipe() {
        return false;
    }

    private class CompatibilityHacks
    implements AutoCloseable {
        private final int trueHeight;
        private final int trueGuiTop;

        private CompatibilityHacks() {
            this.trueHeight = GuiRecipe.this.field_146295_m;
            this.trueGuiTop = GuiRecipe.this.field_147009_r;
            GuiRecipe.this.isHeightHackApplied = NEIClientConfig.heightHackHandlerRegex.stream().map(pattern -> pattern.matcher(((GuiRecipe)GuiRecipe.this).handler.original.getHandlerId())).anyMatch(Matcher::matches);
            if (GuiRecipe.this.isHeightHackApplied) {
                GuiRecipe.this.field_147009_r += 16;
                GuiRecipe.this.field_146295_m = 2 * GuiRecipe.this.field_147009_r + 166;
            }
        }

        @Override
        public void close() {
            GuiRecipe.this.field_147009_r = this.trueGuiTop;
            GuiRecipe.this.field_146295_m = this.trueHeight;
            GuiRecipe.this.isHeightHackApplied = false;
        }
    }
}

