/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import li.cil.oc.OpenComputers$;
import li.cil.oc.api.fs.Mode;
import li.cil.oc.server.fs.Buffered;
import li.cil.oc.server.fs.Buffered$;
import li.cil.oc.server.fs.FileSystem$;
import li.cil.oc.server.fs.InputStreamFileSystem;
import li.cil.oc.server.fs.OutputStreamFileSystem;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class Buffered$class {
    public static boolean delete(Buffered $this, String path) {
        boolean bl;
        if ($this.li$cil$oc$server$fs$Buffered$$super$delete(path)) {
            $this.li$cil$oc$server$fs$Buffered$$deletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean rename(Buffered $this, String from, String to) {
        boolean bl;
        if ($this.li$cil$oc$server$fs$Buffered$$super$rename(from, to)) {
            $this.li$cil$oc$server$fs$Buffered$$deletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)from), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static void load(Buffered $this, NBTTagCompound nbt) {
        $this.li$cil$oc$server$fs$Buffered$$saving().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Future<?> f) {
                Object object;
                try {
                    object = f.get(120L, TimeUnit.SECONDS);
                }
                catch (CancellationException cancellationException) {
                    object = BoxedUnit.UNIT;
                }
                catch (TimeoutException timeoutException) {
                    OpenComputers$.MODULE$.log().warn("Waiting for filesystem to save took two minutes! Aborting.");
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
        });
        Buffered$class.loadFiles($this, nbt);
        $this.li$cil$oc$server$fs$Buffered$$super$load(nbt);
    }

    private static void loadFiles(Buffered $this, NBTTagCompound nbt) {
        Buffered buffered = $this;
        synchronized (buffered) {
            Boolean bl;
            if ($this.fileRoot().list() == null || Predef$.MODULE$.refArrayOps((Object[])$this.fileRoot().list()).isEmpty()) {
                bl = BoxesRunTime.boxToBoolean((boolean)$this.fileRoot().delete());
            } else {
                Buffered$class.recurse$1($this, "", $this.fileRoot());
                bl = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static void save(Buffered $this, NBTTagCompound nbt) {
        $this.li$cil$oc$server$fs$Buffered$$super$save(nbt);
        $this.li$cil$oc$server$fs$Buffered$$saving_$eq(Buffered$.MODULE$.fileSaveHandler().withPool((Function1<ScheduledExecutorService, Future<?>>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Buffered $outer;

            public final Future<?> apply(ScheduledExecutorService x$1) {
                return x$1.submit(new Runnable(this){
                    private final /* synthetic */ Buffered$.anonfun.save.1 $outer;

                    public void run() {
                        this.$outer.li$cil$oc$server$fs$Buffered$$anonfun$$$outer().saveFiles();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ Buffered li$cil$oc$server$fs$Buffered$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffered$.MODULE$.fileSaveHandler().withPool$default$2()));
    }

    public static void saveFiles(Buffered $this) {
        Buffered buffered = $this;
        synchronized (buffered) {
            $this.li$cil$oc$server$fs$Buffered$$deletions().withFilter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                    Tuple2<String, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Buffered $outer;

                public final Object apply(Tuple2<String, Object> x$2) {
                    Tuple2<String, Object> tuple2 = x$2;
                    if (tuple2 != null) {
                        String path = (String)tuple2._1();
                        long time = tuple2._2$mcJ$sp();
                        File file = new File(this.$outer.fileRoot(), path);
                        BoxedUnit boxedUnit = FileUtils.isFileOlder((File)file, (long)time) ? BoxesRunTime.boxToBoolean((boolean)FileUtils.deleteQuietly((File)file)) : BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            $this.li$cil$oc$server$fs$Buffered$$deletions().clear();
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            Boolean bl = $this.list("") == null || Predef$.MODULE$.refArrayOps((Object[])$this.list("")).isEmpty() ? BoxesRunTime.boxToBoolean((boolean)$this.fileRoot().delete()) : BoxesRunTime.boxToBoolean((boolean)Buffered$class.recurse$2($this, "", buffer));
            return;
        }
    }

    public static final void recurse$1(Buffered $this, String path, File directory) {
        $this.makeDirectory(path);
        Predef$.MODULE$.refArrayOps((Object[])directory.listFiles()).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File child) {
                return FileSystem$.MODULE$.isValidFilename(child.getName());
            }
        }).foreach((Function1)new Serializable($this, path, directory){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Buffered $outer;
            private final String path$1;
            private final File directory$1;

            /*
             * Loose catch block
             */
            public final Object apply(File child) {
                BoxedUnit boxedUnit;
                block7: {
                    Object object;
                    block9: {
                        OutputStreamFileSystem.OutputHandle stream;
                        File childFile;
                        String childPath;
                        block5: {
                            block8: {
                                block6: {
                                    childPath = new StringBuilder().append((Object)this.path$1).append((Object)child.getName()).toString();
                                    childFile = new File(this.directory$1, child.getName());
                                    if (!child.exists() || !child.isDirectory() || child.list() == null) break block6;
                                    Buffered$class.recurse$1(this.$outer, new StringBuilder().append((Object)childPath).append((Object)"/").toString(), childFile);
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                if (!this.$outer.exists(childPath) || !this.$outer.isDirectory(childPath)) break block8;
                                boxedUnit = BoxedUnit.UNIT;
                                break block7;
                            }
                            Option<OutputStreamFileSystem.OutputHandle> option = this.$outer.openOutputHandle(0, childPath, Mode.Write);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                stream = (OutputStreamFileSystem.OutputHandle)some.x();
                                FileInputStream in = new FileInputStream(childFile);
                                byte[] buffer = new byte[8192];
                                int read = 0;
                                do {
                                    if ((read = in.read(buffer)) <= 0) continue;
                                    if (read == buffer.length) {
                                        stream.write(buffer);
                                        continue;
                                    }
                                    stream.write((byte[])Predef$.MODULE$.byteArrayOps(buffer).view(0, read).toArray(ClassTag$.MODULE$.Byte()));
                                } while (read >= 0);
                                in.close();
                                break block5;
                            }
                            object = BoxedUnit.UNIT;
                            break block9;
                            catch (FileNotFoundException fileNotFoundException) {}
                        }
                        stream.close();
                        object = BoxesRunTime.boxToBoolean((boolean)this.$outer.setLastModified(childPath, childFile.lastModified()));
                    }
                    boxedUnit = object;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.path$1 = path$1;
                this.directory$1 = directory$1;
            }
        });
        $this.setLastModified(path, directory.lastModified());
    }

    public static final boolean recurse$2(Buffered $this, String path, ByteBuffer buffer$1) {
        boolean bl;
        File directory = new File($this.fileRoot(), path);
        directory.mkdirs();
        BooleanRef dirChanged = BooleanRef.create((boolean)false);
        Predef$.MODULE$.refArrayOps((Object[])$this.list(path)).foreach((Function1)new Serializable($this, buffer$1, path, dirChanged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Buffered $outer;
            private final ByteBuffer buffer$1;
            private final String path$2;
            private final BooleanRef dirChanged$1;

            public final void apply(String child) {
                String childPath = new StringBuilder().append((Object)this.path$2).append((Object)child).toString();
                if (this.$outer.isDirectory(childPath)) {
                    this.dirChanged$1.elem = Buffered$class.recurse$2(this.$outer, childPath, this.buffer$1) || this.dirChanged$1.elem;
                } else {
                    File childFile = new File(this.$outer.fileRoot(), childPath);
                    long time = this.$outer.lastModified(childPath);
                    if (time == 0L || !childFile.exists() || FileUtils.isFileOlder((File)childFile, (long)time)) {
                        FileUtils.deleteQuietly((File)childFile);
                        childFile.createNewFile();
                        FileChannel out = new FileOutputStream(childFile).getChannel();
                        InputStreamFileSystem.InputChannel in = (InputStreamFileSystem.InputChannel)this.$outer.openInputChannel(childPath).get();
                        this.buffer$1.clear();
                        while (in.read(this.buffer$1) != -1) {
                            this.buffer$1.flip();
                            out.write(this.buffer$1);
                            this.buffer$1.compact();
                        }
                        this.buffer$1.flip();
                        while (this.buffer$1.hasRemaining()) {
                            out.write(this.buffer$1);
                        }
                        out.close();
                        in.close();
                        childFile.setLastModified(time);
                        this.dirChanged$1.elem = true;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.buffer$1 = buffer$1;
                this.path$2 = path$2;
                this.dirChanged$1 = dirChanged$1;
            }
        });
        if (dirChanged.elem) {
            directory.setLastModified($this.lastModified(path));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static void $init$(Buffered $this) {
        $this.li$cil$oc$server$fs$Buffered$_setter_$li$cil$oc$server$fs$Buffered$$deletions_$eq(Map$.MODULE$.empty());
        $this.li$cil$oc$server$fs$Buffered$$saving_$eq((Option<Future<?>>)None$.MODULE$);
    }
}

