/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.items;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.handlers.WorldEventHandler;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.items.BaseItem;
import ganymedes01.etfuturum.world.generate.feature.WorldGenFossil;
import ganymedes01.etfuturum.world.generate.feature.WorldGenGeode;
import ganymedes01.etfuturum.world.generate.structure.WorldGenNBTStructureTesting;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class DebugTestItem
extends BaseItem {
    private static final String langkey = "debug_test_item";

    public DebugTestItem() {
        this.func_77655_b(langkey);
        this.func_111206_d("ruby");
        this.func_77627_a(true);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!this.canUse(player)) {
            return false;
        }
        if (stack.func_77960_j() == 0) {
            return false;
        }
        TestTypes testSubject = TestTypes.values()[stack.func_77960_j() % TestTypes.values().length];
        if (world.field_72995_K && testSubject.isServerOnly()) {
            return true;
        }
        world.field_72984_F.func_76320_a("Et Futurum Requiem debugging item task");
        boolean flag = testSubject.runAction(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        world.field_72984_F.func_76319_b();
        return flag;
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.entityPlayer != null && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && this.canUse(event.entityPlayer) && event.entityPlayer.func_70694_bm() != null && event.entityPlayer.func_70694_bm().func_77973_b() == ModItems.DEBUGGING_TOOL.get()) {
            event.entityPlayer.func_71045_bC().func_77964_b((event.entityPlayer.func_71045_bC().func_77960_j() + 1) % TestTypes.values().length);
            event.setCanceled(true);
        }
    }

    private boolean canUse(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return FMLClientHandler.instance().getClientPlayerEntity().field_71075_bZ.field_75098_d;
        }
        if (player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)player).field_71134_c.func_73083_d();
        }
        return false;
    }

    public String func_77653_i(ItemStack p_77653_1_) {
        return "Debugging Item" + TestTypes.values()[p_77653_1_.func_77960_j() % TestTypes.values().length].getSuffix();
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.epic;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List<String> p_77624_3_, boolean p_77624_4_) {
        if (this.canUse(p_77624_2_)) {
            p_77624_3_.add("\u00a7b\u00a7oA debug item used to test mechanics certain code.");
            p_77624_3_.add("\u00a7a\u00a7oAttack\u00a7a\u00a7o a block to change the test subject.");
            p_77624_3_.add("\u00a7b\u00a7oClick the \u00a7a\u00a7ouse item button\u00a7b\u00a7o to run the test.");
        } else {
            p_77624_3_.add("\u00a74\u00a7oYou must be in Creative mode to use this item.");
        }
        p_77624_3_.add("\u00a76\u00a7oDev environment only.");
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        return 0.0f;
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getPlayer().func_70694_bm() != null && event.getPlayer().func_70694_bm().func_77973_b() == ModItems.DEBUGGING_TOOL.get()) {
            event.setCanceled(true);
        }
    }

    private static enum TestTypes {
        NONE(null, false),
        FOSSIL("Fossil", true){
            final WorldGenFossil fossil = new WorldGenFossil(){

                @Override
                protected boolean canFossilGenerateHere(World world, int x, int y, int z, BlockPos corners) {
                    return true;
                }
            };

            @Override
            protected boolean runAction(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
                return this.fossil.func_76484_a(world, world.field_73012_v, x, y, z);
            }
        }
        ,
        GEODE("Geode", true){
            final WorldGenGeode fossil = new WorldGenGeode(ConfigWorld.amethystOuterBlock, ConfigWorld.amethystMiddleBlock){

                @Override
                protected boolean isInvalidCorner(World world, int x, int y, int z) {
                    return false;
                }
            };

            @Override
            protected boolean runAction(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
                return this.fossil.func_76484_a(world, world.field_73012_v, x, y, z);
            }
        }
        ,
        BEE_NEST("Bee Nest", true){

            @Override
            protected boolean runAction(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
                WorldEventHandler.tryPlaceBeeNest(world, x, y, z, world.field_73012_v, 3);
                return true;
            }
        }
        ,
        NBT_STRUCTURE_TEST("NBT Structure Test", true){
            private final WorldGenNBTStructureTesting struct = new WorldGenNBTStructureTesting();

            @Override
            protected boolean runAction(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
                boolean run = this.struct.func_76484_a(world, world.field_73012_v, x, y, z);
                world.func_147449_b(x, y, z, Blocks.field_150451_bX);
                return run;
            }
        };

        private final String suffix;
        private final boolean serverOnly;

        private TestTypes(String name, boolean server) {
            this.suffix = name;
            this.serverOnly = server;
        }

        private String getSuffix() {
            return this.suffix == null ? "" : " | Test Subject: \u00a7o" + this.suffix + "\u00a7r";
        }

        protected boolean runAction(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
            return false;
        }

        private boolean isServerOnly() {
            return this.serverOnly;
        }
    }
}

