/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.albion;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityCooledBase
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver {
    public FluidTank[] tanks = new FluidTank[2];
    public long power;
    public static final float KELVIN = 273.0f;
    public float temperature = 293.0f;
    public static final float temperature_target = 123.0f;
    public static final float temp_change_per_mb = 0.5f;
    public static final float temp_passive_heating = 2.5f;
    public static final float temp_change_max = 7.5f;

    public TileEntityCooledBase(int slotCount) {
        super(slotCount);
        this.tanks[0] = new FluidTank(Fluids.PERFLUOROMETHYL_COLD, 4000);
        this.tanks[1] = new FluidTank(Fluids.PERFLUOROMETHYL, 4000);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.temperature += 2.5f;
            if (this.temperature > 293.0f) {
                this.temperature = 293.0f;
            }
            if (this.temperature > 123.0f) {
                int cyclesTemp = (int)Math.ceil(Math.min(this.temperature - 123.0f, 7.5f) / 0.5f);
                int cyclesCool = this.tanks[0].getFill();
                int cyclesHot = this.tanks[1].getMaxFill() - this.tanks[1].getFill();
                int cycles = BobMathUtil.min(cyclesTemp, cyclesCool, cyclesHot);
                this.tanks[0].setFill(this.tanks[0].getFill() - cycles);
                this.tanks[1].setFill(this.tanks[1].getFill() + cycles);
                this.temperature -= 0.5f * (float)cycles;
            }
            this.networkPackNT(50);
        }
    }

    public boolean isCool() {
        return this.temperature <= 123.0f;
    }

    public abstract DirPos[] getConPos();

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        buf.writeFloat(this.temperature);
        buf.writeLong(this.power);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.temperature = buf.readFloat();
        this.power = buf.readLong();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.temperature = nbt.func_74760_g("temperature");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        nbt.func_74776_a("temperature", this.temperature);
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }
}

