/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.dim.CelestialBody;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.CrucibleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineMagma
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver {
    public boolean operating;
    public long power;
    public long consumption = 10000L;
    public FluidTank[] tanks;
    public static final int maxLiquid = MaterialShapes.BLOCK.q(16);
    public List<Mats.MaterialStack> liquids = new ArrayList<Mats.MaterialStack>();
    public float drillSpeed;
    public float drillRotation;
    public float prevDrillRotation;
    public float lavaHeight;
    public float prevLavaHeight;
    public boolean validPosition = true;
    protected Mats.MaterialStack[] defaultOutputs = new Mats.MaterialStack[]{new Mats.MaterialStack(Mats.MAT_SLAG, MaterialShapes.INGOT.q(1)), new Mats.MaterialStack(Mats.MAT_RICH_MAGMA, MaterialShapes.QUANTUM.q(4))};
    AxisAlignedBB bb = null;

    public TileEntityMachineMagma() {
        super(0);
        this.tanks = new FluidTank[0];
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.operating = this.canOperate();
            if (this.operating) {
                this.power -= this.consumption;
                int timeBetweenOutputs = 10;
                if (this.field_145850_b.func_82737_E() % (long)timeBetweenOutputs == 0L) {
                    for (Mats.MaterialStack mat : this.getOutputs()) {
                        int totalLiquid = 0;
                        for (Mats.MaterialStack m : this.liquids) {
                            totalLiquid += m.amount;
                        }
                        int toAdd = mat.amount;
                        if (totalLiquid + toAdd > maxLiquid) break;
                        this.addToStack(mat);
                    }
                }
            }
            if (!this.liquids.isEmpty()) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                Vec3 impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                Mats.MaterialStack didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.875, (double)this.field_145848_d + 1.25, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.875, 6.0, true, this.liquids, MaterialShapes.INGOT.q(1), impact);
                if (didPour != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)(this.field_145848_d + 1) - (float)(Math.ceil(impact.field_72448_b) - 0.875)));
                    PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.875, this.field_145848_d + 1, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                }
            }
            this.liquids.removeIf(o -> o.amount <= 0);
            this.networkPackNT(250);
        } else {
            this.prevLavaHeight = this.lavaHeight;
            this.prevDrillRotation = this.drillRotation;
            if (this.operating) {
                this.drillSpeed += 0.15f;
                if (this.drillSpeed > 15.0f) {
                    this.drillSpeed = 15.0f;
                }
                this.lavaHeight = (float)((double)this.lavaHeight + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) * 0.01);
                this.lavaHeight = (float)BobMathUtil.lerp(0.02, this.lavaHeight, 0.9);
            } else {
                this.drillSpeed -= 0.3f;
                if (this.drillSpeed < 0.0f) {
                    this.drillSpeed = 0.0f;
                }
                this.lavaHeight = (float)BobMathUtil.lerp(0.02, this.lavaHeight, 0.0);
            }
            this.drillRotation += this.drillSpeed;
            if (this.drillRotation > 360.0f) {
                this.drillRotation -= 360.0f;
                this.prevDrillRotation -= 360.0f;
            }
        }
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 4, this.field_145848_d - 1, this.field_145849_e - dir.offsetZ * 4, dir), new DirPos(this.field_145851_c - dir.offsetX * 4, this.field_145848_d - 2, this.field_145849_e - dir.offsetZ * 4, dir), new DirPos(this.field_145851_c - dir.offsetX * 4 + rot.offsetX, this.field_145848_d - 1, this.field_145849_e - dir.offsetZ * 4 + rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 4 + rot.offsetX, this.field_145848_d - 2, this.field_145849_e - dir.offsetZ * 4 + rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 4 - rot.offsetX, this.field_145848_d - 1, this.field_145849_e - dir.offsetZ * 4 - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 4 - rot.offsetX, this.field_145848_d - 2, this.field_145849_e - dir.offsetZ * 4 - rot.offsetZ, dir)};
    }

    private boolean canOperate() {
        CelestialBody body = CelestialBody.getBody(this.field_145850_b);
        if (body.name != "moho") {
            return false;
        }
        this.validPosition = this.isValidPosition();
        if (!this.validPosition) {
            return false;
        }
        return this.power >= this.consumption;
    }

    private boolean isValidPosition() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d - 4, this.field_145849_e + z) == Blocks.field_150353_l) continue;
                return false;
            }
        }
        return true;
    }

    private Mats.MaterialStack[] getOutputs() {
        return this.defaultOutputs;
    }

    private void addToStack(Mats.MaterialStack matStack) {
        for (Mats.MaterialStack mat : this.liquids) {
            if (mat.material != matStack.material) continue;
            mat.amount += matStack.amount;
            return;
        }
        this.liquids.add(matStack.copy());
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.operating);
        buf.writeLong(this.power);
        buf.writeBoolean(this.validPosition);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
        buf.writeShort(this.liquids.size());
        for (Mats.MaterialStack sta : this.liquids) {
            buf.writeInt(sta.material.id);
            buf.writeInt(sta.amount);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.operating = buf.readBoolean();
        this.power = buf.readLong();
        this.validPosition = buf.readBoolean();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
        this.liquids.clear();
        int mats = buf.readShort();
        for (int i = 0; i < mats; ++i) {
            this.liquids.add(new Mats.MaterialStack(Mats.matById.get(buf.readInt()), buf.readInt()));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        int[] liquidData = nbt.func_74759_k("liquids");
        for (int i = 0; i < liquidData.length / 2; ++i) {
            NTMMaterial mat = Mats.matById.get(liquidData[i * 2]);
            if (mat == null) continue;
            this.liquids.add(new Mats.MaterialStack(mat, liquidData[i * 2 + 1]));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
        int[] liquidData = new int[this.liquids.size() * 2];
        for (int i = 0; i < this.liquids.size(); ++i) {
            Mats.MaterialStack sta = this.liquids.get(i);
            liquidData[i * 2] = sta.material.id;
            liquidData[i * 2 + 1] = sta.amount;
        }
        nbt.func_74783_a("liquids", liquidData);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }

    @Override
    public String getName() {
        return "container.machineMagma";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

