/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IDysonConverter;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDysonConverterAnatmogenesis
extends TileEntityMachineBase
implements IDysonConverter {
    public FluidType fluid = Fluids.OXYGEN;
    public boolean isEmitting = true;
    public long gasProduced;
    public boolean isConverting;
    private static final long HE_TO_MB = 28800000L;
    AxisAlignedBB bb = null;

    public TileEntityDysonConverterAnatmogenesis() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.dysonConverterAnatmogenesis";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.isConverting = this.gasProduced > 0L;
            this.networkPackNT(250);
            this.gasProduced = 0L;
        } else if (this.isConverting) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "tower");
            data.func_74776_a("lift", 0.5f);
            data.func_74776_a("base", 0.8f);
            data.func_74776_a("max", 4.0f);
            data.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(50));
            data.func_74768_a("color", this.fluid.getColor());
            data.func_74780_a("posX", (double)this.field_145851_c + 0.5);
            data.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
            data.func_74780_a("posY", (double)this.field_145848_d + 3.25);
            data.func_74780_a("mX", this.field_145850_b.field_73012_v.nextDouble() - 0.5);
            data.func_74780_a("mY", this.field_145850_b.field_73012_v.nextDouble() * 2.0);
            data.func_74780_a("mZ", this.field_145850_b.field_73012_v.nextDouble() - 0.5);
            MainRegistry.proxy.effectNT(data);
        }
    }

    @Override
    public boolean provideEnergy(int x, int y, int z, long energy) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        int rx = this.field_145851_c + dir.offsetX * 5;
        int ry = this.field_145848_d + 1;
        int rz = this.field_145849_e + dir.offsetZ * 5;
        if (x != rx || y != ry || z != rz) {
            return false;
        }
        long volume = energy / 28800000L;
        this.gasProduced += volume;
        if (this.isEmitting) {
            FT_Gaseous.release(this.field_145850_b, this.fluid, volume);
        } else {
            FT_Gaseous.capture(this.field_145850_b, this.fluid, volume);
        }
        return true;
    }

    @Override
    public long maximumEnergy() {
        return Long.MAX_VALUE;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isConverting);
        buf.writeLong(this.gasProduced);
        buf.writeInt(this.fluid.getID());
        buf.writeBoolean(this.isEmitting);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isConverting = buf.readBoolean();
        this.gasProduced = buf.readLong();
        this.fluid = Fluids.fromID(buf.readInt());
        this.isEmitting = buf.readBoolean();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluid = Fluids.fromID(nbt.func_74762_e("fluid"));
        this.isEmitting = nbt.func_74767_n("emit");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("fluid", this.fluid.getID());
        nbt.func_74757_a("emit", this.isEmitting);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 6), (double)this.field_145848_d, (double)(this.field_145849_e - 6), (double)(this.field_145851_c + 7), (double)(this.field_145848_d + 6), (double)(this.field_145849_e + 7));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

