/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.config.ClientConfig;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderInfoSystem {
    private static int nextID = 1000;
    private static HashMap<Integer, InfoEntry> inbox = new HashMap();
    private static HashMap<Integer, InfoEntry> messages = new HashMap();

    @SubscribeEvent
    public void clentTick(TickEvent.ClientTickEvent event) {
        messages.putAll(inbox);
        inbox.clear();
        ArrayList<Integer> keys = new ArrayList<Integer>(messages.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            Integer key = (Integer)keys.get(i);
            InfoEntry entry = messages.get(key);
            if (entry.start + (long)entry.millis >= System.currentTimeMillis()) continue;
            messages.remove(key);
            keys = new ArrayList<Integer>(messages.keySet());
            --i;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onOverlayRender(RenderGameOverlayEvent.Pre event) {
        int pX;
        if (event.type != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (messages.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = event.resolution;
        ArrayList<InfoEntry> entries = new ArrayList<InfoEntry>(messages.values());
        Collections.sort(entries);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        int longest = 0;
        for (InfoEntry entry : entries) {
            int length = mc.field_71466_p.func_78256_a(entry.text);
            if (length <= longest) continue;
            longest = length;
        }
        int mode = ClientConfig.INFO_POSITION.get();
        int n = mode == 0 ? 15 : (mode == 1 ? resolution.func_78326_a() - longest - 15 : (pX = mode == 2 ? resolution.func_78326_a() / 2 + 7 : resolution.func_78326_a() / 2 - longest - 6));
        int pZ = mode == 0 ? 15 : (mode == 1 ? 15 : resolution.func_78328_b() / 2 + 7);
        int side = (pX += ClientConfig.INFO_OFFSET_HORIZONTAL.get().intValue()) + 5 + longest;
        int height = messages.size() * 10 + (pZ += ClientConfig.INFO_OFFSET_VERTICAL.get().intValue()) + 2;
        boolean z = false;
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78369_a(0.25f, 0.25f, 0.25f, 0.5f);
        tess.func_78377_a((double)(pX - 5), (double)(pZ - 5), (double)z);
        tess.func_78377_a((double)(pX - 5), (double)height, (double)z);
        tess.func_78377_a((double)side, (double)height, (double)z);
        tess.func_78377_a((double)side, (double)(pZ - 5), (double)z);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        int off = 0;
        long now = System.currentTimeMillis();
        for (InfoEntry entry : entries) {
            int elapsed = (int)(now - entry.start);
            int alpha = Math.max(Math.min(510 * (entry.millis - elapsed) / entry.millis, 255), 5);
            int color = entry.color + (alpha << 24 & 0xFF000001);
            mc.field_71466_p.func_78276_b(entry.text, pX, pZ + off, color);
            off += 10;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void push(InfoEntry entry) {
        RenderInfoSystem.push(entry, nextID++);
    }

    public static void push(InfoEntry entry, int id) {
        inbox.put(id, entry);
    }

    public static class InfoEntry
    implements Comparable {
        String text;
        int color = 0xFFFFFF;
        long start;
        int millis;

        public InfoEntry(String text) {
            this(text, 3000);
        }

        public InfoEntry(String text, int millis) {
            this.text = text;
            this.millis = millis;
            this.start = System.currentTimeMillis();
        }

        public InfoEntry withColor(int color) {
            this.color = color;
            return this;
        }

        public int compareTo(Object o) {
            if (!(o instanceof InfoEntry)) {
                return 0;
            }
            InfoEntry other = (InfoEntry)o;
            return this.millis < other.millis ? -1 : (this.millis > other.millis ? 1 : 0);
        }
    }
}

