/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.handler.RocketStruct;
import com.hbm.items.weapon.ItemCustomMissilePart;
import com.hbm.main.ResourceManager;
import com.hbm.render.util.MissileMultipart;
import java.nio.DoubleBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureManager;
import org.lwjgl.opengl.GL11;

public class MissilePronter {
    private static DoubleBuffer buffer;

    public static void prontMissile(MissileMultipart missile, TextureManager tex) {
        GL11.glPushMatrix();
        if (missile.thruster != null && missile.thruster.type.name().equals(ItemCustomMissilePart.PartType.THRUSTER.name())) {
            tex.func_110577_a(missile.thruster.texture);
            missile.thruster.model.renderAll();
            GL11.glTranslated((double)0.0, (double)missile.thruster.height, (double)0.0);
        }
        if (missile.fuselage != null && missile.fuselage.type.name().equals(ItemCustomMissilePart.PartType.FUSELAGE.name())) {
            if (missile.fins != null && missile.fins.type.name().equals(ItemCustomMissilePart.PartType.FINS.name())) {
                tex.func_110577_a(missile.fins.texture);
                missile.fins.model.renderAll();
            }
            tex.func_110577_a(missile.fuselage.texture);
            missile.fuselage.model.renderAll();
            GL11.glTranslated((double)0.0, (double)missile.fuselage.height, (double)0.0);
        }
        if (missile.warhead != null && missile.warhead.type.name().equals(ItemCustomMissilePart.PartType.WARHEAD.name())) {
            tex.func_110577_a(missile.warhead.texture);
            missile.warhead.model.renderAll();
        }
        GL11.glPopMatrix();
    }

    public static void prontRocket(RocketStruct rocket, TextureManager tex) {
        MissilePronter.prontRocket(rocket, null, tex, true, 0.0f);
    }

    public static void prontRocket(RocketStruct rocket, TextureManager tex, boolean isDeployed) {
        MissilePronter.prontRocket(rocket, null, tex, isDeployed, 0.0f);
    }

    public static void prontRocket(RocketStruct rocket, EntityRideableRocket entity, TextureManager tex, boolean isDeployed, float interp) {
        GL11.glPushMatrix();
        GL11.glShadeModel((int)7425);
        boolean hasShroud = false;
        if (buffer == null) {
            buffer = GLAllocation.func_74524_c((int)32).asDoubleBuffer();
        }
        for (RocketStruct.RocketStage stage : rocket.stages) {
            int stack = stage.getStack();
            int cluster = stage.getCluster();
            if (isDeployed && stage.thruster != null && stage.fins != null && stage.fins.height > stage.thruster.height) {
                GL11.glTranslated((double)0.0, (double)(stage.fins.height - stage.thruster.height), (double)0.0);
            }
            for (int c = 0; c < cluster; ++c) {
                GL11.glPushMatrix();
                if (c > 0) {
                    float spin = (float)c / (float)(cluster - 1);
                    GL11.glRotatef((float)(360.0f * spin), (float)0.0f, (float)1.0f, (float)0.0f);
                    if (stage.fuselage != null) {
                        GL11.glTranslated((double)stage.fuselage.part.bottom.radius, (double)0.0, (double)0.0);
                    } else if (stage.thruster != null) {
                        GL11.glTranslated((double)stage.thruster.part.top.radius, (double)0.0, (double)0.0);
                    }
                }
                if (stage.thruster != null) {
                    if (hasShroud && stage.fuselage != null) {
                        tex.func_110577_a(ResourceManager.universal);
                        buffer.put(new double[]{0.0, -1.0, 0.0, stage.thruster.height});
                        buffer.rewind();
                        GL11.glEnable((int)12288);
                        GL11.glClipPlane((int)12288, (DoubleBuffer)buffer);
                        stage.fuselage.getShroud().renderAll();
                        GL11.glDisable((int)12288);
                    } else {
                        tex.func_110577_a(stage.thruster.texture);
                        stage.thruster.getModel(isDeployed).renderAll();
                    }
                    GL11.glTranslated((double)0.0, (double)stage.thruster.height, (double)0.0);
                }
                if (stage.fuselage != null) {
                    if (stage.fins != null) {
                        tex.func_110577_a(stage.fins.texture);
                        stage.fins.getModel(isDeployed).renderAll();
                    }
                    for (int s = 0; s < stack; ++s) {
                        tex.func_110577_a(stage.fuselage.texture);
                        stage.fuselage.getModel(isDeployed).renderAll();
                        GL11.glTranslated((double)0.0, (double)stage.fuselage.height, (double)0.0);
                    }
                }
                GL11.glPopMatrix();
            }
            if (stage.thruster != null) {
                GL11.glTranslated((double)0.0, (double)stage.thruster.height, (double)0.0);
            }
            if (stage.fuselage != null) {
                GL11.glTranslated((double)0.0, (double)(stage.fuselage.height * (double)stack), (double)0.0);
            }
            isDeployed = false;
            hasShroud = true;
        }
        if (rocket.capsule != null) {
            if (entity != null && rocket.capsule.renderer != null) {
                rocket.capsule.renderer.render(tex, entity, interp);
            } else {
                tex.func_110577_a(rocket.capsule.texture);
                rocket.capsule.model.renderAll();
            }
        }
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }
}

