/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class GaugeUtil {
    public static void renderGauge(Gauge gauge, double x, double y, double z, double progress) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(gauge.texture);
        int frameNum = (int)Math.round((double)(gauge.count - 1) * progress);
        double singleFrame = 1.0 / (double)gauge.count;
        double frameOffset = singleFrame * (double)frameNum;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a(x, y + (double)gauge.height, z, 0.0, frameOffset + singleFrame);
        tess.func_78374_a(x + (double)gauge.width, y + (double)gauge.height, z, 1.0, frameOffset + singleFrame);
        tess.func_78374_a(x + (double)gauge.width, y, z, 1.0, frameOffset);
        tess.func_78374_a(x, y, z, 0.0, frameOffset);
        tess.func_78381_a();
    }

    public static void drawSmoothGauge(int x, int y, double z, double progress, double tipLength, double backLength, double backSide, int color) {
        GaugeUtil.drawSmoothGauge(x, y, z, progress, tipLength, backLength, backSide, color, 0);
    }

    public static void drawSmoothGauge(int x, int y, double z, double progress, double tipLength, double backLength, double backSide, int color, int colorOuter) {
        GL11.glDisable((int)3553);
        progress = MathHelper.func_151237_a((double)progress, (double)0.0, (double)1.0);
        float angle = (float)Math.toRadians(-progress * 270.0 - 45.0);
        Vec3 tip = Vec3.func_72443_a((double)0.0, (double)tipLength, (double)0.0);
        Vec3 left = Vec3.func_72443_a((double)backSide, (double)(-backLength), (double)0.0);
        Vec3 right = Vec3.func_72443_a((double)(-backSide), (double)(-backLength), (double)0.0);
        tip.func_72446_c(angle);
        left.func_72446_c(angle);
        right.func_72446_c(angle);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(4);
        tess.func_78378_d(colorOuter);
        double mult = 1.5;
        tess.func_78377_a((double)x + tip.field_72450_a * mult, (double)y + tip.field_72448_b * mult, z);
        tess.func_78377_a((double)x + left.field_72450_a * mult, (double)y + left.field_72448_b * mult, z);
        tess.func_78377_a((double)x + right.field_72450_a * mult, (double)y + right.field_72448_b * mult, z);
        tess.func_78378_d(color);
        tess.func_78377_a((double)x + tip.field_72450_a, (double)y + tip.field_72448_b, z);
        tess.func_78377_a((double)x + left.field_72450_a, (double)y + left.field_72448_b, z);
        tess.func_78377_a((double)x + right.field_72450_a, (double)y + right.field_72448_b, z);
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static enum Gauge {
        ROUND_SMALL(new ResourceLocation("hbm:textures/gui/gauges/small_round.png"), 18, 18, 13),
        ROUND_LARGE(new ResourceLocation("hbm:textures/gui/gauges/large_round.png"), 36, 36, 13),
        BOW_SMALL(new ResourceLocation("hbm:textures/gui/gauges/small_bow.png"), 18, 18, 13),
        BOW_LARGE(new ResourceLocation("hbm:textures/gui/gauges/large_bow.png"), 36, 36, 13),
        WIDE_SMALL(new ResourceLocation("hbm:textures/gui/gauges/small_wide.png"), 18, 12, 7),
        WIDE_LARGE(new ResourceLocation("hbm:textures/gui/gauges/large_wide.png"), 36, 24, 11),
        BAR_SMALL(new ResourceLocation("hbm:textures/gui/gauges/small_bar.png"), 36, 12, 16);

        ResourceLocation texture;
        int width;
        int height;
        int count;

        private Gauge(ResourceLocation texture, int width, int height, int count) {
            this.texture = texture;
            this.width = width;
            this.height = height;
            this.count = count;
        }
    }
}

