/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.factory;

import com.hbm.entity.effect.EntityFireLingering;
import com.hbm.entity.logic.EntityC130;
import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.Crosshair;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.items.weapon.sedna.factory.Lego;
import com.hbm.items.weapon.sedna.factory.Orchestras;
import com.hbm.items.weapon.sedna.mags.MagazineSingleReload;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.particle.SpentCasing;
import com.hbm.render.anim.AnimationEnums;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.EntityDamageUtil;
import com.hbm.util.TrackerUtil;
import com.hbm.world.WorldUtil;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class XFactory40mm {
    public static BulletConfig g26_flare;
    public static BulletConfig g26_flare_supply;
    public static BulletConfig g26_flare_weapon;
    public static BulletConfig g40_he;
    public static BulletConfig g40_heat;
    public static BulletConfig g40_demo;
    public static BulletConfig g40_inc;
    public static BulletConfig g40_phosphorus;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_IGNITE;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_HEAT;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_DEMO;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_INC;
    public static BiConsumer<EntityBulletBaseMK4, MovingObjectPosition> LAMBDA_STANDARD_EXPLODE_PHOSPHORUS;
    public static Consumer<Entity> LAMBDA_SPAWN_C130_SUPPLIESS;
    public static Consumer<Entity> LAMBDA_SPAWN_C130_WEAPONS;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_SMOKE;
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_RECOIL_GL;
    public static BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> LAMBDA_FLAREGUN_ANIMS;
    public static BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> LAMBDA_CONGOLAKE_ANIMS;

    public static void spawnFire(EntityBulletBaseMK4 bullet, MovingObjectPosition mop, boolean phosphorus, int duration) {
        MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
            return;
        }
        World world = bullet.field_70170_p;
        Lego.standardExplode(bullet, mop, 3.0f);
        EntityFireLingering fire = new EntityFireLingering(world).setArea(5.0f, 2.0f).setDuration(duration).setType(phosphorus ? EntityFireLingering.TYPE_PHOSPHORUS : EntityFireLingering.TYPE_DIESEL);
        fire.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
        world.func_72838_d((Entity)fire);
        bullet.func_70106_y();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                block2: for (int dz = -1; dz <= 1; ++dz) {
                    int z;
                    int y;
                    int x = (int)Math.floor(mop.field_72307_f.field_72450_a) + dx;
                    if (!world.func_147439_a(x, y = (int)Math.floor(mop.field_72307_f.field_72448_b) + dy, z = (int)Math.floor(mop.field_72307_f.field_72449_c) + dz).isAir((IBlockAccess)bullet.field_70170_p, x, y, z)) continue;
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (!world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isFlammable((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite())) continue;
                        world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                        continue block2;
                    }
                }
            }
        }
    }

    public static void spawnPlane(Entity entity, EntityC130.C130PayloadType payload) {
        if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa == 40) {
            EntityBulletBaseMK4 bullet = (EntityBulletBaseMK4)entity;
            if (bullet.getThrower() != null) {
                bullet.field_70170_p.func_72956_a((Entity)bullet.getThrower(), "hbm:item.techBleep", 1.0f, 1.0f);
            }
            EntityC130 c130 = new EntityC130(bullet.field_70170_p);
            int x = (int)Math.floor(bullet.field_70165_t);
            int z = (int)Math.floor(bullet.field_70161_v);
            int y = bullet.field_70170_p.func_72976_f(x, z);
            c130.fac(bullet.field_70170_p, x, y, z, payload);
            WorldUtil.loadAndSpawnEntityInWorld(c130);
            TrackerUtil.setTrackingRange(bullet.field_70170_p, c130, 250);
        }
    }

    public static void init() {
        g26_flare = new BulletConfig().setItem(GunFactory.EnumAmmo.G26_FLARE).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setLife(100).setVel(2.0f).setGrav(0.015).setRenderRotations(false).setOnImpact(LAMBDA_STANDARD_IGNITE).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(10360342).setScale(2.0f).register("g26Flare"));
        g26_flare_supply = new BulletConfig().setItem(GunFactory.EnumAmmo.G26_FLARE_SUPPLY).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setLife(100).setVel(2.0f).setGrav(0.015).setRenderRotations(false).setOnImpact(LAMBDA_STANDARD_IGNITE).setOnUpdate(LAMBDA_SPAWN_C130_SUPPLIESS).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(3965168).setScale(2.0f).register("g26FlareSupply"));
        g26_flare_weapon = new BulletConfig().setItem(GunFactory.EnumAmmo.G26_FLARE_WEAPON).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setLife(100).setVel(2.0f).setGrav(0.015).setRenderRotations(false).setOnImpact(LAMBDA_STANDARD_IGNITE).setOnUpdate(LAMBDA_SPAWN_C130_WEAPONS).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(2589696).setScale(2.0f).register("g26FlareWeapon"));
        BulletConfig g40_base = new BulletConfig().setLife(200).setVel(2.0f).setGrav(0.035);
        g40_he = g40_base.clone().setItem(GunFactory.EnumAmmo.G40_HE).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setOnImpact(LAMBDA_STANDARD_EXPLODE).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(0x777777).setScale(2.0f, 2.0f, 1.5f).register("g40"));
        g40_heat = g40_base.clone().setItem(GunFactory.EnumAmmo.G40_HEAT).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setOnImpact(LAMBDA_STANDARD_EXPLODE_HEAT).setDamage(0.5f).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(6187092).setScale(2.0f, 2.0f, 1.5f).register("g40heat"));
        g40_demo = g40_base.clone().setItem(GunFactory.EnumAmmo.G40_DEMO).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setOnImpact(LAMBDA_STANDARD_EXPLODE_DEMO).setDamage(0.75f).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(0xE30000).setScale(2.0f, 2.0f, 1.5f).register("g40demo"));
        g40_inc = g40_base.clone().setItem(GunFactory.EnumAmmo.G40_INC).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setOnImpact(LAMBDA_STANDARD_EXPLODE_INC).setDamage(0.75f).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(15232800).setScale(2.0f, 2.0f, 1.5f).register("g40inc"));
        g40_phosphorus = g40_base.clone().setItem(GunFactory.EnumAmmo.G40_PHOSPHORUS).setCasing(ItemEnums.EnumCasingType.LARGE, 4).setOnImpact(LAMBDA_STANDARD_EXPLODE_PHOSPHORUS).setDamage(0.75f).setCasing(new SpentCasing(SpentCasing.CasingType.STRAIGHT).setColor(0xC8C8C8).setScale(2.0f, 2.0f, 1.5f).register("g40phos"));
        ModItems.gun_flaregun = new ItemGunBaseNT(ItemGunBaseNT.WeaponQuality.A_SIDE, new GunConfig().dura(100.0f).draw(7).inspect(39).crosshair(Crosshair.L_CIRCUMFLEX).smoke(LAMBDA_SMOKE).rec(new Receiver(0).dmg(15.0f).delay(20).reload(28).jam(33).sound("hbm:weapon.hkShoot", 1.0f, 1.0f).mag(new MagazineSingleReload(0, 1).addConfigs(g26_flare, g26_flare_supply, g26_flare_weapon)).offset(0.75, -0.0625, -0.1875).setupStandardFire().recoil(LAMBDA_RECOIL_GL)).setupStandardConfiguration().anim(LAMBDA_FLAREGUN_ANIMS).orchestra(Orchestras.ORCHESTRA_FLAREGUN)).func_77655_b("gun_flaregun");
        ModItems.gun_congolake = new ItemGunBaseNT(ItemGunBaseNT.WeaponQuality.A_SIDE, new GunConfig().dura(400.0f).draw(7).inspect(39).reloadSequential(true).reloadChangeType(true).crosshair(Crosshair.L_CIRCUMFLEX).smoke(LAMBDA_SMOKE).rec(new Receiver(0).dmg(20.0f).delay(24).reload(16, 16, 16, 0).jam(0).sound("hbm:weapon.glShoot", 1.0f, 1.0f).mag(new MagazineSingleReload(0, 4).addConfigs(g40_he, g40_heat, g40_demo, g40_inc, g40_phosphorus)).offset(0.75, -0.0625, -0.1875).setupStandardFire().recoil(LAMBDA_RECOIL_GL)).setupStandardConfiguration().anim(LAMBDA_CONGOLAKE_ANIMS).orchestra(Orchestras.ORCHESTRA_CONGOLAKE)).func_77655_b("gun_congolake");
    }

    static {
        LAMBDA_STANDARD_IGNITE = (bullet, mop) -> {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                HbmLivingProps props = HbmLivingProps.getData((EntityLivingBase)mop.field_72308_g);
                props.fire += 200;
            }
        };
        LAMBDA_STANDARD_EXPLODE = (bullet, mop) -> {
            Lego.standardExplode(bullet, mop, 5.0f);
            bullet.func_70106_y();
        };
        LAMBDA_STANDARD_EXPLODE_HEAT = (bullet, mop) -> {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
                return;
            }
            Lego.standardExplode(bullet, mop, 3.5f);
            bullet.func_70106_y();
            MovingObjectPosition.MovingObjectType cfr_ignored_1 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)mop.field_72308_g;
                BulletConfig cfr_ignored_2 = bullet.config;
                EntityDamageUtil.attackEntityFromNT(living, BulletConfig.getDamage(bullet, bullet.getThrower(), DamageResistanceHandler.DamageClass.EXPLOSIVE), bullet.damage * 3.0f, true, true, 0.5, 3.0f, 0.15f);
            } else {
                MovingObjectPosition.MovingObjectType cfr_ignored_3 = mop.field_72313_a;
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    BulletConfig cfr_ignored_4 = bullet.config;
                    mop.field_72308_g.func_70097_a(BulletConfig.getDamage(bullet, bullet.getThrower(), DamageResistanceHandler.DamageClass.EXPLOSIVE), bullet.damage * 3.0f);
                }
            }
        };
        LAMBDA_STANDARD_EXPLODE_DEMO = (bullet, mop) -> {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && bullet.field_70173_aa < 3) {
                return;
            }
            ExplosionVNT vnt = new ExplosionVNT(bullet.field_70170_p, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 5.0f, (Entity)bullet.getThrower());
            vnt.setBlockAllocator(new BlockAllocatorStandard());
            vnt.setBlockProcessor(new BlockProcessorStandard());
            vnt.setEntityProcessor(new EntityProcessorCrossSmooth(1.0, bullet.damage));
            vnt.setPlayerProcessor(new PlayerProcessorStandard());
            vnt.setSFX(new ExplosionEffectWeapon(10, 2.5f, 1.0f));
            vnt.explode();
            bullet.func_70106_y();
        };
        LAMBDA_STANDARD_EXPLODE_INC = (bullet, mop) -> XFactory40mm.spawnFire(bullet, mop, false, 200);
        LAMBDA_STANDARD_EXPLODE_PHOSPHORUS = (bullet, mop) -> XFactory40mm.spawnFire(bullet, mop, true, 400);
        LAMBDA_SPAWN_C130_SUPPLIESS = entity -> XFactory40mm.spawnPlane(entity, EntityC130.C130PayloadType.SUPPLIES);
        LAMBDA_SPAWN_C130_WEAPONS = entity -> XFactory40mm.spawnPlane(entity, EntityC130.C130PayloadType.WEAPONS);
        LAMBDA_SMOKE = (stack, ctx) -> Lego.handleStandardSmoke(ctx.entity, stack, 1500, 0.025, 1.05, 0);
        LAMBDA_RECOIL_GL = (stack, ctx) -> ItemGunBaseNT.setupRecoil(10.0f, (float)(ctx.getPlayer().func_70681_au().nextGaussian() * 1.5));
        LAMBDA_FLAREGUN_ANIMS = (stack, type) -> {
            switch (type) {
                case EQUIP: {
                    return new BusAnimation().addBus("EQUIP", new BusAnimationSequence().addPos(-90.0, 0.0, 0.0, 0).addPos(0.0, 0.0, 0.0, 350, BusAnimationKeyframe.IType.SIN_DOWN));
                }
                case CYCLE: {
                    return new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 50).addPos(0.0, 0.0, -3.0, 50).addPos(0.0, 0.0, 0.0, 250)).addBus("HAMMER", new BusAnimationSequence().addPos(15.0, 0.0, 0.0, 50).addPos(15.0, 0.0, 0.0, 550).addPos(0.0, 0.0, 0.0, 100));
                }
                case CYCLE_DRY: {
                    return new BusAnimation().addBus("HAMMER", new BusAnimationSequence().addPos(15.0, 0.0, 0.0, 50).addPos(15.0, 0.0, 0.0, 550).addPos(0.0, 0.0, 0.0, 100));
                }
                case RELOAD: {
                    return new BusAnimation().addBus("OPEN", new BusAnimationSequence().addPos(45.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_FULL).addPos(45.0, 0.0, 0.0, 750).addPos(0.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_UP)).addBus("SHELL", new BusAnimationSequence().addPos(4.0, -8.0, -4.0, 0).addPos(4.0, -8.0, -4.0, 200).addPos(0.0, 0.0, -5.0, 500, BusAnimationKeyframe.IType.SIN_DOWN).addPos(0.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_UP)).addBus("FLIP", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 200).addPos(25.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_DOWN).addPos(25.0, 0.0, 0.0, 800).addPos(0.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_DOWN));
                }
                case JAMMED: {
                    return new BusAnimation().addBus("OPEN", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 500).addPos(45.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_FULL).addPos(45.0, 0.0, 0.0, 500).addPos(0.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_UP)).addBus("FLIP", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 500).addPos(0.0, 0.0, 0.0, 200).addPos(25.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_DOWN).addPos(25.0, 0.0, 0.0, 550).addPos(0.0, 0.0, 0.0, 200, BusAnimationKeyframe.IType.SIN_DOWN));
                }
                case INSPECT: {
                    return new BusAnimation().addBus("FLIP", new BusAnimationSequence().addPos(-1080.0, 0.0, 0.0, 1500, BusAnimationKeyframe.IType.SIN_FULL));
                }
            }
            return null;
        };
        LAMBDA_CONGOLAKE_ANIMS = (stack, type) -> {
            int ammo = ((ItemGunBaseNT)stack.func_77973_b()).getConfig((ItemStack)stack, 0).getReceivers((ItemStack)stack)[0].getMagazine((ItemStack)stack).getAmount((ItemStack)stack, (IInventory)MainRegistry.proxy.me().field_71071_by);
            switch (type) {
                case EQUIP: {
                    return ResourceManager.congolake_anim.get("Equip");
                }
                case CYCLE: {
                    return ResourceManager.congolake_anim.get(ammo <= 1 ? "FireEmpty" : "Fire");
                }
                case RELOAD: {
                    return ResourceManager.congolake_anim.get(ammo == 0 ? "ReloadEmpty" : "ReloadStart");
                }
                case RELOAD_CYCLE: {
                    return ResourceManager.congolake_anim.get("Reload");
                }
                case RELOAD_END: {
                    return ResourceManager.congolake_anim.get("ReloadEnd");
                }
                case JAMMED: {
                    return ResourceManager.congolake_anim.get("Jammed");
                }
                case INSPECT: {
                    return ResourceManager.congolake_anim.get("Inspect");
                }
            }
            return null;
        };
    }
}

