/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.item.IGasMask;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.main.MainRegistry;
import com.hbm.render.model.ModelM65;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class ItemModGasmask
extends ItemArmorMod
implements IGasMask {
    private ModelM65 modelM65;
    private ResourceLocation tex = new ResourceLocation("hbm:textures/models/ModelM65.png");
    private ResourceLocation tex_mono = new ResourceLocation("hbm:textures/models/ModelM65Mono.png");

    public ItemModGasmask() {
        super(0, true, false, false, false);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.GREEN + "Gas protection");
        list.add("");
        super.func_77624_a(stack, player, list, bool);
        ArmorUtil.addGasMaskTooltip(stack, player, list, bool);
        ArrayList<ArmorRegistry.HazardClass> haz = this.getBlacklist(stack, (EntityLivingBase)player);
        if (!haz.isEmpty()) {
            list.add(EnumChatFormatting.RED + "Will never protect against:");
            for (ArmorRegistry.HazardClass clazz : haz) {
                list.add(EnumChatFormatting.DARK_RED + " -" + I18nUtil.resolveKey(clazz.lang, new Object[0]));
            }
        }
    }

    @Override
    public void addDesc(List list, ItemStack stack, ItemStack armor) {
        list.add(EnumChatFormatting.GREEN + "  " + stack.func_82833_r() + " (gas protection)");
        ArmorUtil.addGasMaskTooltip(stack, MainRegistry.proxy.me(), list, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modRender(RenderPlayerEvent.SetArmorModel event, ItemStack armor) {
        if (this.modelM65 == null) {
            this.modelM65 = new ModelM65();
        }
        RenderPlayer renderer = event.renderer;
        ModelBiped model = renderer.field_77111_i;
        EntityPlayer player = event.entityPlayer;
        this.modelM65.field_78117_n = model.field_78117_n;
        this.modelM65.field_78091_s = renderer.field_77109_a.field_78091_s;
        float interp = event.partialRenderTick;
        float yawHead = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * interp;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * interp;
        float yaw = yawHead - yawOffset;
        float yawWrapped = MathHelper.func_76142_g((float)(yawHead - yawOffset));
        float pitch = player.field_70125_A;
        if (this == ModItems.attachment_mask) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.tex);
        }
        if (this == ModItems.attachment_mask_mono) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.tex_mono);
        }
        this.modelM65.func_78088_a((Entity)event.entityPlayer, 0.0f, 0.0f, yawWrapped, yaw, pitch, 0.0625f);
    }

    @Override
    public ArrayList<ArmorRegistry.HazardClass> getBlacklist(ItemStack stack, EntityLivingBase entity) {
        if (this == ModItems.attachment_mask_mono) {
            return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.BACTERIA));
        }
        return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_BLISTERING));
    }

    @Override
    public ItemStack getFilter(ItemStack stack, EntityLivingBase entity) {
        return ArmorUtil.getGasMaskFilter(stack);
    }

    @Override
    public void installFilter(ItemStack stack, EntityLivingBase entity, ItemStack filter) {
        ArmorUtil.installGasMaskFilter(stack, filter);
    }

    @Override
    public void damageFilter(ItemStack stack, EntityLivingBase entity, int damage) {
        ArmorUtil.damageGasMaskFilter(stack, damage);
    }

    @Override
    public boolean isFilterApplicable(ItemStack stack, EntityLivingBase entity, ItemStack filter) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack filter;
        if (player.func_70093_af() && (filter = this.getFilter(stack, (EntityLivingBase)player)) != null) {
            ArmorUtil.removeFilter(stack);
            if (!player.field_71071_by.func_70441_a(filter)) {
                player.func_71019_a(filter, true);
            }
        }
        return super.func_77659_a(stack, world, player);
    }
}

