/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.orbit;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SkyProviderCelestial;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.lib.Library;
import com.hbm.util.BobMathUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SkyProviderOrbit
extends SkyProviderCelestial {
    private static CelestialBody lastBody;

    @Override
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        WorldProviderOrbit provider = (WorldProviderOrbit)world.field_73011_w;
        OrbitalStation station = OrbitalStation.clientStation;
        double progress = station.getTransferProgress(partialTicks);
        float orbitalTilt = 80.0f;
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float solarAngle = this.getCelestialAngle(world, provider.metrics, partialTicks, station);
        float siderealAngle = (float)SolarSystem.calculateSiderealAngle((World)world, partialTicks, station.orbiting);
        float celestialPhase = (1.0f - (solarAngle + 0.5f) % 1.0f) * 2.0f - 1.0f;
        float starBrightness = world.func_72880_h(partialTicks);
        this.renderStars(partialTicks, world, mc, starBrightness, solarAngle + siderealAngle, orbitalTilt);
        GL11.glPushMatrix();
        GL11.glRotatef((float)orbitalTilt, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(solarAngle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderDigamma(partialTicks, world, mc, solarAngle);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        double sunSize = SolarSystem.calculateSunSize(station.orbiting) * 4.0;
        if (station.state != OrbitalStation.StationState.ORBIT) {
            double sunTargetSize = SolarSystem.calculateSunSize(station.target) * 4.0;
            sunSize = BobMathUtil.lerp(progress, sunSize, sunTargetSize);
        }
        double coronaSize = sunSize * (3.0 - Library.smoothstep((double)Math.abs(celestialPhase), 0.7, 0.8));
        this.renderSun(partialTicks, world, mc, station.orbiting.getStar(), sunSize, coronaSize, 1.0f, 0.0f);
        CelestialBody orbiting = station.orbiting;
        if (station.state != OrbitalStation.StationState.ORBIT && progress > 0.5) {
            orbiting = station.target;
        }
        this.renderCelestials(partialTicks, world, mc, provider.metrics, solarAngle, null, Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), 1.0f, 1.0f, orbiting, 160.0f);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    private float getCelestialAngle(WorldClient world, List<SolarSystem.AstroMetric> metrics, float partialTicks, OrbitalStation station) {
        float solarAngle = world.func_72826_c(partialTicks);
        if (station.state == OrbitalStation.StationState.ORBIT) {
            return solarAngle;
        }
        solarAngle = solarAngle * 360.0f - 180.0f;
        if (station.state != OrbitalStation.StationState.ARRIVING) {
            lastBody = station.orbiting;
        }
        double progress = station.getUnscaledProgress(partialTicks);
        float travelAngle = -((float)SolarSystem.calculateSingleAngle(metrics, lastBody, station.target));
        travelAngle = MathHelper.func_76142_g((float)(travelAngle + 90.0f));
        if (station.state == OrbitalStation.StationState.TRANSFER) {
            return (travelAngle + 180.0f) / 360.0f;
        }
        if (station.state == OrbitalStation.StationState.LEAVING) {
            return ((float)BobMathUtil.clerp(progress, solarAngle, travelAngle) + 180.0f) / 360.0f;
        }
        return ((float)BobMathUtil.clerp(progress, travelAngle, solarAngle) + 180.0f) / 360.0f;
    }
}

