/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.laythe;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.ChunkProviderCelestial;
import com.hbm.dim.laythe.biome.BiomeGenBaseLaythe;
import com.hbm.dim.mapgen.MapGenGreg;
import com.hbm.dim.mapgen.MapGenTiltedSpires;
import com.hbm.entity.mob.EntityCreeperFlesh;
import com.hbm.world.gen.terrain.MapGenBubble;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ChunkProviderLaythe
extends ChunkProviderCelestial {
    private MapGenGreg caveGenV3 = new MapGenGreg();
    private MapGenTiltedSpires spires = new MapGenTiltedSpires(2, 14, 0.75f);
    private MapGenTiltedSpires snowires = new MapGenTiltedSpires(2, 14, 0.75f);
    private MapGenBubble oil = new MapGenBubble(WorldConfig.laytheOilSpawn);
    private List<BiomeGenBase.SpawnListEntry> spawnedOfFlesh = new ArrayList<BiomeGenBase.SpawnListEntry>();

    public ChunkProviderLaythe(World world, long seed, boolean hasMapFeatures) {
        super(world, seed, hasMapFeatures);
        this.snowires.rock = Blocks.field_150403_cj;
        this.snowires.regolith = Blocks.field_150433_aE;
        this.spires.rock = Blocks.field_150348_b;
        this.spires.regolith = ModBlocks.laythe_silt;
        this.snowires.curve = true;
        this.spires.curve = true;
        this.snowires.maxPoint = 6.0f;
        this.spires.maxPoint = 6.0f;
        this.snowires.maxTilt = 3.5f;
        this.spires.maxTilt = 3.5f;
        this.oil.block = ModBlocks.ore_oil;
        this.oil.meta = (byte)CelestialBody.getMeta(world);
        this.oil.replace = Blocks.field_150348_b;
        this.oil.setSize(8, 16);
        this.seaBlock = Blocks.field_150355_j;
        this.spawnedOfFlesh.add(new BiomeGenBase.SpawnListEntry(EntityCreeperFlesh.class, 10, 4, 4));
    }

    @Override
    public ChunkProviderCelestial.BlockMetaBuffer getChunkPrimer(int x, int z) {
        ChunkProviderCelestial.BlockMetaBuffer buffer = super.getChunkPrimer(x, z);
        this.oil.setMetas(buffer.metas);
        if (this.biomesForGeneration[0] == BiomeGenBaseLaythe.laythePolar) {
            this.snowires.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        } else {
            this.spires.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        this.caveGenV3.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        this.oil.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        return buffer;
    }

    @Override
    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        if (creatureType == EnumCreatureType.monster && this.worldObj.func_147439_a(x, y - 1, z) == ModBlocks.tumor) {
            return this.spawnedOfFlesh;
        }
        return super.func_73155_a(creatureType, x, y, z);
    }
}

