/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.dim.CelestialBody;
import com.hbm.inventory.material.Mats;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityMachineMagma;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineMagma
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider {
    public MachineMagma() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineMagma();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().power().fluid();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{3, 3, 3, 3, 3, 3};
    }

    @Override
    public int getOffset() {
        return 3;
    }

    @Override
    public int getHeightOffset() {
        return 3;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x += dir.offsetX * o) - dir.offsetX * 3, (y += dir.offsetY * o) - 1, (z += dir.offsetZ * o) - dir.offsetZ * 3);
        this.makeExtra(world, x - dir.offsetX * 3, y - 2, z - dir.offsetZ * 3);
        this.makeExtra(world, x - dir.offsetX * 3 + rot.offsetX, y - 1, z - dir.offsetZ * 3 + rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 3 - rot.offsetX, y - 1, z - dir.offsetZ * 3 - rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 3 + rot.offsetX, y - 2, z - dir.offsetZ * 3 + rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 3 - rot.offsetX, y - 2, z - dir.offsetZ * 3 - rot.offsetZ);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityMachineMagma)) {
            return;
        }
        TileEntityMachineMagma drill = (TileEntityMachineMagma)te;
        ArrayList<String> text = new ArrayList<String>();
        CelestialBody body = CelestialBody.getBody(world);
        if (body.name != "moho") {
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! MUST BE ON MOHO ! ! !");
        } else if (!drill.validPosition) {
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! INSUFFICIENT LAVA FOUND ! ! !");
        } else {
            text.add((drill.power < drill.consumption ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + "Power: " + BobMathUtil.getShortNumber(drill.power) + "HE");
            for (int i = 0; i < drill.tanks.length; ++i) {
                text.add((i == 0 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + drill.tanks[i].getTankType().getLocalizedName() + ": " + drill.tanks[i].getFill() + "/" + drill.tanks[i].getMaxFill() + "mB");
            }
            for (Mats.MaterialStack sta : drill.liquids) {
                text.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey(sta.material.getUnlocalizedName(), new Object[0]) + ": " + Mats.formatAmount(sta.amount, false));
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

