/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.machine.ItemScraps;
import com.hbm.render.icon.RGBMutatorInterpolatedComponentRemap;
import com.hbm.render.icon.TextureAtlasSpriteMutatable;
import com.hbm.util.Compat;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDynamicSlag
extends BlockContainer {
    private HashMap<NTMMaterial, IIcon> iconMap = new HashMap();

    public BlockDynamicSlag() {
        super(Material.field_151573_f);
        this.field_149783_u = true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySlag();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        if (reg instanceof TextureMap) {
            TextureMap map = (TextureMap)reg;
            for (NTMMaterial mat : Mats.orderedList) {
                if (mat.solidColorLight == mat.solidColorDark) continue;
                String placeholderName = this.func_149641_N() + "-" + mat.names[0];
                TextureAtlasSpriteMutatable mutableIcon = new TextureAtlasSpriteMutatable(placeholderName, new RGBMutatorInterpolatedComponentRemap(0xFFFFFF, 0x505050, mat.solidColorLight, mat.solidColorDark)).setBlockAtlas();
                map.setTextureEntry(placeholderName, (TextureAtlasSprite)mutableIcon);
                this.iconMap.put(mat, (IIcon)mutableIcon);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        IIcon override;
        TileEntitySlag tile = (TileEntitySlag)world.func_147438_o(x, y, z);
        if (tile != null && tile.mat != null && (override = this.iconMap.get(tile.mat)) != null) {
            return override;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntitySlag tile = (TileEntitySlag)world.func_147438_o(x, y, z);
        if (tile != null && tile.mat != null && !this.iconMap.containsKey(tile.mat)) {
            return tile.mat.moltenColor;
        }
        return 0xFFFFFF;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntitySlag tile = (TileEntitySlag)world.func_147438_o(x, y, z);
        if (tile != null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, (float)tile.amount / (float)TileEntitySlag.maxAmount, 1.0f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TileEntitySlag tile = (TileEntitySlag)world.func_147438_o(x, y, z);
        if (tile != null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, (float)tile.amount / (float)TileEntitySlag.maxAmount, 1.0f);
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileEntity s = Compat.getTileStandard(world, x, y, z);
        TileEntity b = Compat.getTileStandard(world, x, y - 1, z);
        if (s == null || !(s instanceof TileEntitySlag)) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileEntitySlag self = (TileEntitySlag)s;
        if (world.func_147439_a(x, y - 1, z).isReplaceable((IBlockAccess)world, x, y - 1, z) && y > 0) {
            world.func_147449_b(x, y - 1, z, ModBlocks.slag);
            TileEntitySlag tile = (TileEntitySlag)Compat.getTileStandard(world, x, y - 1, z);
            tile.mat = self.mat;
            tile.amount = self.amount;
            world.func_147471_g(x, y - 1, z);
            world.func_147468_f(x, y, z);
            return;
        }
        if (b instanceof TileEntitySlag) {
            TileEntitySlag below = (TileEntitySlag)b;
            if (below.mat == self.mat && below.amount < TileEntitySlag.maxAmount) {
                int transfer = Math.min(TileEntitySlag.maxAmount - below.amount, self.amount);
                below.amount += transfer;
                self.amount -= transfer;
                if (self.amount <= 0) {
                    world.func_147468_f(x, y, z);
                } else {
                    world.func_147471_g(x, y, z);
                }
                world.func_147471_g(x, y - 1, z);
                world.func_147464_a(x, y - 1, z, ModBlocks.slag, 1);
                return;
            }
        }
        ForgeDirection[] sides = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
        int count = 0;
        for (ForgeDirection dir : sides) {
            int iX = x + dir.offsetX;
            int iZ = z + dir.offsetZ;
            if (!world.func_147439_a(iX, y, iZ).isReplaceable((IBlockAccess)world, iX, y, iZ)) continue;
            ++count;
        }
        if (self.amount >= TileEntitySlag.maxAmount / 5 && count > 0) {
            int toSpread = Math.max(self.amount / (count * 2), 1);
            for (ForgeDirection dir : sides) {
                int iX = x + dir.offsetX;
                int iZ = z + dir.offsetZ;
                if (!world.func_147439_a(iX, y, iZ).isReplaceable((IBlockAccess)world, iX, y, iZ)) continue;
                world.func_147449_b(iX, y, iZ, ModBlocks.slag);
                TileEntitySlag tile = (TileEntitySlag)Compat.getTileStandard(world, iX, y, iZ);
                world.func_147471_g(iX, y, iZ);
                world.func_147464_a(iX, y, iZ, ModBlocks.slag, 1);
                tile.mat = self.mat;
                tile.amount = toSpread;
                self.amount -= toSpread;
                world.func_147471_g(x, y, z);
            }
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.harvesters.set(player);
            this.func_149697_b(world, x, y, z, meta, 0);
            this.harvesters.set(null);
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[BlockDynamicSlag.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntitySlag tile = (TileEntitySlag)world.func_147438_o(x, y, z);
        if (tile != null && tile.mat != null && tile.amount > 0) {
            ret.add(ItemScraps.create(new Mats.MaterialStack(tile.mat, tile.amount)));
        }
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntitySlag tile = (TileEntitySlag)world.func_147438_o(x, y, z);
        if (tile != null) {
            return ItemScraps.create(new Mats.MaterialStack(tile.mat, tile.amount));
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public static class TileEntitySlag
    extends TileEntity {
        public NTMMaterial mat;
        public int amount;
        public static int maxAmount = MaterialShapes.BLOCK.q(16);

        public boolean canUpdate() {
            return false;
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.mat = Mats.matById.get(nbt.func_74762_e("mat"));
            this.amount = nbt.func_74762_e("amount");
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            if (this.mat != null) {
                nbt.func_74768_a("mat", this.mat.id);
            }
            nbt.func_74768_a("amount", this.amount);
        }
    }
}

