/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.config.ServerConfig;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockAllocatorWater;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.factory.XFactoryCatapult;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.bomb.TileEntityLandmine;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class Landmine
extends BlockContainer
implements IBomb {
    public static boolean safeMode = false;
    public double range;
    public double height;

    public Landmine(Material mat, double range, double height) {
        super(mat);
        this.range = range;
        this.height = height;
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityLandmine();
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public Item func_149650_a(int i, Random rand, int j) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float f = 0.0625f;
        if (this == ModBlocks.mine_ap) {
            this.func_149676_a(5.0f * f, 0.0f, 5.0f * f, 11.0f * f, 1.0f * f, 11.0f * f);
        }
        if (this == ModBlocks.mine_he) {
            this.func_149676_a(4.0f * f, 0.0f, 4.0f * f, 12.0f * f, 2.0f * f, 12.0f * f);
        }
        if (this == ModBlocks.mine_shrap) {
            this.func_149676_a(5.0f * f, 0.0f, 5.0f * f, 11.0f * f, 1.0f * f, 11.0f * f);
        }
        if (this == ModBlocks.mine_fat) {
            this.func_149676_a(5.0f * f, 0.0f, 4.0f * f, 11.0f * f, 6.0f * f, 12.0f * f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || BlockFence.func_149825_a((Block)world.func_147439_a(x, y - 1, z));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (world.func_72864_z(x, y, z)) {
            this.explode(world, x, y, z);
        }
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !BlockFence.func_149825_a((Block)world.func_147439_a(x, y - 1, z))) {
            if (!safeMode) {
                this.explode(world, x, y, z);
            } else {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        if (!safeMode) {
            this.explode(world, x, y, z);
        }
        super.func_149664_b(world, x, y, z, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float fx, float fy, float fz) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.defuser) {
            safeMode = true;
            world.func_147468_f(x, y, z);
            ItemStack itemstack = new ItemStack((Block)this, 1);
            float f = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
            float f1 = world.field_73012_v.nextFloat() * 0.2f;
            float f2 = world.field_73012_v.nextFloat() * 0.6f + 0.2f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1 + 1.0f), (double)((float)z + f2), itemstack);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityitem);
            }
            safeMode = false;
            return true;
        }
        return false;
    }

    public boolean isWaterAbove(World world, int x, int y, int z) {
        for (int xo = -1; xo <= 1; ++xo) {
            for (int zo = -1; zo <= 1; ++zo) {
                Block blockAbove = world.func_147439_a(x + xo, y + 1, z + zo);
                if (blockAbove != Blocks.field_150355_j && blockAbove != Blocks.field_150358_i) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IBomb.BombReturnCode explode(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            safeMode = true;
            world.func_147480_a(x, y, z, false);
            safeMode = false;
            if (this == ModBlocks.mine_ap) {
                ExplosionVNT vnt = new ExplosionVNT(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
                vnt.setEntityProcessor(new EntityProcessorCrossSmooth(0.5, ServerConfig.MINE_AP_DAMAGE.get().floatValue()).setupPiercing(5.0f, 0.2f));
                vnt.setPlayerProcessor(new PlayerProcessorStandard());
                vnt.setSFX(new ExplosionEffectWeapon(5, 1.0f, 0.5f));
                vnt.explode();
            } else if (this == ModBlocks.mine_he) {
                ExplosionVNT vnt = new ExplosionVNT(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 4.0f);
                vnt.setBlockAllocator(new BlockAllocatorStandard());
                vnt.setBlockProcessor(new BlockProcessorStandard());
                vnt.setEntityProcessor(new EntityProcessorCrossSmooth(1.0, ServerConfig.MINE_HE_DAMAGE.get().floatValue()).setupPiercing(15.0f, 0.2f));
                vnt.setPlayerProcessor(new PlayerProcessorStandard());
                vnt.setSFX(new ExplosionEffectWeapon(15, 3.5f, 1.25f));
                vnt.explode();
            } else if (this == ModBlocks.mine_shrap) {
                ExplosionVNT vnt = new ExplosionVNT(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
                vnt.setEntityProcessor(new EntityProcessorCrossSmooth(0.5, ServerConfig.MINE_SHRAP_DAMAGE.get().floatValue()));
                vnt.setPlayerProcessor(new PlayerProcessorStandard());
                vnt.setSFX(new ExplosionEffectWeapon(5, 1.0f, 0.5f));
                vnt.explode();
                ExplosionLarge.spawnShrapnelShower(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 1.0, 0.0, 45, 0.2);
                ExplosionLarge.spawnShrapnels(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 5);
            } else if (this == ModBlocks.mine_naval) {
                ExplosionVNT vnt = new ExplosionVNT(world, x + 5, y + 5, z + 5, 25.0f);
                vnt.setBlockAllocator(new BlockAllocatorWater(32));
                vnt.setBlockProcessor(new BlockProcessorStandard());
                vnt.setEntityProcessor(new EntityProcessorCrossSmooth(0.5, ServerConfig.MINE_NAVAL_DAMAGE.get().floatValue()).setupPiercing(5.0f, 0.2f));
                vnt.setPlayerProcessor(new PlayerProcessorStandard());
                vnt.setSFX(new ExplosionEffectWeapon(10, 1.0f, 0.5f));
                vnt.explode();
                ExplosionLarge.spawnParticlesRadial(world, (double)x + 0.5, y + 2, (double)z + 0.5, 30);
                ExplosionLarge.spawnRubble(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 5);
                if (this.isWaterAbove(world, x, y, z)) {
                    ExplosionLarge.spawnFoam(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 60);
                }
            } else if (this == ModBlocks.mine_fat) {
                ExplosionVNT vnt = new ExplosionVNT(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 10.0f);
                vnt.setBlockAllocator(new BlockAllocatorStandard(64));
                vnt.setBlockProcessor(new BlockProcessorStandard());
                vnt.setEntityProcessor(new EntityProcessorCrossSmooth(2.0, ServerConfig.MINE_NUKE_DAMAGE.get().floatValue()).withRangeMod(1.5f));
                vnt.setPlayerProcessor(new PlayerProcessorStandard());
                vnt.explode();
                XFactoryCatapult.incrementRad(world, x, y, z, 1.5f);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "muke");
                data.func_74757_a("balefire", MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0);
                PacketDispatcher.wrapper.sendToAllAround(new AuxParticlePacketNT(data, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 250.0));
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:weapon.mukeExplosion", 25.0f, 0.9f);
            }
        }
        return IBomb.BombReturnCode.DETONATED;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        if (!world.field_72995_K && GeneralConfig.enableExtendedLogging) {
            MainRegistry.logger.log(Level.INFO, "[BOMBPL]" + this.func_149732_F() + " placed at " + x + " / " + y + " / " + z + "! by " + player.func_70005_c_());
        }
    }
}

