/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.ui.fullscreen.layer.BlockInfoLayer;
import journeymap.client.ui.fullscreen.layer.WaypointLayer;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;

public class LayerDelegate {
    private List<DrawStep> drawSteps = new ArrayList<DrawStep>();
    private List<Layer> layers = new ArrayList<Layer>();

    public LayerDelegate() {
        this.layers.add(new BlockInfoLayer());
        this.layers.add(new WaypointLayer());
    }

    public void onMouseMove(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord) {
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseMove(mc, mouseX, mouseY, gridWidth, gridHeight, blockCoord));
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public void onMouseClicked(Minecraft mc, double mouseX, double mouseY, int gridWidth, int gridHeight, BlockCoordIntPair blockCoord, int mouseButton) {
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseClick(mc, mouseX, mouseY, gridWidth, gridHeight, blockCoord));
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawSteps;
    }

    public static interface Layer {
        public List<DrawStep> onMouseMove(Minecraft var1, double var2, double var4, int var6, int var7, BlockCoordIntPair var8);

        public List<DrawStep> onMouseClick(Minecraft var1, double var2, double var4, int var6, int var7, BlockCoordIntPair var8);
    }
}

