/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.util.model;

import by.gdev.util.model.InternetServer;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetServerMap
extends ConcurrentHashMap<String, InternetServer> {
    private static final Logger log = LoggerFactory.getLogger(InternetServerMap.class);
    private static final long serialVersionUID = 1L;
    private volatile boolean availableInternet;
    private volatile int maxAttemps = 3;
    private int maxResponseFromServerForComparing = 10000;

    public boolean isSkippedURL(String url) {
        if (!this.availableInternet) {
            return false;
        }
        if (this.keySet().stream().filter((? super T e) -> url.contains((CharSequence)e) && !((InternetServer)this.get(e)).isAvailable()).findAny().isPresent()) {
            log.debug("skip request to server {}", (Object)url);
            return true;
        }
        return false;
    }

    public List<String> getAliveDomainsOrUseAll(List<String> list) {
        List<String> l1 = this.filter(list);
        if (l1.isEmpty()) {
            return list;
        }
        return l1;
    }

    public List<String> getAliveDomainsOrUseAllWithSort(List<String> list) {
        List<String> l1 = this.filter(list);
        if (l1.isEmpty()) {
            return list;
        }
        l1.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                long longOp2;
                Optional<Map.Entry> op1 = InternetServerMap.this.entrySet().stream().filter(e -> o1.contains((CharSequence)e.getKey())).findAny();
                Optional<Map.Entry> op2 = InternetServerMap.this.entrySet().stream().filter(e -> o2.contains((CharSequence)e.getKey())).findAny();
                long longOp1 = ((InternetServer)op1.orElseGet(() -> new AbstractMap.SimpleEntry<String, InternetServer>("", new InternetServer(true, InternetServerMap.this.maxResponseFromServerForComparing))).getValue()).getResponseTime();
                return Math.abs(longOp1 - (longOp2 = ((InternetServer)op2.orElseGet(() -> new AbstractMap.SimpleEntry<String, InternetServer>("", new InternetServer(true, InternetServerMap.this.maxResponseFromServerForComparing))).getValue()).getResponseTime())) < 100L ? 0 : Long.compare(longOp1, longOp2);
            }
        });
        return l1;
    }

    private List<String> filter(List<String> list) {
        List<String> l1 = list.stream().filter((? super T s) -> !this.isSkippedURL((String)s)).collect(Collectors.toList());
        return l1;
    }

    public boolean hasInternet() {
        return this.values().stream().anyMatch(e -> e.isAvailable());
    }

    public boolean hasInternetForDomains(List<String> domains) {
        if (!this.availableInternet) {
            return false;
        }
        List<String> l1 = this.filter(domains);
        return !l1.isEmpty();
    }

    public void setAvailableInternet(boolean availableInternet) {
        this.availableInternet = availableInternet;
    }

    public boolean isAvailableInternet() {
        return this.availableInternet;
    }

    public int getMaxAttemps() {
        return this.maxAttemps;
    }

    public void setMaxAttemps(int maxAttemps) {
        this.maxAttemps = maxAttemps;
    }
}

