/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.loot;

import at.petrak.hexcasting.common.loot.AmethystReducerFunc;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.forge.lib.ForgeHexLootMods;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ForgeHexAmethystLootMod
extends LootModifier {
    public static final Supplier<Codec<ForgeHexAmethystLootMod>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ForgeHexAmethystLootMod.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.DOUBLE.fieldOf("shardDelta").forGetter(it -> it.shardDelta)).apply((Applicative)inst, ForgeHexAmethystLootMod::new)));
    public final double shardDelta;

    public ForgeHexAmethystLootMod(LootItemCondition[] conditionsIn, double shardDelta) {
        super(conditionsIn);
        this.shardDelta = shardDelta;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LootTable injectPool = context.m_278643_().m_278676_(HexLootHandler.TABLE_INJECT_AMETHYST_CLUSTER);
        injectPool.m_79131_(context, arg_0 -> generatedLoot.add(arg_0));
        for (ItemStack stack : generatedLoot) {
            AmethystReducerFunc.doStatic(stack, context, this.shardDelta);
        }
        return generatedLoot;
    }

    public Codec<ForgeHexAmethystLootMod> codec() {
        return (Codec)ForgeHexLootMods.AMETHYST.get();
    }
}

