/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.cap;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.addldata.ADPigment;
import at.petrak.hexcasting.api.addldata.ItemDelegatingEntityIotaHolder;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.client.ClientCastingStack;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.item.PigmentItem;
import at.petrak.hexcasting.api.item.VariantItem;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import at.petrak.hexcasting.common.items.HexBaubleItem;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.forge.cap.ForgeImpetusCapability;
import at.petrak.hexcasting.forge.cap.HexCapabilities;
import at.petrak.hexcasting.forge.cap.adimpl.CapClientCastingStack;
import at.petrak.hexcasting.forge.cap.adimpl.CapEntityIotaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemHexHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemIotaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemMediaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemPigment;
import at.petrak.hexcasting.forge.cap.adimpl.CapItemVariantItem;
import at.petrak.hexcasting.forge.cap.adimpl.CapStaticIotaHolder;
import at.petrak.hexcasting.forge.cap.adimpl.CapStaticMediaHolder;
import at.petrak.hexcasting.forge.interop.curios.CuriosApiInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeCapabilityHandler {
    public static final ResourceLocation IOTA_STORAGE_CAP = HexAPI.modLoc("iota_holder");
    public static final ResourceLocation IOTA_STATIC_CAP = HexAPI.modLoc("iota_item");
    public static final ResourceLocation MEDIA_STORAGE_CAP = HexAPI.modLoc("media_holder");
    public static final ResourceLocation MEDIA_STATIC_CAP = HexAPI.modLoc("media_item");
    public static final ResourceLocation HEX_HOLDER_CAP = HexAPI.modLoc("hex_item");
    public static final ResourceLocation VARIANT_ITEM_CAP = HexAPI.modLoc("variant_item");
    public static final ResourceLocation PIGMENT_CAP = HexAPI.modLoc("pigment");
    public static final ResourceLocation CURIO_CAP = HexAPI.modLoc("curio");
    public static final ResourceLocation IMPETUS_HANDLER = HexAPI.modLoc("impetus_items");
    public static final ResourceLocation PATTERN_SPIRAL = HexAPI.modLoc("pattern_spiral");

    public static void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(ADMediaHolder.class);
        evt.register(ADIotaHolder.class);
        evt.register(ADHexHolder.class);
        evt.register(ADPigment.class);
    }

    public static void attachItemCaps(AttachCapabilitiesEvent<ItemStack> evt) {
        Object holder;
        ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        if (item instanceof MediaHolderItem) {
            holder = (MediaHolderItem)item;
            evt.addCapability(MEDIA_STORAGE_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> ForgeCapabilityHandler.lambda$attachItemCaps$0((MediaHolderItem)holder, stack)));
        } else if (stack.m_150930_(HexItems.AMETHYST_DUST)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(HexConfig.common()::dustMediaAmount, 3000, stack)));
        } else if (stack.m_150930_(Items.f_151049_)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(HexConfig.common()::shardMediaAmount, 2000, stack)));
        } else if (stack.m_150930_(HexItems.CHARGED_AMETHYST)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(HexConfig.common()::chargedCrystalMediaAmount, 1000, stack)));
        } else if (stack.m_150930_(HexItems.QUENCHED_SHARD)) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(() -> 300000L, 900, stack)));
        } else if (stack.m_150930_(HexBlocks.QUENCHED_ALLAY.m_5456_())) {
            evt.addCapability(MEDIA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.MEDIA, () -> new CapStaticMediaHolder(() -> 1200000L, 800, stack)));
        }
        item = stack.m_41720_();
        if (item instanceof IotaHolderItem) {
            holder = (IotaHolderItem)item;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.IOTA, () -> ForgeCapabilityHandler.lambda$attachItemCaps$8((IotaHolderItem)holder, stack)));
        } else if (stack.m_150930_(Items.f_42687_)) {
            evt.addCapability(IOTA_STATIC_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.IOTA, () -> new CapStaticIotaHolder(s -> new DoubleIota(Math.PI * (double)s.m_41613_()), stack)));
        }
        item = stack.m_41720_();
        if (item instanceof HexHolderItem) {
            holder = (HexHolderItem)item;
            evt.addCapability(HEX_HOLDER_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.STORED_HEX, () -> ForgeCapabilityHandler.lambda$attachItemCaps$11((HexHolderItem)holder, stack)));
        }
        if ((item = stack.m_41720_()) instanceof VariantItem) {
            VariantItem variantItem = (VariantItem)item;
            evt.addCapability(VARIANT_ITEM_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.VARIANT_ITEM, () -> new CapItemVariantItem(variantItem, stack)));
        }
        if ((item = stack.m_41720_()) instanceof PigmentItem) {
            PigmentItem pigment = (PigmentItem)item;
            evt.addCapability(PIGMENT_CAP, ForgeCapabilityHandler.provide(stack, HexCapabilities.COLOR, () -> new CapItemPigment(pigment, stack)));
        }
        if (IXplatAbstractions.INSTANCE.isModPresent("curios") && stack.m_41720_() instanceof HexBaubleItem) {
            evt.addCapability(CURIO_CAP, CuriosApiInterop.curioCap(stack));
        }
    }

    public static void attachEntityCaps(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.wrapItemEntityDelegate(item, ItemDelegatingEntityIotaHolder.ToItemEntity::new));
        } else if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.wrapItemEntityDelegate(frame, ItemDelegatingEntityIotaHolder.ToItemFrame::new));
        } else if (entity instanceof EntityWallScroll) {
            EntityWallScroll scroll = (EntityWallScroll)entity;
            evt.addCapability(IOTA_STORAGE_CAP, ForgeCapabilityHandler.wrapItemEntityDelegate(scroll, ItemDelegatingEntityIotaHolder.ToWallScroll::new));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            evt.addCapability(PATTERN_SPIRAL, ForgeCapabilityHandler.provide((Entity)player, HexCapabilities.CLIENT_CASTING_STACK, () -> new CapClientCastingStack(player, new ClientCastingStack())));
        }
    }

    public static void attachBlockEntityCaps(AttachCapabilitiesEvent<BlockEntity> evt) {
        Object object = evt.getObject();
        if (object instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus impetus = (BlockEntityAbstractImpetus)((Object)object);
            evt.addCapability(IMPETUS_HANDLER, ForgeCapabilityHandler.provide(impetus, ForgeCapabilities.ITEM_HANDLER, () -> new ForgeImpetusCapability(impetus)));
        }
    }

    private static <E extends Entity> SimpleProvider<? super CapEntityIotaHolder.Wrapper> wrapItemEntityDelegate(E entity, Function<E, ItemDelegatingEntityIotaHolder> make) {
        return ForgeCapabilityHandler.provide(entity, HexCapabilities.IOTA, () -> new CapEntityIotaHolder.Wrapper((ItemDelegatingEntityIotaHolder)make.apply(entity)));
    }

    private static <CAP> SimpleProvider<CAP> provide(Entity entity, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((Entity)entity).m_213877_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BlockEntity be, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((BlockEntity)be).m_58901_(), capability, supplier);
    }

    public static <CAP> SimpleProvider<CAP> provide(ItemStack stack, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return ForgeCapabilityHandler.provide(() -> ((ItemStack)stack).m_41619_(), capability, supplier);
    }

    private static <CAP> SimpleProvider<CAP> provide(BooleanSupplier invalidated, Capability<CAP> capability, NonNullSupplier<CAP> supplier) {
        return new SimpleProvider<CAP>(invalidated, capability, LazyOptional.of(supplier));
    }

    public static <T, U extends T> ICapabilityProvider makeProvider(Capability<T> cap, U instance) {
        LazyOptional lazyInstanceButNotReally = LazyOptional.of(() -> instance);
        return new SimpleProvider<T>(() -> false, cap, lazyInstanceButNotReally);
    }

    private static /* synthetic */ ADHexHolder lambda$attachItemCaps$11(HexHolderItem holder, ItemStack stack) {
        return new CapItemHexHolder(holder, stack);
    }

    private static /* synthetic */ ADIotaHolder lambda$attachItemCaps$8(IotaHolderItem holder, ItemStack stack) {
        return new CapItemIotaHolder(holder, stack);
    }

    private static /* synthetic */ ADMediaHolder lambda$attachItemCaps$0(MediaHolderItem holder, ItemStack stack) {
        return new CapItemMediaHolder(holder, stack);
    }

    public record SimpleProvider<CAP>(BooleanSupplier invalidated, Capability<CAP> capability, LazyOptional<CAP> instance) implements ICapabilityProvider
    {
        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.invalidated.getAsBoolean()) {
                return LazyOptional.empty();
            }
            return cap == this.capability ? this.instance.cast() : LazyOptional.empty();
        }
    }
}

