/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.Locale;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SealThingsRecipe
extends CustomRecipe {
    public final Sealee sealee;
    public static final SimpleCraftingRecipeSerializer<SealThingsRecipe> FOCUS_SERIALIZER = new SimpleCraftingRecipeSerializer(SealThingsRecipe::focus);
    public static final SimpleCraftingRecipeSerializer<SealThingsRecipe> SPELLBOOK_SERIALIZER = new SimpleCraftingRecipeSerializer(SealThingsRecipe::spellbook);

    public SealThingsRecipe(ResourceLocation id, CraftingBookCategory category, Sealee sealee) {
        super(id, category);
        this.sealee = sealee;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean foundComb = false;
        boolean foundSealee = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (this.sealee.isCorrectSealee(stack)) {
                if (foundSealee) {
                    return false;
                }
                foundSealee = true;
                continue;
            }
            if (!stack.m_204117_(HexTags.Items.SEAL_MATERIALS)) continue;
            if (foundComb) {
                return false;
            }
            foundComb = true;
        }
        return foundComb && foundSealee;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack sealee = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!this.sealee.isCorrectSealee(stack)) continue;
            sealee = stack.m_41777_();
            break;
        }
        if (!sealee.m_41619_()) {
            this.sealee.seal(sealee);
            sealee.m_41764_(1);
        }
        return sealee;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return switch (this.sealee) {
            default -> throw new IncompatibleClassChangeError();
            case Sealee.FOCUS -> FOCUS_SERIALIZER;
            case Sealee.SPELLBOOK -> SPELLBOOK_SERIALIZER;
        };
    }

    public static SealThingsRecipe focus(ResourceLocation id, CraftingBookCategory category) {
        return new SealThingsRecipe(id, category, Sealee.FOCUS);
    }

    public static SealThingsRecipe spellbook(ResourceLocation id, CraftingBookCategory category) {
        return new SealThingsRecipe(id, category, Sealee.SPELLBOOK);
    }

    public static enum Sealee implements StringRepresentable
    {
        FOCUS,
        SPELLBOOK;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isCorrectSealee(ItemStack stack) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FOCUS -> {
                    if (stack.m_150930_((Item)HexItems.FOCUS) && HexItems.FOCUS.readIotaTag(stack) != null && !ItemFocus.isSealed(stack)) {
                        yield true;
                    }
                    yield false;
                }
                case SPELLBOOK -> stack.m_150930_((Item)HexItems.SPELLBOOK) && HexItems.SPELLBOOK.readIotaTag(stack) != null && !ItemSpellbook.isSealed(stack);
            };
        }

        public void seal(ItemStack stack) {
            switch (this) {
                case FOCUS: {
                    ItemFocus.seal(stack);
                    break;
                }
                case SPELLBOOK: {
                    ItemSpellbook.setSealed(stack, true);
                }
            }
        }
    }
}

