/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.storage;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.item.VariantItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemSpellbook
extends Item
implements IotaHolderItem,
VariantItem {
    public static String TAG_SELECTED_PAGE = "page_idx";
    public static String TAG_PAGES = "pages";
    public static String TAG_PAGE_NAMES = "page_names";
    public static String TAG_SEALED = "sealed_pages";
    public static final String TAG_VARIANT = "variant";
    public static final int MAX_PAGES = 64;

    public ItemSpellbook(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        boolean sealed = ItemSpellbook.isSealed(stack);
        boolean empty = false;
        if (NBTHelper.hasNumber(stack, TAG_SELECTED_PAGE)) {
            int pageIdx = NBTHelper.getInt(stack, TAG_SELECTED_PAGE);
            int highest = ItemSpellbook.highestPage(stack);
            if (highest != 0) {
                if (sealed) {
                    tooltip.add((Component)Component.m_237110_((String)"hexcasting.tooltip.spellbook.page.sealed", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(pageIdx)).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.valueOf(highest)).m_130940_(ChatFormatting.WHITE), Component.m_237115_((String)"hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"hexcasting.tooltip.spellbook.page", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(pageIdx)).m_130940_(ChatFormatting.WHITE), Component.m_237113_((String)String.valueOf(highest)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
                }
            } else {
                empty = true;
            }
        } else {
            empty = true;
        }
        if (empty) {
            boolean overridden = NBTHelper.hasString(stack, "VisualOverride");
            if (sealed) {
                if (overridden) {
                    tooltip.add((Component)Component.m_237115_((String)"hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"hexcasting.tooltip.spellbook.empty.sealed", (Object[])new Object[]{Component.m_237115_((String)"hexcasting.tooltip.spellbook.sealed").m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
                }
            } else if (!overridden) {
                tooltip.add((Component)Component.m_237115_((String)"hexcasting.tooltip.spellbook.empty").m_130940_(ChatFormatting.GRAY));
            }
        }
        IotaHolderItem.appendHoverText(this, stack, tooltip, isAdvanced);
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    public void m_6883_(ItemStack stack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        int index = ItemSpellbook.getPage(stack, 0);
        NBTHelper.putInt(stack, TAG_SELECTED_PAGE, index);
        int shiftedIdx = Math.max(1, index);
        String nameKey = String.valueOf(shiftedIdx);
        CompoundTag names = NBTHelper.getOrCreateCompound(stack, TAG_PAGE_NAMES);
        if (stack.m_41788_()) {
            names.m_128359_(nameKey, Component.Serializer.m_130703_((Component)stack.m_41786_()));
        } else {
            names.m_128473_(nameKey);
        }
    }

    public static boolean arePagesEmpty(ItemStack stack) {
        CompoundTag tag = NBTHelper.getCompound(stack, TAG_PAGES);
        return tag == null || tag.m_128456_();
    }

    @Override
    @Nullable
    public CompoundTag readIotaTag(ItemStack stack) {
        int idx = ItemSpellbook.getPage(stack, 1);
        String key = String.valueOf(idx);
        CompoundTag tag = NBTHelper.getCompound(stack, TAG_PAGES);
        if (tag != null && tag.m_128425_(key, 10)) {
            return tag.m_128469_(key);
        }
        return null;
    }

    @Override
    public boolean writeable(ItemStack stack) {
        return !ItemSpellbook.isSealed(stack);
    }

    @Override
    public boolean canWrite(ItemStack stack, Iota datum) {
        return datum == null || !ItemSpellbook.isSealed(stack);
    }

    @Override
    public void writeDatum(ItemStack stack, Iota datum) {
        if (datum != null && ItemSpellbook.isSealed(stack)) {
            return;
        }
        int idx = ItemSpellbook.getPage(stack, 1);
        String key = String.valueOf(idx);
        CompoundTag pages = NBTHelper.getCompound(stack, TAG_PAGES);
        if (pages != null) {
            if (datum == null) {
                pages.m_128473_(key);
                NBTHelper.remove(NBTHelper.getCompound(stack, TAG_SEALED), key);
            } else {
                pages.m_128365_(key, (Tag)IotaType.serialize(datum));
            }
            if (pages.m_128456_()) {
                NBTHelper.remove(stack, TAG_PAGES);
            }
        } else if (datum != null) {
            NBTHelper.getOrCreateCompound(stack, TAG_PAGES).m_128365_(key, (Tag)IotaType.serialize(datum));
        } else {
            NBTHelper.remove(NBTHelper.getCompound(stack, TAG_SEALED), key);
        }
    }

    public static int getPage(ItemStack stack, int ifEmpty) {
        if (ItemSpellbook.arePagesEmpty(stack)) {
            return ifEmpty;
        }
        if (NBTHelper.hasNumber(stack, TAG_SELECTED_PAGE)) {
            int index = NBTHelper.getInt(stack, TAG_SELECTED_PAGE);
            if (index == 0) {
                index = 1;
            }
            return index;
        }
        return 1;
    }

    public static void setSealed(ItemStack stack, boolean sealed) {
        int index = ItemSpellbook.getPage(stack, 1);
        String nameKey = String.valueOf(index);
        CompoundTag names = NBTHelper.getOrCreateCompound(stack, TAG_SEALED);
        if (!sealed) {
            names.m_128473_(nameKey);
        } else {
            names.m_128379_(nameKey, true);
        }
        if (names.m_128456_()) {
            NBTHelper.remove(stack, TAG_SEALED);
        } else {
            NBTHelper.putCompound(stack, TAG_SEALED, names);
        }
    }

    public static boolean isSealed(ItemStack stack) {
        int index = ItemSpellbook.getPage(stack, 1);
        String nameKey = String.valueOf(index);
        CompoundTag names = NBTHelper.getCompound(stack, TAG_SEALED);
        return NBTHelper.getBoolean(names, nameKey);
    }

    public static int highestPage(ItemStack stack) {
        CompoundTag tag = NBTHelper.getCompound(stack, TAG_PAGES);
        if (tag == null) {
            return 0;
        }
        return tag.m_128431_().stream().flatMap(s -> {
            try {
                return Stream.of(Integer.valueOf(Integer.parseInt(s)));
            }
            catch (NumberFormatException e) {
                return Stream.empty();
            }
        }).max(Integer::compare).orElse(0);
    }

    public static int rotatePageIdx(ItemStack stack, boolean increase) {
        int idx = ItemSpellbook.getPage(stack, 0);
        if (idx != 0) {
            idx += increase ? 1 : -1;
            idx = Math.max(1, idx);
        }
        idx = Mth.m_14045_((int)idx, (int)0, (int)64);
        NBTHelper.putInt(stack, TAG_SELECTED_PAGE, idx);
        CompoundTag names = NBTHelper.getCompound(stack, TAG_PAGE_NAMES);
        int shiftedIdx = Math.max(1, idx);
        String nameKey = String.valueOf(shiftedIdx);
        String name = NBTHelper.getString(names, nameKey);
        if (name != null) {
            stack.m_41714_((Component)Component.Serializer.m_130701_((String)name));
        } else {
            stack.m_41787_();
        }
        return idx;
    }

    @Override
    public int numVariants() {
        return 8;
    }

    @Override
    public void setVariant(ItemStack stack, int variant) {
        if (!ItemSpellbook.isSealed(stack)) {
            NBTHelper.putInt(stack, TAG_VARIANT, this.clampVariant(variant));
        }
    }
}

