/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.ktxt.AccessorWrappers;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpExtinguish;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "MAX_DESTROY_COUNT", "", "argc", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpExtinguish
implements SpellAction {
    @NotNull
    public static final OpExtinguish INSTANCE = new OpExtinguish();
    private static final int argc = 1;
    public static final int MAX_DESTROY_COUNT = 1024;

    private OpExtinguish() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 vecPos = OperatorUtils.getVec3(args, 0, this.getArgc());
        BlockPos pos = BlockPos.m_274446_((Position)((Position)vecPos));
        env.assertPosInRangeForEditing(pos);
        Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
        RenderedSpell renderedSpell = new Spell(pos);
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return new SpellAction.Result(renderedSpell, 60000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpExtinguish$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "target", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/core/BlockPos;)V", "getTarget", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos target;

        public Spell(@NotNull BlockPos target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
        }

        @NotNull
        public final BlockPos getTarget() {
            return this.target;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            ArrayDeque todo = new ArrayDeque();
            HashSet<BlockPos> seen = new HashSet<BlockPos>();
            todo.add((Object)this.target);
            int successes = 0;
            while (!((Collection)todo).isEmpty() && successes <= 1024) {
                boolean success2;
                LivingEntity livingEntity;
                BlockPos here = (BlockPos)todo.removeFirst();
                double distFromTarget = this.target.m_123331_((Vec3i)here);
                if (!env.canEditBlockAt(here) || !(distFromTarget < 100.0) || !seen.add(here)) continue;
                BlockState blockstate = env.getWorld().m_8055_(here);
                if (!IXplatAbstractions.INSTANCE.isBreakingAllowed(env.getWorld(), here, blockstate, (Player)((livingEntity = env.getCastingEntity()) instanceof ServerPlayer ? (ServerPlayer)livingEntity : null))) continue;
                Direction[] directionArray = blockstate.m_60734_();
                if (directionArray instanceof BaseFireBlock) {
                    env.getWorld().m_7731_(here, Blocks.f_50016_.m_49966_(), 3);
                    v0 = true;
                } else if (directionArray instanceof CampfireBlock) {
                    Comparable comparable = blockstate.m_61143_((Property)CampfireBlock.f_51227_);
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockstate.getValue(CampfireBlock.LIT)");
                    if (((Boolean)comparable).booleanValue()) {
                        Item wilson = Items.f_42421_;
                        Vec3 hereVec = Vec3.m_82512_((Vec3i)((Vec3i)here));
                        ServerLevel serverLevel = env.getWorld();
                        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
                        wilson.m_6225_(AccessorWrappers.UseOnContext((Level)serverLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)wilson), new BlockHitResult(hereVec, Direction.UP, here, false)));
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                } else if (directionArray instanceof AbstractCandleBlock) {
                    Comparable comparable = blockstate.m_61143_((Property)AbstractCandleBlock.f_151895_);
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"blockstate.getValue(AbstractCandleBlock.LIT)");
                    if (((Boolean)comparable).booleanValue()) {
                        AbstractCandleBlock.m_151899_(null, (BlockState)blockstate, (LevelAccessor)((LevelAccessor)env.getWorld()), (BlockPos)here);
                        v0 = true;
                    } else {
                        v0 = false;
                    }
                } else if (directionArray instanceof NetherPortalBlock) {
                    env.getWorld().m_7731_(here, Blocks.f_50016_.m_49966_(), 3);
                    v0 = true;
                } else {
                    v0 = success2 = false;
                }
                if (success2) {
                    env.getWorld().m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)here.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)here.m_123342_() + 0.5 + Math.random() * 0.4 - 0.2, (double)here.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 2, 0.0, 0.05, 0.0, 0.0);
                    ++successes;
                }
                for (Direction dir : Direction.values()) {
                    BlockPos blockPos = here.m_121945_(dir);
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"here.relative(dir)");
                    todo.add((Object)blockPos);
                }
            }
            if (successes > 0) {
                env.getWorld().m_6263_(null, (double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 0.95f);
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.target;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(target);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.target;
            }
            return spell.copy(blockPos);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ")";
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual((Object)this.target, (Object)spell.target);
        }
    }
}

