/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.raycast;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.castables.ConstMediaAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JH\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lat/petrak/hexcasting/common/casting/actions/raycast/OpEntityRaycast;", "Lat/petrak/hexcasting/api/casting/castables/ConstMediaAction;", "()V", "argc", "", "getArgc", "()I", "mediaCost", "", "getMediaCost", "()J", "execute", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "getEntityHitResult", "Lnet/minecraft/world/phys/EntityHitResult;", "entity", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "startPos", "Lnet/minecraft/world/phys/Vec3;", "endPos", "aabb", "Lnet/minecraft/world/phys/AABB;", "isValid", "Ljava/util/function/Predicate;", "maxSqrLength", "", "hexcasting-forge-1.20.1"})
public final class OpEntityRaycast
implements ConstMediaAction {
    @NotNull
    public static final OpEntityRaycast INSTANCE = new OpEntityRaycast();
    private static final int argc = 2;
    private static final long mediaCost = 100L;

    private OpEntityRaycast() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    public long getMediaCost() {
        return mediaCost;
    }

    @Override
    @NotNull
    public List<Iota> execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        List list;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 origin = OperatorUtils.getVec3(args, 0, this.getArgc());
        Vec3 look = OperatorUtils.getVec3(args, 1, this.getArgc());
        Vec3 endp = Action.Companion.raycastEnd(origin, look);
        env.assertVecInRange(origin);
        Entity entity = (Entity)env.getCastingEntity();
        ServerLevel serverLevel = env.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
        EntityHitResult entityHitResult = this.getEntityHitResult(entity, (Level)serverLevel, origin, endp, new AABB(origin, endp), OpEntityRaycast::execute$lambda$0, 1000000.0);
        if (entityHitResult != null && env.isEntityInRange(entityHitResult.m_82443_())) {
            Entity $this$asActionResult$iv = entityHitResult.m_82443_();
            boolean $i$f$getAsActionResult = false;
            list = CollectionsKt.listOf((Object)($this$asActionResult$iv == null ? (Iota)new NullIota() : (Iota)new EntityIota($this$asActionResult$iv)));
        } else {
            list = CollectionsKt.listOf((Object)new NullIota());
        }
        return list;
    }

    @Nullable
    public final EntityHitResult getEntityHitResult(@Nullable Entity entity, @NotNull Level level, @NotNull Vec3 startPos, @NotNull Vec3 endPos, @NotNull AABB aabb, @NotNull Predicate<Entity> isValid, double maxSqrLength) {
        EntityHitResult entityHitResult;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        Intrinsics.checkNotNullParameter(isValid, (String)"isValid");
        double sqrLength = maxSqrLength;
        Entity hitEntity = null;
        Vec3 hitPos = null;
        for (Object e : level.m_6249_(entity, aabb, isValid)) {
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.world.entity.Entity");
            Entity nextEntity = (Entity)e;
            AABB hitBox = nextEntity.m_20191_().m_82400_((double)nextEntity.m_6143_());
            Optional overlapBox = hitBox.m_82371_(startPos, endPos);
            if (hitBox.m_82390_(startPos)) {
                if (!(sqrLength >= 0.0)) continue;
                hitEntity = nextEntity;
                hitPos = overlapBox.orElse(startPos);
                sqrLength = 0.0;
                continue;
            }
            if (!overlapBox.isPresent()) continue;
            Object t = overlapBox.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"overlapBox.get()");
            Vec3 maybePos = (Vec3)t;
            double sqrDist = startPos.m_82557_(maybePos);
            if (!(sqrDist < sqrLength) && !(sqrLength == 0.0)) continue;
            Entity entity2 = entity;
            if (nextEntity.m_20201_() == (entity2 != null ? entity2.m_20201_() : null)) {
                if (!(sqrLength == 0.0)) continue;
                hitEntity = nextEntity;
                hitPos = maybePos;
                continue;
            }
            hitEntity = nextEntity;
            hitPos = maybePos;
            sqrLength = sqrDist;
        }
        if (hitEntity == null) {
            entityHitResult = null;
        } else {
            Vec3 vec3 = hitPos;
            Intrinsics.checkNotNull(vec3);
            entityHitResult = new EntityHitResult(hitEntity, vec3);
        }
        return entityHitResult;
    }

    @Override
    @NotNull
    public ConstMediaAction.CostMediaActionResult executeWithOpCount(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) throws Mishap {
        return ConstMediaAction.DefaultImpls.executeWithOpCount(this, args, env);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return ConstMediaAction.DefaultImpls.operate(this, env, image, continuation);
    }

    private static final boolean execute$lambda$0(Entity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

